// this function verifies disk space in kilobytes
function verifyDiskSpace(dirPath, spaceRequired)
{
  var spaceAvailable;

  // Get the available disk space on the given path
  spaceAvailable = fileGetDiskSpaceAvailable(dirPath);

  // Convert the available disk space into kilobytes
  spaceAvailable = parseInt(spaceAvailable / 1024);

  // do the verification
  if (spaceAvailable < spaceRequired)
  {
    logComment("Insufficient disk space: " + dirPath);
    logComment("  required : " + spaceRequired + " K");
    logComment("  available: " + spaceAvailable + " K");
    return false;
  }

  return true;
}

// main code block

var err;
var gVersion = "0.2.13";
var srDest = 37;

var err = initInstall("Hermes 0.2.13", "hermes", gVersion);
logComment("initInstall: " + err);

var fProgram = getFolder("Program");
var fChrome = getFolder("Chrome");

if (verifyDiskSpace(fProgram, srDest))
{
  err = addDirectory("", gVersion, "hermes", fChrome, "hermes", true);
  logComment("addDirectory: " + err);

  registerChrome(CONTENT | DELAYED_CHROME, getFolder(fChrome, "hermes"), "content/");
/*  registerChrome(SKIN | DELAYED_CHROME, getFolder(fChrome, "hermes"), "skin/"); */

  if (getLastError() == SUCCESS)
  {
    err = performInstall(); 
    logComment("performInstall: " + err);
    alert("restart Mozilla and goto chrome://hermes/content/addpanel.xul");
  }
  else
  {
    cancelInstall(err);
  }
}

// end main
