/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * c:/builds/1813/mozilla/caps/idl/nsIScriptSecurityManager.idl
 */

package org.mozilla.interfaces;

public interface nsIScriptSecurityManager extends nsIXPCSecurityManager {

  String NS_ISCRIPTSECURITYMANAGER_IID =
    "{f4d74511-2b2d-4a14-a3e4-a392ac5ac3ff}";

  /**
     * Default CheckLoadURI permissions
     */
  long STANDARD = 0L;

  long DISALLOW_FROM_MAIL = 1L;

  long ALLOW_CHROME = 2L;

  long DISALLOW_SCRIPT_OR_DATA = 4L;

  long DISALLOW_SCRIPT = 8L;

  /**
     * Check that content from "from" can load "uri".
     *
     * Will return error code NS_ERROR_DOM_BAD_URI if the load request 
     * should be denied.
     *
     * @param from the URI causing the load
     * @param uri the URI that is being loaded
     * @param flags the permission set, see above
     */
  void checkLoadURI(nsIURI from, nsIURI uri, long flags);

  /**
     * Same as CheckLoadURI but takes string arguments for ease of use
     * by scripts
     */
  void checkLoadURIStr(String from, String uri, long flags);

  /**
     * Return true if the currently executing script has 'capability' enabled.
     */
  boolean isCapabilityEnabled(String capability);

  /**
     * Enable 'capability' in the innermost frame of the currently executing
     * script.
     */
  void enableCapability(String capability);

  /**
     * Remove 'capability' from the innermost frame of the currently
     * executing script. Any setting of 'capability' from enclosing
     * frames thus comes into effect.
     */
  void revertCapability(String capability);

  /**
     * Disable 'capability' in the innermost frame of the currently executing
     * script.
     */
  void disableCapability(String capability);

  /**
     * Allow 'certificateID' to enable 'capability.' Can only be performed
     * by code signed by the system certificate.
     */
  void setCanEnableCapability(String certificateFingerprint, String capability, short canEnable);

  /**
     * Returns OK if aSourceURI and target have the same "origin"
     * (scheme, host, and port).
     */
  void checkSameOriginURI(nsIURI aSourceURI, nsIURI aTargetURI);

}