/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Contributor(s):
 *   C.N Medappa <jrex_moz@yahoo.com><>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "JRexStreamListener.h"
using namespace JREX_JNI_UTIL;

NS_IMPL_ISUPPORTS1(JRexStreamListener, nsIStreamListener)

JRexStreamListener::JRexStreamListener(jobject streamListener){
    JNIEnv *mJEnv = JRex_GetEnv(0);
	JREX_LOGLN("JRexStreamListener()--> **** mJEnv<"<<mJEnv<<"> ****")
    if(mJEnv && streamListener)
		mStreamListener=mJEnv->NewGlobalRef(streamListener);
	else{
		JREX_LOGLN("JRexStreamListener()--> **** CREATION FAILED!!!!!!!!!****")
		throw NS_ERROR_NULL_POINTER;
	}
	JREX_LOGLN("JRexStreamListener()--> **** mStreamListener<"<<mStreamListener<<"> ****")
}

JRexStreamListener::~JRexStreamListener(){
	JNIEnv *mJEnv = JRex_GetEnv(0);
    JREX_LOGLN("~JRexStreamListener()--> **** mJEnv<"<<mJEnv<<"> ****")
    if(mJEnv && mStreamListener){
		JREX_LOGLN("~JRexStreamListener()--> **** deleting global ref ****")
		mJEnv->DeleteGlobalRef(mStreamListener);
	}
	JREX_LOGLN("~JRexStreamListener()--> **** Done ****")
}


/**
* Called to signify the beginning of an asynchronous request.
*
* @param aRequest request being observed
* @param aContext user defined context
*
* An exception thrown from onStartRequest has the side-effect of
* causing the request to be canceled.
*/

NS_IMETHODIMP JRexStreamListener::OnStartRequest(nsIRequest *aRequest, nsISupports *aContext){
	JREX_LOGLN("OnStartRequest()--> *** I AM HERE ***")
	char* reqName=nsnull;
	nsresult reqStatus=0;
	PRBool isReqPending=PR_FALSE;

	if(NOT_NULL(aRequest)){
		JREX_LOGLN("OnStartRequest()--> *** NOT_NULL aRequest ***")
		nsEmbedCString temp;
		nsresult rv=aRequest->GetName(temp);
		if(NS_SUCCEEDED(rv))
			reqName=ToNewCString(temp);
		else
			reqName=nsnull;

		JREX_LOGLN("OnStartRequest()--> *** reqName<"<<(PRUint32)reqName<<"> ***")
		aRequest->GetStatus(&rv);
		reqStatus=rv;
		aRequest->IsPending(&isReqPending);
	}else{
		JREX_LOGLN("OnStartRequest()--> *** NULL aRequest ***")
		reqName=nsnull;
		reqStatus=NS_OK;
		isReqPending=PR_FALSE;
	}

    JNIEnv *jenv = JRex_GetEnv(0);
	JREX_LOGLN("OnStartRequest()--> **** jenv<"<<jenv<<"> ****")
    if(!jenv)
    	return NS_ERROR_FAILURE;

	jstring jreqName=NULL;
	if(NOT_NULL(reqName)){
		JREX_LOGLN("OnStartRequest()--> **** reqName<"<<reqName<<"> ****")
		jreqName=jenv->NewStringUTF(reqName);
		nsMemory::Free(reqName);
	}
	JREX_LOGLN("OnStartRequest()--> **** jreqName<"<<jreqName<<"> ****")

	jboolean jrval=jenv->CallBooleanMethod(mStreamListener,onStartMID,jreqName,(jint)reqStatus,isReqPending==PR_TRUE?JNI_TRUE:JNI_FALSE
							, NULL);
    if (jenv->ExceptionOccurred()) {
		jenv->ExceptionDescribe();
		return NS_ERROR_FAILURE;
    }

	JREX_LOGLN("OnStartRequest()--> **** jrval<"<<jrval<<"> ****")
	return jrval==JNI_TRUE?NS_OK:NS_ERROR_FAILURE;
}


/**
* Called when the next chunk of data (corresponding to the request) may
* be read without blocking the calling thread.  The onDataAvailable impl
* must read exactly |aCount| bytes of data before returning.
*
* @param aRequest request corresponding to the source of the data
* @param aContext user defined context
* @param aInputStream input stream containing the data chunk
* @param aOffset current stream position
* @param aCount number of bytes available in the stream
*
* An exception thrown from onDataAvailable has the side-effect of
* causing the request to be canceled.
*/

NS_IMETHODIMP JRexStreamListener::OnDataAvailable(nsIRequest *aRequest, nsISupports *aContext, nsIInputStream *aInputStream, PRUint32 aOffset, PRUint32 aCount){
	JREX_LOGLN("OnDataAvailable()--> *** I AM HERE ***")
	char* reqName=nsnull;
	nsresult reqStatus=0;
	PRBool isReqPending=PR_FALSE;

	if(NOT_NULL(aRequest)){
		JREX_LOGLN("OnDataAvailable()--> *** NOT_NULL aRequest ***")
		nsEmbedCString temp;
		nsresult rv=aRequest->GetName(temp);
		if(NS_SUCCEEDED(rv))
			reqName=ToNewCString(temp);
		else
			reqName=nsnull;

		JREX_LOGLN("OnDataAvailable()--> *** reqName<"<<(PRUint32)reqName<<"> ***")
		aRequest->GetStatus(&rv);
		reqStatus=rv;
		aRequest->IsPending(&isReqPending);
	}else{
		JREX_LOGLN("OnDataAvailable()--> *** NULL aRequest ***")
		reqName=nsnull;
		reqStatus=NS_OK;
		isReqPending=PR_FALSE;
	}

    JNIEnv *jenv = JRex_GetEnv(0);
	JREX_LOGLN("OnDataAvailable()--> **** jenv<"<<jenv<<"> ****")
    if(!jenv)
    	return NS_ERROR_FAILURE;

	jstring jreqName=NULL;
	if(NOT_NULL(reqName)){
		JREX_LOGLN("OnDataAvailable()--> **** reqName<"<<reqName<<"> ****")
		jreqName=jenv->NewStringUTF(reqName);
		nsMemory::Free(reqName);
	}
	JREX_LOGLN("OnDataAvailable()--> **** jreqName<"<<jreqName<<"> ****")

    jobject jrexInputStreamObj = jenv->NewObject(jrexInputStreamCls,jrexInputCID,(jlong)aInputStream);
    JREX_LOGLN("OnDataAvailable()--> **** jrexInputStreamObj<"<<jrexInputStreamObj<<"> ****")
    if (jenv->ExceptionOccurred()) {
		jenv->ExceptionDescribe();
		return NS_ERROR_FAILURE;
    }
	jboolean jrval=jenv->CallBooleanMethod(mStreamListener,availableMID,jreqName,(jint)reqStatus,isReqPending==PR_TRUE?JNI_TRUE:JNI_FALSE
							, NULL, jrexInputStreamObj, (jint)aOffset, (jint)aCount );
    if (jenv->ExceptionOccurred()) {
		jenv->ExceptionDescribe();
		return NS_ERROR_FAILURE;
    }
	JREX_LOGLN("OnDataAvailable()--> **** jrval<"<<jrval<<"> ****")
	jenv->DeleteLocalRef(jrexInputStreamObj);
	return jrval==JNI_TRUE?NS_OK:NS_ERROR_FAILURE;
}

/**
* Called to signify the end of an asynchronous request.  This
* call is always preceded by a call to onStartRequest.
*
* @param aRequest request being observed
* @param aContext user defined context
* @param aStatusCode reason for stopping (NS_OK if completed successfully)
*
* An exception thrown from onStopRequest is generally ignored.
*/
NS_IMETHODIMP JRexStreamListener::OnStopRequest(nsIRequest *aRequest, nsISupports *aContext, nsresult aStatusCode){
	JREX_LOGLN("OnStopRequest()--> *** aStatusCode<"<<aStatusCode<<"> ***")
	char* reqName=nsnull;
	nsresult reqStatus=0;
	PRBool isReqPending=PR_FALSE;

	if(NOT_NULL(aRequest)){
		JREX_LOGLN("OnStopRequest()--> *** NOT_NULL aRequest ***")
		nsEmbedCString temp;
		nsresult rv=aRequest->GetName(temp);
		if(NS_SUCCEEDED(rv))
			reqName=ToNewCString(temp);
		else
			reqName=nsnull;

		JREX_LOGLN("OnStopRequest()--> *** reqName<"<<(PRUint32)reqName<<"> ***")
		aRequest->GetStatus(&rv);
		reqStatus=rv;
		aRequest->IsPending(&isReqPending);
	}else{
		JREX_LOGLN("OnStopRequest()--> *** NULL aRequest ***")
		reqName=nsnull;
		reqStatus=NS_OK;
		isReqPending=PR_FALSE;
	}

    JNIEnv *jenv = JRex_GetEnv(0);
	JREX_LOGLN("OnStopRequest()--> **** jenv<"<<jenv<<"> ****")
    if(!jenv)
    	return NS_ERROR_FAILURE;

	jstring jreqName=NULL;
	if(NOT_NULL(reqName)){
		JREX_LOGLN("OnStopRequest()--> **** reqName<"<<reqName<<"> ****")
		jreqName=jenv->NewStringUTF(reqName);
		nsMemory::Free(reqName);
	}
	JREX_LOGLN("OnStopRequest()--> **** jreqName<"<<jreqName<<"> ****")

	jenv->CallVoidMethod(mStreamListener,onStopMID,jreqName,(jint)reqStatus,isReqPending==PR_TRUE?JNI_TRUE:JNI_FALSE
							, NULL,(jint)aStatusCode);
    if (jenv->ExceptionOccurred()) {
		jenv->ExceptionDescribe();
		return NS_ERROR_FAILURE;
    }
	return NS_OK;
}

