/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Contributor(s):
 *   C.N Medappa <jrex_moz@yahoo.com><>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

	#include "JRexWindow.h"

#if defined(MOZ_WIDGET_GTK) || defined(MOZ_WIDGET_GTK2)
	#include <gtk/gtk.h>
	#include <gdk/gdkx.h>
#endif

 	static NS_DEFINE_CID(kAppShellCID, NS_APPSHELL_CID);
	static NS_DEFINE_CID(kEventQueueServiceCID, NS_EVENTQUEUESERVICE_CID);

	nsVoidArray			*JRexWindow::sWindowList		= nsnull;
	JRexWindowCreator	*JRexWindow::sJRexWindowCreator	= nsnull;

	JRexWindow::JRexWindow(nsNativeWidget hWnd, PRUint32 waitKey):mMainWnd(hWnd){
		if(IS_NULL(sWindowList)){
			JREX_LOGLN("JRexWindow()--> **** Called Me First Time ****")
			sWindowList = new nsVoidArray();
			JREX_LOGLN("JRexWindow()--> **** Created window list ****")
			nsresult rv=Init();
			JREX_EXP(rv,"JRexWindow()--> **** init Failed ****")
			JREX_LOGLN("JRexWindow()--> **** init done ****")
		}
		mIsModal					= PR_FALSE;
		mIsVisible					= PR_FALSE;
		mBrowCreated				= PR_FALSE;
		mModalDispose				= PR_FALSE;

		mProgListenerAdded			= PR_FALSE;
		mContextListenerAdded		= PR_FALSE;
		mHistoryListenerAdded		= PR_FALSE;

		mKeyListenerAdded			= PR_FALSE;
		mMouseListenerAdded			= PR_FALSE;
		mMouseMotionListenerAdded	= PR_FALSE;
		mURIContentListenerAdded	= PR_FALSE;

		mChromeFlag					= 0;
		mModalStatus				= NS_OK;

		sWindowList->AppendElement(this);
		JREX_LOGLN("JRexWindow()--> **** Added to window list <"<<this<<"> ****")
		mChromeGrip=NS_STATIC_CAST(nsIWebBrowserChrome*,this);
		JREX_LOGLN("JRexWindow()--> **** Created chrome grip ****")

#if defined(MOZ_WIDGET_GTK) || defined(MOZ_WIDGET_GTK2)
		GtkWidget* widg=nsnull;
		nsresult rv=ExecInEventQ(this,JREX_CREATE_GTK,nsnull,PR_TRUE,HandleBasicEvent,DestroyBasicEvent,(void**)&widg);
		JREX_LOGLN("JRexWindow()--> **** JREX_CREATE_GTK ExecInEventQ rv<"<<rv<<"> GTK widg <"<<widg<<">****")
		if(IS_NULL(widg))
			JREX_EXP(rv,"JRexWindow()--> **** JREX_CREATE_GTK Failed ****")
		mMainWnd=widg;
#endif
		sJRexWindowCreator->JRexWindowCreated(this,waitKey);
		JREX_LOGLN("JRexWindow()--> **** JRexWindowCreated Done ****")
	}


	JRexWindow::~JRexWindow(){
		JREX_LOGLN("~JRexWindow()--> **** I AM HERE ****")
		sWindowList->RemoveElement(this);
		JREX_LOGLN("~JRexWindow()--> **** Removed from window list <"<<this<<"> ****")
		if(sWindowList->Count()<=0){
			JREX_LOGLN("~JRexWindow--> **** All windows deleted, so deleting sWindowList ****")
			delete sWindowList;
			sWindowList=nsnull;
			JREX_LOGLN("~JRexWindow--> **** Setting window creator null ****")
			nsCOMPtr<nsIWindowWatcher> winWatcher = do_GetService(NS_WINDOWWATCHER_CONTRACTID);
			if(NOT_NULL(winWatcher))
				winWatcher->SetWindowCreator(nsnull);//will delete sJRexWindowCreator
		}
		JREX_LOGLN("~JRexWindow()--> **** DONE ****")
	}

	NS_IMPL_ADDREF(JRexWindow)
	NS_IMPL_RELEASE(JRexWindow)

	NS_INTERFACE_MAP_BEGIN(JRexWindow)
		NS_INTERFACE_MAP_ENTRY_AMBIGUOUS(nsISupports, nsIWebBrowserChrome)
		NS_INTERFACE_MAP_ENTRY(nsIWebBrowserChrome)
		NS_INTERFACE_MAP_ENTRY(nsIWebBrowserChromeFocus)
		NS_INTERFACE_MAP_ENTRY(nsIWebProgressListener)
		NS_INTERFACE_MAP_ENTRY_AMBIGUOUS(nsIEmbeddingSiteWindow, nsIEmbeddingSiteWindow2)
		NS_INTERFACE_MAP_ENTRY(nsIEmbeddingSiteWindow2)
		NS_INTERFACE_MAP_ENTRY(nsITooltipListener)
		NS_INTERFACE_MAP_ENTRY(nsIInterfaceRequestor)
		NS_INTERFACE_MAP_ENTRY(nsIContextMenuListener2)
		NS_INTERFACE_MAP_ENTRY(nsISHistoryListener)
		NS_INTERFACE_MAP_ENTRY_AMBIGUOUS(nsIDOMEventListener, nsIDOMKeyListener)
		NS_INTERFACE_MAP_ENTRY(nsIDOMKeyListener)
		NS_INTERFACE_MAP_ENTRY(nsIDOMMouseListener)
		NS_INTERFACE_MAP_ENTRY(nsIURIContentListener)
		NS_INTERFACE_MAP_ENTRY(nsISupportsWeakReference)
	NS_INTERFACE_MAP_END

	nsresult JRexWindow::InternalInit(){
		NS_ASSERTION(IS_NULL(sJRexWindowCreator),"Window creator being initalized twice");
		nsresult rv=NS_OK;
		sJRexWindowCreator = new JRexWindowCreator();
		nsCOMPtr<nsIWindowCreator2> myWinCreator;
		CallQueryInterface(sJRexWindowCreator, NS_STATIC_CAST(nsIWindowCreator2**,
                                          getter_AddRefs(myWinCreator)));
		nsCOMPtr<nsIWindowWatcher> winWatcher = do_GetService(NS_WINDOWWATCHER_CONTRACTID,&rv);
		JREX_FAILED(rv,"InternalInit()--> **** do_GetService nsIWindowWatcher Failed ****")
		JREX_LOGLN("InternalInit()--> **** do_GetService nsIWindowWatcher Done ****")
		rv=winWatcher->SetWindowCreator(myWinCreator);
		JREX_FAILED(rv,"InternalInit()--> **** SetWindowCreator Failed ****")
		JREX_LOGLN("InternalInit()--> **** SetWindowCreator Done ****")
		return rv;
	}

	nsresult JRexWindow::GetPIDOMWindow(nsPIDOMWindow **_result){
		NS_ENSURE_ARG_POINTER(_result);
  		nsCOMPtr<nsIDOMWindow> domWindow;
  		nsresult rv=mWebBrowser->GetContentDOMWindow(getter_AddRefs(domWindow));
		JREX_FAILED(rv,"GetPIDOMWindow()--> **** GetContentDOMWindow Failed ****")
		JREX_LOGLN("GetPIDOMWindow()--> **** GetContentDOMWindow Done ****")

		nsCOMPtr<nsPIDOMWindow> domWindowPrivate = do_QueryInterface(domWindow,&rv);
		JREX_FAILED(rv,"GetPIDOMWindow()--> **** nsPIDOMWindow do_QueryInterface Failed ****")
		JREX_LOGLN("GetPIDOMWindow()--> **** nsPIDOMWindow do_QueryInterface Done ****")

		nsCOMPtr<nsIDOMWindowInternal> rootWindow;
		rv=domWindowPrivate->GetPrivateRoot(getter_AddRefs(rootWindow));
		JREX_FAILED(rv,"GetPIDOMWindow()--> **** GetPrivateRoot Failed ****")
		JREX_LOGLN("GetPIDOMWindow()--> **** GetPrivateRoot Done ****")

		nsCOMPtr<nsPIDOMWindow> piWin=do_QueryInterface(rootWindow,&rv);
		JREX_FAILED(rv,"GetPIDOMWindow()--> **** nsPIDOMWindow private do_QueryInterface Failed ****")
		JREX_LOGLN("GetPIDOMWindow()--> **** nsPIDOMWindow private do_QueryInterface Done ****")
		NS_IF_ADDREF(*_result=piWin.get());
		return rv;
	}
#if defined(MOZ_WIDGET_GTK) || defined(MOZ_WIDGET_GTK2)
	static gint HandleFocusIn(GtkWidget *widget, GdkEventFocus *focusEvent, JRexWindow *window){
		window->ChangeFocus(PR_TRUE);
		return FALSE;
	}

	static gint HandleFocusOut(GtkWidget *widget, GdkEventFocus *focusEvent, JRexWindow *window){
		window->ChangeFocus(PR_FALSE);
		return FALSE;
	}
#endif

	nsresult JRexWindow::ShowInternal(PRInt32 x, PRInt32 y, PRInt32 width, PRInt32 height){
		JREX_LOGLN("ShowInternal()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_TRUE)return NS_OK;
		nsresult rv=NS_OK;

		JREX_LOGLN("ShowInternal()--> **** Using HWND <"<<mMainWnd<<"> ****")
		JREX_LOGLN("ShowInternal()--> **** Using x<"<<x<<"> y<"<<y<<"> width<"<<width<<"> height<"<<height<<"> ****")

		mWebBrowser=do_CreateInstance(NS_WEBBROWSER_CONTRACTID,&rv);
		JREX_FAILED(rv,"ShowInternal()--> **** WebBrowser do_CreateInstance Failed ****")
		JREX_LOGLN("ShowInternal()--> **** WebBrowser do_CreateInstance Done ****")

		nsCOMPtr<nsIWebBrowserChrome> myChrome;
		CallQueryInterface(mChromeGrip, NS_STATIC_CAST(nsIWebBrowserChrome**,
                                          getter_AddRefs(myChrome)));
		JREX_LOGLN("ShowInternal()--> **** Got myChrome ****")

		rv=mWebBrowser->SetContainerWindow(myChrome);
		JREX_FAILED(rv,"ShowInternal()--> **** WebBrowser SetContainerWindow Failed ****")
		JREX_LOGLN("ShowInternal()--> **** WebBrowser SetContainerWindow Done ****")

		nsCOMPtr<nsIDocShellTreeItem> docShellTreeItem(do_QueryInterface(mWebBrowser,&rv));
		JREX_FAILED(rv,"ShowInternal()--> **** WebBrowser do_QueryInterface nsIDocShellTreeItem Failed ****")
		JREX_LOGLN("ShowInternal()--> **** WebBrowser do_QueryInterface nsIDocShellTreeItem Done ****")

		rv=docShellTreeItem->SetItemType(nsIDocShellTreeItem::typeContentWrapper);
		JREX_FAILED(rv,"ShowInternal()--> **** docShellTreeItem SetItemType Failed ****")
		JREX_LOGLN("ShowInternal()--> **** docShellTreeItem SetItemType Done ****")

  		mBaseWindow = do_QueryInterface(mWebBrowser,&rv);
		JREX_FAILED(rv,"ShowInternal()--> **** nsIBaseWindow do_QueryInterface Failed ****")
		JREX_LOGLN("ShowInternal()--> **** nsIBaseWindow do_QueryInterface Done ****")

		rv=mBaseWindow->InitWindow(mMainWnd,nsnull,x,y,width,height);
		JREX_FAILED(rv,"ShowInternal()--> **** nsIBaseWindow InitWindow Failed ****")
		JREX_LOGLN("ShowInternal()--> **** nsIBaseWindow InitWindow Done ****")

		rv=mBaseWindow->Create();
		JREX_FAILED(rv,"ShowInternal()--> **** nsIBaseWindow Create Failed ****")
		JREX_LOGLN("ShowInternal()--> **** nsIBaseWindow Create Done ****")

        rv=mBaseWindow->SetPositionAndSize(x,y,width,height,PR_TRUE);
		JREX_FAILED(rv,"ShowInternal()--> **** nsIBaseWindow SetPositionAndSize Failed ****")
		JREX_LOGLN("ShowInternal()--> **** nsIBaseWindow SetPositionAndSize Done ****")

	    rv=mBaseWindow->SetVisibility(mIsVisible);
		JREX_FAILED(rv,"ShowInternal()--> **** nsIBaseWindow SetVisibility Failed ****")
		JREX_LOGLN("ShowInternal()--> **** nsIBaseWindow SetVisibility Done ****")

		nsCOMPtr<nsIWebBrowserFocus> webBrowserFocus = do_QueryInterface(mWebBrowser,&rv);
		JREX_FAILED(rv,"ShowInternal()--> **** nsIWebBrowserFocus do_QueryInterface Failed ****")
		JREX_LOGLN("ShowInternal()--> **** nsIWebBrowserFocus do_QueryInterface Done ****")
		rv=webBrowserFocus->Activate();
		JREX_FAILED(rv,"ShowInternal()--> **** Activate Failed ****")
		JREX_LOGLN("ShowInternal()--> **** Activate Done ****")

#if defined(MOZ_WIDGET_GTK) || defined(MOZ_WIDGET_GTK2)
  		GtkWidget *child = GTK_BIN(mMainWnd)->child;
  		gtk_signal_connect_while_alive(GTK_OBJECT(child),"focus_in_event",GTK_SIGNAL_FUNC(HandleFocusIn),
				 							this,GTK_OBJECT(child));
  		gtk_signal_connect_while_alive(GTK_OBJECT(child),"focus_out_event",GTK_SIGNAL_FUNC(HandleFocusOut),
				 							this,GTK_OBJECT(child));
#endif
		mWebNavigation= do_QueryInterface(mWebBrowser,&rv);
		JREX_FAILED(rv,"ShowInternal()--> **** nsIWebNavigation do_QueryInterface Failed ****")
		JREX_LOGLN("ShowInternal()--> **** nsIWebNavigation do_QueryInterface Done ****")

		//We add nsIWebProgressListener here, as adding when required may be late
		//We need it for calling SizeToContent etc.
		nsCOMPtr<nsISupportsWeakReference> supportsWeak;
		rv=CallQueryInterface(this, NS_STATIC_CAST(nsISupportsWeakReference**,getter_AddRefs(supportsWeak)));
		JREX_FAILED(rv,"ShowInternal()--> **** CallQueryInterface nsISupportsWeakReference Failed ****")
		JREX_LOGLN("ShowInternal()--> **** CallQueryInterface nsISupportsWeakReference Done ****")

		nsCOMPtr<nsIWeakReference> weakRef;
		rv=supportsWeak->GetWeakReference(getter_AddRefs(weakRef));
		JREX_FAILED(rv,"ShowInternal()--> **** GetWeakReference Failed ****")
		JREX_LOGLN("ShowInternal()--> **** GetWeakReference Done ****")

		rv=mWebBrowser->AddWebBrowserListener(weakRef,nsIWebProgressListener::GetIID());
		JREX_FAILED(rv,"ShowInternal()--> **** AddWebBrowserListener Failed ****")
		JREX_LOGLN("ShowInternal()--> **** AddWebBrowserListener Done rv <"<<rv<<"> ****")

		nsCOMPtr<nsPIDOMWindow> piWin;
		rv=GetPIDOMWindow(getter_AddRefs(piWin));
		JREX_FAILED(rv,"ShowInternal()--> **** GetPIDOMWindow Failed ****")
		JREX_LOGLN("ShowInternal()--> **** GetPIDOMWindow Done ****")

		nsCOMPtr<nsIChromeEventHandler> cHandler;
		rv=piWin->GetChromeEventHandler(getter_AddRefs(cHandler));
		JREX_FAILED(rv,"ShowInternal()--> **** GetChromeEventHandler Failed ****")
		JREX_LOGLN("ShowInternal()--> **** GetChromeEventHandler Done ****")

		mEventReceiver = do_QueryInterface(cHandler,&rv);
		JREX_FAILED(rv,"ShowInternal()--> **** nsIDOMEventReceiver do_QueryInterface Failed ****")
		JREX_LOGLN("ShowInternal()--> **** nsIDOMEventReceiver do_QueryInterface Done ****")

		mCmdManager=do_GetInterface(mWebBrowser, &rv);
		JREX_FAILED(rv,"ShowInternal()--> **** mCmdManager do_GetInterface Failed ****")
		JREX_LOGLN("ShowInternal()--> **** mCmdManager do_GetInterface Done ****")
		mBrowCreated=PR_TRUE;
		return rv;
    }

#if defined(MOZ_WIDGET_GTK) || defined(MOZ_WIDGET_GTK2)
	nsresult JRexWindow::GotVisualInternal(nsNativeWidget parentWnd){
		JREX_LOGLN("GotVisualInternal()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		XReparentWindow(GDK_DISPLAY(),GDK_WINDOW_XWINDOW(((GtkWidget*)mMainWnd)->window), (Window)parentWnd, 0, 0);
		JREX_LOGLN("GotVisualInternal()--> **** XReparentWindow DONE !!!!***")
		gtk_widget_show((GtkWidget*)mMainWnd);
		JREX_LOGLN("GotVisualInternal()--> **** gtk_widget_show DONE !!!!***")
		return NS_OK;
	}
#endif

	nsresult JRexWindow::DisposeInternal(){
		JREX_LOGLN("DisposeInternal()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE){
			delete this;
			return NS_OK;
		}
		nsresult rv=NS_OK;
		rv=gEventQ->RevokeEvents(this);
		JREX_LOGLN("DisposeInternal()--> **** gEventQ RevokeEvents rv<"<<rv<<">****")
		rv=CancelPrintPreviewInternal();
		JREX_LOGLN("DisposeInternal()--> **** CancelPrintPreviewInternal rv<"<<rv<<">****")
		rv=CancelPrintInternal();
		JREX_LOGLN("DisposeInternal()--> **** CancelPrintInternal rv<"<<rv<<">****")
		rv=RemoveProgressListener();
		JREX_LOGLN("DisposeInternal()--> **** RemoveProgressListener rv<"<<rv<<">****")
		rv=RemoveContextMenuListenerInternal();
		JREX_LOGLN("DisposeInternal()--> **** RemoveContextMenuListenerInternal rv<"<<rv<<">****")
		rv=RemoveHistoryListenerInternal();
		JREX_LOGLN("DisposeInternal()--> **** RemoveHistoryListenerInternal rv<"<<rv<<">****")

		mBrowCreated=PR_FALSE;
		JREX_LOGLN("DisposeInternal()--> **** Disposing JRexWindow. ****")
		if(NOT_NULL(mWebBrowser)){
			nsCOMPtr<nsISupportsWeakReference> supportsWeak;
			rv=CallQueryInterface(this, NS_STATIC_CAST(nsISupportsWeakReference**,getter_AddRefs(supportsWeak)));
			JREX_LOGLN("DisposeInternal()--> **** CallQueryInterface nsISupportsWeakReference rv <"<<rv<<"> ****")
			if (NS_SUCCEEDED(rv)){
				nsCOMPtr<nsIWeakReference> weakRef;
				rv=supportsWeak->GetWeakReference(getter_AddRefs(weakRef));
				if (NS_SUCCEEDED(rv)){
					rv=mWebBrowser->RemoveWebBrowserListener(weakRef,nsIWebProgressListener::GetIID());
					JREX_LOGLN("DisposeInternal()--> **** RemoveWebBrowserListener rv <"<<rv<<"> ****")
				}
			}
			if(NOT_NULL(mBaseWindow)){
				rv=mBaseWindow->Destroy();
				JREX_LOGLN("DisposeInternal()--> **** mBaseWindow Destroy rv <"<<rv<<">****")
			}
			rv=mWebBrowser->SetContainerWindow(nsnull);
			JREX_LOGLN("DisposeInternal()--> **** SetContainerWindow set null rv <"<<rv<<"> ****")
		}
		mBaseWindow=nsnull;
		mWebNavigation=nsnull;
		mCmdManager=nsnull;
		mWebBrowser=nsnull;
		mChromeGrip=nsnull;
		mMainWnd=nsnull;
		return rv;
	}


	void JRexWindow::AbortWindowCreation(PRUint32 waitKey){
		JREX_LOGLN("AbortWindowCreation()--> **** waitKey<"<<waitKey<<"> ****")
		if(NOT_NULL(sJRexWindowCreator))
			sJRexWindowCreator->JRexWindowCreated(nsnull,waitKey);
	}

	PRBool JRexWindow::IsWindowAvailable(JRexWindow* checkWin){
		if(IS_NULL(sWindowList) || IS_NULL(checkWin))return PR_FALSE;
  		PRInt32 count = sWindowList->Count();
  		for (int i = 0; i < count; i++) {
			if(checkWin==sWindowList->ElementAt(i))
				return PR_TRUE;
		}
		return PR_FALSE;
	}

	JRexWindow* JRexWindow::GetJRexWindow(nsIWebBrowserChrome *chrome){
		if(IS_NULL(sWindowList) || IS_NULL(chrome))return nsnull;
  		PRInt32 count = sWindowList->Count();
  		for (int i = 0; i < count; i++) {
			JRexWindow *tmp = NS_STATIC_CAST(JRexWindow *, sWindowList->ElementAt(i));
			if(tmp->mChromeGrip==chrome)
			return tmp;
		}
		return nsnull;
	}


	void JRexWindow::SayGoodBye(){
		JREX_LOGLN("SayGoodBye()--> **** NOT ALL WINDOWS ARE DIPOSED <"<<(NOT_NULL(sWindowList)?"TRUE":"FALSE")<<"> ****")
		while (NOT_NULL(sWindowList) && sWindowList->Count()>0) {
			JRexWindow *tmp = NS_STATIC_CAST(JRexWindow *, sWindowList->ElementAt(0));
			JREX_LOGLN("SayGoodBye()--> **** Disposing JRexWindow<"<<tmp<<">  ****")
			if(tmp->mIsModal){//TODO need to sync?
				JREX_LOGLN("SayGoodBye()--> **** Disposing Modal JRexWindow<"<<tmp<<"> ****")
				tmp->mModalDispose=PR_FALSE;
				tmp->mModalStatus=NS_OK;
				tmp->mIsModal=PR_FALSE;
				PR_Sleep(1*PR_TicksPerSecond()/1000);
			}
			if(IsEventQThread())tmp->DisposeInternal();
			nsresult srv=NS_OK;
			nsresult rv=ExecInEventQ(tmp,JREX_DISPOSE,nsnull,PR_TRUE,HandleBasicEvent,DestroyBasicEvent,(void**)&srv);
			JREX_LOGLN("SayGoodBye()--> **** Disposing JRexWindow<"<<tmp<<"> Done  srv <"<<srv<<"> ****")
		}
	}


	PRBool JRexWindow::IsEventQThread(){
		PLEventQueue *nQ=nsnull;
		gEventQ->GetPLEventQueue(&nQ);
		return nQ?PL_IsQueueOnCurrentThread(nQ):PR_FALSE;
	}

	nsresult JRexWindow::Init(){
		JREX_LOGLN("Init()--> **** I AM HERE ****")
		if(IsEventQThread())return InternalInit();
		nsresult srv=NS_OK;
		nsresult rv=ExecInEventQ(this,JREX_CREATE,nsnull,PR_TRUE,HandleBasicEvent,DestroyBasicEvent,(void**)&srv);
		JREX_LOGLN("Init()--> **** ExecInEventQ rv<"<<rv<<"> srv<"<<srv<<"> ****")
		return srv;
	}

	nsresult JRexWindow::Show(PRInt32 x, PRInt32 y, PRInt32 width, PRInt32 height){
		JREX_LOGLN("Show()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_TRUE)return NS_OK;
		JREX_LOGLN("Show()--> **** Using HWND <"<<mMainWnd<<"> x<"<<x<<"> y<"<<y<<"> width<"<<width<<"> height<"<<height<<"> ****")
		if(IsEventQThread())
			return ShowInternal(x,y,(width<1?1:width),(height<1?1:height));

		PRInt32* temp=new PRInt32[4];
		if(!temp)return NS_ERROR_OUT_OF_MEMORY;
		temp[0]=x;
		temp[1]=y;
		temp[2]=(width<1?1:width);
		temp[3]=(height<1?1:height);
		nsresult srv=NS_OK;
		nsresult rv=ExecInEventQ(this,JREX_SHOW,temp,PR_TRUE,HandleBasicEvent,DestroyBasicEvent,(void**)&srv);
		JREX_LOGLN("Show()--> **** ExecInEventQ rv<"<<rv<<"> srv<"<<srv<<"> ****")
		return srv;
	}

#if defined(MOZ_WIDGET_GTK) || defined(MOZ_WIDGET_GTK2)
	nsresult JRexWindow::GotVisual(nsNativeWidget parentWnd){
		JREX_LOGLN("GotVisual()--> **** mBrowCreated<"<<mBrowCreated<<"> parentWnd<"<<parentWnd<<">****")
		if(IsEventQThread())return GotVisualInternal(parentWnd);
		nsresult rv=ExecInEventQ(this,JREX_GOT_VISUAL,(void*)parentWnd,PR_FALSE,HandleBasicEvent,DestroyBasicEvent,nsnull);
		JREX_LOGLN("GotVisual()--> **** ExecInEventQ rv<"<<rv<<"> ****")
		return rv;
	}
#endif

	nsresult JRexWindow::Dispose(){
		JREX_LOGLN("Dispose()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(IsEventQThread())return DisposeInternal();
		nsresult rv=ExecInEventQ(this,JREX_DISPOSE,nsnull,PR_FALSE,HandleBasicEvent,DestroyBasicEvent,nsnull);
		JREX_LOGLN("Dispose()--> **** ExecInEventQ rv<"<<rv<<">  ****")
		return rv;
	}

	nsresult JRexWindow::ModalDispose(){
		if(mBrowCreated==PR_FALSE)return NS_OK;
		mModalDispose=PR_TRUE;
		mModalStatus=NS_OK;
		mIsModal=PR_FALSE;
		return NS_OK;
	}


	nsresult JRexWindow::SetBoundsInternal(PRInt32 x, PRInt32 y, PRInt32 width,PRInt32 height){
		JREX_LOGLN("SetBoundsInternal()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE)return NS_OK;
		JREX_LOGLN("SetBoundsInternal()--> **** Using x<"<<x<<"> y<"<<y<<"> width<"<<width<<"> height<"<<height<<"> ****")
#if defined(MOZ_WIDGET_GTK) || defined(MOZ_WIDGET_GTK2)
		if(NOT_NULL(mMainWnd)){
			gtk_widget_set_usize((GtkWidget*)mMainWnd,width,height);
			gdk_window_move_resize(((GtkWidget*)mMainWnd)->window,x,y,width,height);
			JREX_LOGLN("SetBoundsInternal()--> gdk_window_move_resize Done ****")
		}
#endif
		nsresult rv=mBaseWindow->SetPositionAndSize(x,y,width,height,PR_FALSE);
		JREX_LOGLN("SetBoundsInternal()--> SetPositionAndSize rv<"<<rv<<"> ****")
		return rv;
	}


	nsresult JRexWindow::SetBounds(PRInt32 x, PRInt32 y, PRInt32 width,PRInt32 height){
		JREX_LOGLN("SetBounds()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE)return NS_OK;
		JREX_LOGLN("SetBounds()--> **** Using x<"<<x<<"> y<"<<y<<"> width<"<<width<<"> height<"<<height<<"> ****")
		if(IsEventQThread())return SetBoundsInternal(x,y,(width<1?1:width),(height<1?1:height));
		PRInt32* temp=new PRInt32[4];
		if(!temp)return NS_ERROR_OUT_OF_MEMORY;
		temp[0]=x;
		temp[1]=y;
		temp[2]=(width<1?1:width);
		temp[3]=(height<1?1:height);
		nsresult rv=ExecInEventQ(this,JREX_SET_BOUNDS,temp,PR_FALSE,HandleBasicEvent,DestroyBasicEvent,nsnull);
		JREX_LOGLN("SetBounds()--> **** ExecInEventQ rv<"<<rv<<"> ****")
		return rv;
	}

	nsresult JRexWindow::GetBounds(PRInt32 *x, PRInt32 *y, PRInt32 *width,PRInt32 *height){
		JREX_LOGLN("GetBounds()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE)return NS_ERROR_NOT_INITIALIZED;
		NS_ENSURE_ARG_POINTER(x);NS_ENSURE_ARG_POINTER(y);
		NS_ENSURE_ARG_POINTER(width);NS_ENSURE_ARG_POINTER(height);
		if(IsEventQThread())return mBaseWindow->GetPositionAndSize(x,y,width,height);

		PRInt32* temp=nsnull;
		nsresult rv=ExecInEventQ(this,JREX_GET_BOUNDS,nsnull,PR_TRUE,HandleBasicEvent,DestroyBasicEvent,(void**)&temp);
		JREX_LOGLN("GetBounds()--> **** ExecInEventQ rv<"<<rv<<"> temp<"<<temp<<">****")
		if(NS_SUCCEEDED(rv) && temp){
			*x=temp[0];
			*y=temp[1];
			*width=temp[2];
			*height=temp[3];
			delete temp;
		}
		JREX_LOGLN("GetBounds()--> **** Got x<"<<*x<<"> y<"<<*y<<"> width<"<<*width<<"> height<"<<*height<<"> ****")
		return rv;
	}

	nsresult JRexWindow::SetVisible(PRBool visible){
		JREX_LOGLN("SetVisible()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE){
			mIsVisible=visible;
			return NS_OK;
		}
		if(IsEventQThread())return mBaseWindow->SetVisibility(visible);
		nsresult rv=ExecInEventQ(this,JREX_SET_VISIBLE,(void*)visible,PR_FALSE,HandleBasicEvent,DestroyBasicEvent,nsnull);
		JREX_LOGLN("SetVisible()--> **** ExecInEventQ rv<"<<rv<<"> ****")
		return rv;
	}

	nsresult JRexWindow::IsVisible(PRBool *visible){
		JREX_LOGLN("IsVisible()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE)return NS_ERROR_NOT_INITIALIZED;
		NS_ENSURE_ARG_POINTER(visible);
		*visible=mIsVisible;
		return NS_OK;
	}

	nsresult JRexWindow::IsVisibleInternal(PRBool *visible){
		JREX_LOGLN("IsVisibleInternal()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		NS_ENSURE_ARG_POINTER(visible);
		if(IsEventQThread())return mBaseWindow->GetVisibility(visible);
		PRBool temp=PR_FALSE;
		nsresult rv=ExecInEventQ(this,JREX_IS_VISIBLE,nsnull,PR_TRUE,HandleBasicEvent,DestroyBasicEvent,(void**)&temp);
		JREX_LOGLN("GetBounds()--> **** ExecInEventQ rv<"<<rv<<"> visible<"<<temp<<">****")
		if(NS_SUCCEEDED(rv))
			*visible=temp;
		return rv;
	}


	nsresult JRexWindow::SetEnabled(PRBool enable){
		JREX_LOGLN("SetEnabled()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE)return NS_OK;
		if(IsEventQThread())return mBaseWindow->SetEnabled(enable);
		nsresult rv=ExecInEventQ(this,JREX_SET_ENABLED,(void*)enable,PR_FALSE,HandleBasicEvent,DestroyBasicEvent,nsnull);
		JREX_LOGLN("SetEnabled()--> **** ExecInEventQ rv<"<<rv<<"> ****")
		return rv;
	}

	nsresult JRexWindow::IsEnabled(PRBool *enable){
		JREX_LOGLN("IsEnabled()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE)return NS_ERROR_NOT_INITIALIZED;
		NS_ENSURE_ARG_POINTER(enable);
		if(IsEventQThread())return mBaseWindow->GetEnabled(enable);
		PRBool temp=PR_FALSE;
		nsresult rv=ExecInEventQ(this,JREX_IS_ENABLED,nsnull,PR_TRUE,HandleBasicEvent,DestroyBasicEvent,(void**)&temp);
		JREX_LOGLN("IsEnabled()--> **** ExecInEventQ rv<"<<rv<<"> enable<"<<temp<<">****")
		if(NS_SUCCEEDED(rv))
			*enable=temp;
		return rv;
	}

	nsresult JRexWindow::GetBaseTitle(PRUnichar * *aTitle){
		JREX_LOGLN("GetBaseTitle()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE)return NS_ERROR_NOT_INITIALIZED;
		NS_ENSURE_ARG_POINTER(aTitle);
		if(IsEventQThread())return mBaseWindow->GetTitle(aTitle);
		PRUnichar* temp=nsnull;
		nsresult rv=ExecInEventQ(this,JREX_GET_TITLE,nsnull,PR_TRUE,HandleBasicEvent,DestroyBasicEvent,(void**)&temp);
		JREX_LOGLN("GetBaseTitle()--> **** ExecInEventQ rv<"<<rv<<"> title<"<<temp<<">****")
		if(NS_SUCCEEDED(rv) && temp)
			*aTitle=temp;
		return rv;
	}

	nsresult JRexWindow::SetBaseTitle(const PRUnichar * aTitle){
		JREX_LOGLN("SetBaseTitle()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE)return NS_OK;
		JREX_LOGLN("SetBaseTitle()--> **** aTitle <"<<aTitle<<">****")
		if(IsEventQThread())return mBaseWindow->SetTitle(aTitle);
		nsresult rv=ExecInEventQ(this,JREX_SET_TITLE,(void*)aTitle,PR_FALSE,HandleBasicEvent,DestroyBasicEvent,nsnull);
		JREX_LOGLN("SetBaseTitle()--> **** ExecInEventQ rv<"<<rv<<"> ****")
		return rv;
	}

	nsresult JRexWindow::Repaint(PRBool force){
		JREX_LOGLN("Repaint()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE)return NS_OK;
		JREX_LOGLN("Repaint()--> **** force <"<<force<<">****")
		if(IsEventQThread())return mBaseWindow->Repaint(force);
		nsresult rv=ExecInEventQ(this,JREX_REPAINT,(void*)force,PR_FALSE,HandleBasicEvent,DestroyBasicEvent,nsnull);
		JREX_LOGLN("Repaint()--> **** ExecInEventQ rv<"<<rv<<"> ****")
		return rv;
	}

	nsresult JRexWindow::ChangeFocusInternal(PRBool focusGained){
		nsCOMPtr<nsPIDOMWindow> piWin;
		nsresult rv=GetPIDOMWindow(getter_AddRefs(piWin));
		if (NS_SUCCEEDED(rv) && piWin){
			rv=focusGained?piWin->Activate():piWin->Deactivate();
			nsCOMPtr<nsIFocusController> focusController;
			rv=piWin->GetRootFocusController(getter_AddRefs(focusController));
			if (focusController)focusController->SetActive(PR_TRUE);
		}
		return rv;
	}

	nsresult JRexWindow::ChangeFocus(PRBool focusGained){
		JREX_LOGLN("ChangeFocus()--> **** mBrowCreated<"<<mBrowCreated<<"> ****")
		if(mBrowCreated==PR_FALSE)return NS_OK;
		JREX_LOGLN("ChangeFocus()--> **** focusGained <"<<focusGained<<"> ****")
		if(IsEventQThread())return ChangeFocusInternal(focusGained);
		nsresult rv=ExecInEventQ(this,JREX_CHANGE_FOCUS,(void*)focusGained,PR_FALSE,HandleBasicEvent,DestroyBasicEvent,nsnull);
		JREX_LOGLN("ChangeFocus()--> **** ExecInEventQ rv<"<<rv<<"> ****")
		return rv;
	}

	nsresult JRexWindow::ExecInEventQ(JRexWindow *window, PRUint16 eventType,void* eventData, PRBool isSync,
								PLHandleEventProc handler, PLDestroyEventProc destructor, void** _result){
		JREX_LOGLN("ExecInEventQ()--> **** window<"<<window<<"> eventType<"<<eventType<<">  eventData<"<<eventData<<">****")
		if(isSync)
			NS_ENSURE_ARG_POINTER(_result);

		JRexBasicEvent* event = new JRexBasicEvent;
		nsresult rv;
		if (event) {
			NS_ADDREF(window);
			JREX_LOGLN("ExecInEventQ()--> **** gEventQ JRexBasicEvent Created ****")
			rv=gEventQ->InitEvent(NS_REINTERPRET_CAST(PLEvent*, event),
										window,handler,destructor);
			JREX_LOGLN("ExecInEventQ()--> **** gEventQ InitEvent rv<"<<rv<<">  ****")
			if(NS_FAILED(rv))
				return rv;
			event->window=window;
			event->eventType=eventType;
			event->eventData=eventData;
			rv = gEventQ->EnterMonitor();
			if (NS_SUCCEEDED(rv)){
				if(isSync){
					void* rVal;
					rv = gEventQ->PostSynchronousEvent(NS_REINTERPRET_CAST(PLEvent*, event),&rVal);
					JREX_LOGLN("ExecInEventQ()--> **** gEventQ  PostSynchronousEvent rv<"<<rv<<"> rVal<"<<rVal<<"> ****")
					if(NS_SUCCEEDED(rv))
						*_result=rVal;
				}else{
					rv = gEventQ->PostEvent(NS_REINTERPRET_CAST(PLEvent*, event));
					JREX_LOGLN("ExecInEventQ()--> **** gEventQ  PostEvent rv<"<<rv<<"> ****")
				}
			}
			gEventQ->ExitMonitor();
			if (NS_FAILED(rv)){
				JREX_LOGLN("ExecInEventQ()--> **** POSTING EVENT FAILED rv<"<<rv<<"> ****")
				PR_DELETE(event);
			}
		}else
			rv=NS_ERROR_OUT_OF_MEMORY;
		JREX_LOGLN("ExecInEventQ()--> **** returning rv<"<<rv<<"> ****")
		return rv;
	}

	void* PR_CALLBACK JRexWindow::HandleBasicEvent(PLEvent* aEvent){
		JRexBasicEvent* event = NS_REINTERPRET_CAST(JRexBasicEvent*, aEvent);
		nsresult rv=NS_OK;
		JREX_LOGLN("HandleBasicEvent()--> **** JRexWindow <"<<event->window<<"> ****")
		if(event->eventType!=JREX_CREATE
				&& JRexWindow::IsWindowAvailable(event->window)==PR_FALSE)
			return (void*)rv;

		switch(event->eventType){
			case JREX_CREATE:
			{
				JREX_LOGLN("HandleBasicEvent JREX_CREATE EVENT!!!****")
				rv=InternalInit();
				JREX_LOGLN("HandleBasicEvent InternalInit rv<"<<rv<<">****")
				break;
			}
			case JREX_SHOW:
			{
				JREX_LOGLN("HandleBasicEvent JREX_SHOW EVENT!!!****")
				PRInt32* temp=NS_REINTERPRET_CAST(PRInt32*, event->eventData);
				JREX_LOGLN("HandleBasicEvent()--> **** Using x<"<<temp[0]<<"> y<"<<temp[1]<<"> width<"<<temp[2]<<"> height<"<<temp[3]<<"> ****")
				rv=event->window->ShowInternal(temp[0],temp[1],temp[2],temp[3]);
				JREX_LOGLN("HandleBasicEvent ShowInternal rv<"<<rv<<">****")
				break;
			}
			case JREX_DISPOSE:
			{
				JREX_LOGLN("HandleBasicEvent JREX_DISPOSE EVENT!!!****")
				rv=event->window->DisposeInternal();
				JREX_LOGLN("HandleBasicEvent DisposeInternal rv<"<<rv<<">****")
				break;
			}
#if defined(MOZ_WIDGET_GTK) || defined(MOZ_WIDGET_GTK2)
			case JREX_CREATE_GTK:
			{
				JREX_LOGLN("HandleBasicEvent JREX_CREATE_GTK EVENT!!!****")
				GtkWidget* widg=gtk_window_new (GTK_WINDOW_POPUP);
				if(NOT_NULL(widg))
					gtk_widget_realize(widg);
				return (void*)widg;
			}
			case JREX_GOT_VISUAL:
			{
				JREX_LOGLN("HandleBasicEvent JREX_GOT_VISUAL EVENT!!!****")
				nsNativeWidget parentWnd=NS_REINTERPRET_CAST(nsNativeWidget, event->eventData);
				JREX_LOGLN("HandleBasicEvent parentWnd <"<<parentWnd<<">****")
				rv=event->window->GotVisualInternal(parentWnd);
				JREX_LOGLN("HandleBasicEvent GotVisualInternal rv<"<<rv<<">****")
				break;
			}
#endif
			case JREX_GET_BOUNDS:
			{
				JREX_LOGLN("HandleBasicEvent JREX_GET_BOUNDS EVENT!!!****")
				PRInt32* temp=new PRInt32[4];
				if(!temp)return (void*)NS_ERROR_OUT_OF_MEMORY;
				rv=event->window->mBaseWindow->GetPositionAndSize(&temp[0],&temp[1],&temp[2],&temp[3]);
				JREX_LOGLN("HandleBasicEvent()--> **** GetPositionAndSize rv<"<<rv<<"> Got x<"<<temp[0]<<"> y<"<<temp[1]<<"> width<"<<temp[2]<<"> height<"<<temp[3]<<"> ****")
				return (void*)temp;
			}
			case JREX_SET_BOUNDS:
			{
				JREX_LOGLN("HandleBasicEvent JREX_SET_BOUNDS EVENT!!!****")
				PRInt32* temp=NS_REINTERPRET_CAST(PRInt32*, event->eventData);
				JREX_LOGLN("HandleBasicEvent()--> **** Using x<"<<temp[0]<<"> y<"<<temp[1]<<"> width<"<<temp[2]<<"> height<"<<temp[3]<<"> ****")
				rv=event->window->SetBoundsInternal(temp[0],temp[1],temp[2],temp[3]);
				JREX_LOGLN("HandleBasicEvent SetBoundsInternal rv<"<<rv<<">****")
				break;
			}
			case JREX_IS_VISIBLE:
			{
				JREX_LOGLN("HandleBasicEvent JREX_IS_VISIBLE EVENT!!!****")
				PRBool visible=PR_FALSE;
				rv=event->window->mBaseWindow->GetVisibility(&visible);
				JREX_LOGLN("HandleBasicEvent()--> **** GetVisibility rv<"<<rv<<"> visible<"<<visible<<"> ****")
				return (void*)visible;
			}
			case JREX_SET_VISIBLE:
			{
				JREX_LOGLN("HandleBasicEvent JREX_SET_VISIBLE EVENT!!!****")
				PRBool visible=(PRBool)event->eventData;
				JREX_LOGLN("HandleBasicEvent()--> **** Using visible<"<<visible<<"> ****")
				rv=event->window->mBaseWindow->SetVisibility(visible);
				JREX_LOGLN("HandleBasicEvent SetVisibility rv<"<<rv<<">****")
				break;
			}
			case JREX_IS_ENABLED:
			{
				JREX_LOGLN("HandleBasicEvent JREX_IS_ENABLED EVENT!!!****")
				PRBool enabled=PR_FALSE;
				rv=event->window->mBaseWindow->GetEnabled(&enabled);
				JREX_LOGLN("HandleBasicEvent()--> **** GetEnabled rv<"<<rv<<"> enabled<"<<enabled<<"> ****")
				return (void*)enabled;
			}
			case JREX_SET_ENABLED:
			{
				JREX_LOGLN("HandleBasicEvent JREX_SET_ENABLED EVENT!!!****")
				PRBool enabled=(PRBool)event->eventData;
				JREX_LOGLN("HandleBasicEvent()--> **** Using enabled<"<<enabled<<"> ****")
				rv=event->window->mBaseWindow->SetEnabled(enabled);
				JREX_LOGLN("HandleBasicEvent SetEnabled rv<"<<rv<<">****")
				break;
			}
			case JREX_REPAINT:
			{
				JREX_LOGLN("HandleBasicEvent JREX_REPAINT EVENT!!!****")
				PRBool force=(PRBool)event->eventData;
				JREX_LOGLN("HandleBasicEvent()--> **** Using force<"<<force<<"> ****")
				rv=event->window->mBaseWindow->Repaint(force);
				JREX_LOGLN("HandleBasicEvent Repaint rv<"<<rv<<">****")
				break;
			}
			case JREX_CHANGE_FOCUS:
			{
				JREX_LOGLN("HandleBasicEvent JREX_CHANGE_FOCUS EVENT!!!****")
				PRBool focusGained=(PRBool)event->eventData;
				JREX_LOGLN("HandleBasicEvent()--> **** Using focusGained<"<<focusGained<<"> ****")
				rv=event->window->ChangeFocusInternal(focusGained);
				JREX_LOGLN("HandleBasicEvent ChangeFocusInternal rv<"<<rv<<">****")
				break;
			}
			case JREX_SET_TITLE:
			{
				JREX_LOGLN("HandleBasicEvent JREX_SET_TITLE EVENT!!!****")
				PRUnichar* title=NS_REINTERPRET_CAST(PRUnichar*, event->eventData);
				JREX_LOGLN("HandleBasicEvent()--> **** Using title<"<<title<<">***")
				rv=event->window->mBaseWindow->SetTitle(title);
				JREX_LOGLN("HandleBasicEvent SetTitle rv<"<<rv<<">****")
				break;
			}
			case JREX_GET_TITLE:
			{
				JREX_LOGLN("HandleBasicEvent JREX_GET_TITLE EVENT!!!****")
				PRUnichar* title=nsnull;
				rv=event->window->mBaseWindow->GetTitle(&title);
				JREX_LOGLN("HandleBasicEvent()--> **** GetTitlerv<"<<rv<<"> title<"<<title<<">***")
				return (void*)title;
			}
			default:
			{
				JREX_LOGLN("HandleBasicEvent()--> **** EVENT TYPE<"<<event->eventType<<"> not handled!!! ****")
			}
		}
		JREX_LOGLN("HandleBasicEvent()--> **** returning rv<"<<rv<<"> ****")
		return (void*)rv;
	}

	void PR_CALLBACK  JRexWindow::DestroyBasicEvent(PLEvent* aEvent){
		JRexBasicEvent* event = NS_REINTERPRET_CAST(JRexBasicEvent*, aEvent);
		JREX_LOGLN("DestroyBasicEvent()--> **** window <"<<event->window<<"> ****")
		if(event->eventData){
			if(event->eventType==JREX_SHOW || event->eventType==JREX_SET_BOUNDS){
				PRInt32* evtData = NS_REINTERPRET_CAST(PRInt32*, event->eventData);
				delete evtData;
			}
		}
		delete event;
	}
