/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex.event;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import org.mozilla.jrex.JRexFactory;
import org.mozilla.jrex.event.JRexEvent;
import org.mozilla.jrex.event.JRexEventHandler;
import org.mozilla.jrex.event.JRexEventQueue;
import org.mozilla.jrex.event.context.ContextMenuEventHandler;
import org.mozilla.jrex.event.history.HistoryEventHandler;
import org.mozilla.jrex.event.observer.ObserverEventHandler;
import org.mozilla.jrex.event.progress.ProgressEventHandler;
import org.mozilla.jrex.event.tooltip.TooltipEventHandler;
import org.mozilla.jrex.event.uricontent.URIContentEventHandler;
import org.mozilla.jrex.event.window.WindowEventHandler;
import org.mozilla.jrex.exception.JRexException;
import org.mozilla.jrex.log.JRexL;
import org.mozilla.jrex.ui.JRexCanvas;
import org.mozilla.jrex.window.JRexWindowManager;

public final class JRexEventManager
implements Runnable {
    private static final String className;
    private static boolean inited;
    private static final JRexEventManager instance;
    private Thread dispatchThread;
    private JRexEventQueue eventQueue;
    private Hashtable retValTable;
    private WindowEventHandler wEvtHandler = (WindowEventHandler)JRexFactory.getInstance().getImplInstance("WindowEventHandler");
    private HistoryEventHandler hEvtHandler = (HistoryEventHandler)JRexFactory.getInstance().getImplInstance("HistoryEventHandler");
    private ProgressEventHandler pEvtHandler = (ProgressEventHandler)JRexFactory.getInstance().getImplInstance("ProgressEventHandler");
    private ContextMenuEventHandler cEvtHandler = (ContextMenuEventHandler)JRexFactory.getInstance().getImplInstance("ContextMenuEventHandler");
    private TooltipEventHandler ttEvtHandler = (TooltipEventHandler)JRexFactory.getInstance().getImplInstance("TooltipEventHandler");
    private ObserverEventHandler obEvtHandler = (ObserverEventHandler)JRexFactory.getInstance().getImplInstance("ObserverEventHandler");
    private URIContentEventHandler ucEvtHandler = (URIContentEventHandler)JRexFactory.getInstance().getImplInstance("URIContentEventHandler");
    private JRexWindowManager windowManager = (JRexWindowManager)JRexFactory.getInstance().getImplInstance("WindowManager");
    static final /* synthetic */ boolean $assertionsDisabled;

    private void loadClasses() throws JRexException {
        try {
            InputStream in = JRexEventManager.class.getClassLoader().getResourceAsStream("jrex.cls");
            if (in != null) {
                BufferedReader bin = new BufferedReader(new InputStreamReader(in));
                if (JRexL.on) {
                    JRexL.log(className, "loadClasses()--> **** Loading classes list... ****");
                }
                String temp = null;
                while ((temp = bin.readLine()) != null) {
                    temp = temp.trim();
                    if (JRexL.on) {
                        JRexL.log(className, "loadClasses()--> **** Loading class <" + temp + ">****");
                    }
                    if (temp == "" || temp.startsWith("#")) continue;
                    Class.forName(temp);
                    if (!JRexL.on) continue;
                    JRexL.log(className, "loadClasses()--> **** Loading class <" + temp + "> done!!!****");
                }
                bin.close();
            }
        }
        catch (Exception ex) {
            throw new JRexException("loadClasses FAILED <" + ex.getMessage() + ">");
        }
    }

    private JRexEventManager() {
        try {
            this.loadClasses();
            inited = true;
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
            throw new RuntimeException(ex);
        }
    }

    public static JRexEventManager getInstance() {
        return inited ? instance : null;
    }

    public synchronized void startEventManager() {
        if (this.eventQueue != null) {
            if (JRexL.on) {
                JRexL.log(className, "**** startEventManager()--> EventManager already started ****");
            }
            return;
        }
        if (JRexL.on) {
            JRexL.log(className, "**** startEventManager()--> Starting EventManager ****");
        }
        this.eventQueue = new JRexEventQueue();
        this.retValTable = new Hashtable();
        this.initDispatchThread();
        if (JRexL.on) {
            JRexL.log(className, "**** startEventManager()--> Starting EventManager Done ****");
        }
    }

    private void initDispatchThread() {
        if (this.dispatchThread == null) {
            if (JRexL.on) {
                JRexL.log(className, "**** initDispatchThread()-->creating dispatchThread ****");
            }
            this.dispatchThread = new Thread(this);
            this.dispatchThread.setPriority(6);
            this.dispatchThread.setDaemon(false);
            this.dispatchThread.start();
            if (JRexL.on) {
                JRexL.log(className, "**** initDispatchThread()-->dispatchThread started****");
            }
        }
    }

    public void postEvent(JRexEvent event) {
        if (this.dispatchThread == null) {
            if (JRexL.on) {
                JRexL.log(className, "**** postEvent()--> POST-EVENT DISABLED, NOT POSTING event<" + event + "> ****");
            }
            return;
        }
        if (JRexL.on) {
            JRexL.log(className, "**** postEvent()--> posting event<" + event + "> ****");
        }
        this.eventQueue.enqueue(event);
    }

    public Object postSyncEvent(JRexEvent event) {
        if (this.dispatchThread == null) {
            if (JRexL.on) {
                JRexL.log(className, "**** postSyncEvent()--> POST-EVENT DISABLED, NOT POSTING event<" + event + "> ****");
            }
            return null;
        }
        if (Thread.currentThread() == this.dispatchThread) {
            if (JRexL.on) {
                JRexL.log(className, "**** postSyncEvent()-->Cannot post SyncEvent<" + event + "> from dispatchThread ****");
            }
            return null;
        }
        if (JRexL.on) {
            JRexL.log(className, "**** postSyncEvent()--> posting event<" + event + "> ****");
        }
        JRexEventLock lock = (JRexEventLock)event.getNotifier();
        int eventType = event.getType();
        this.eventQueue.enqueue(event);
        while (!lock.notified) {
            try {
                if (eventType == -1) continue;
                JRexEventManager.processNativeEvents();
            }
            catch (Exception ex) {
                if (JRexL.on) {
                    JRexL.log(className, "**** postSyncEvent()-->JRexEvent Lock Exception for event<" + event + "> ****");
                }
                JRexL.printStackTrace(ex);
            }
        }
        return this.retValTable.remove(event);
    }

    private static void postEvent(int type, Object eventData) {
        if (JRexL.on) {
            JRexL.log(className, "**** postEvent()-->type<" + type + ">  eventData<" + eventData + "> ****");
        }
        instance.postEvent(JRexEvent.createEvent(type, eventData, System.currentTimeMillis()));
    }

    private static Object postSyncEvent(int type, Object eventData) {
        if (JRexL.on) {
            JRexL.log(className, "**** postSyncEvent()-->type<" + type + ">  eventData<" + eventData + "> ****");
        }
        return instance.postSyncEvent(JRexEvent.createSyncEvent(type, eventData, System.currentTimeMillis(), new JRexEventLock()));
    }

    private static void postKeyEvent(int target, int id, int modifiers, int keyCode, char keyChar) {
        if (JRexL.on) {
            JRexL.log(className, "**** postKeyEvent()-->id<" + id + "> modifiers<" + modifiers + "> keyCode<" + keyCode + "> keyChar<" + keyChar + ">****");
        }
        JRexCanvas browser = JRexEventManager.instance.windowManager.getBrowser(target);
        if (!$assertionsDisabled && browser == null) {
            throw new AssertionError();
        }
        if (browser == null) {
            return;
        }
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new KeyEvent(browser, id, 0L, modifiers, keyCode, keyChar));
    }

    private static void postMouseEvent(int target, int id, int modifiers, int x, int y, int clickCount, int button) {
        if (JRexL.on) {
            JRexL.log(className, "**** postMouseEvent()-->id<" + id + "> modifiers<" + modifiers + "> x<" + x + "> y<" + y + "> clickCount<" + clickCount + ">  button<" + button + ">****");
        }
        JRexCanvas browser = JRexEventManager.instance.windowManager.getBrowser(target);
        if (!$assertionsDisabled && browser == null) {
            throw new AssertionError();
        }
        if (browser == null) {
            return;
        }
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new MouseEvent(browser, id, 0L, modifiers, x, y, clickCount, false, button));
    }

    public synchronized void stopEventManager() {
        if (JRexL.on) {
            JRexL.log(className, "**** stopEventManager()-->I AM HERE ****");
        }
        JRexEventManager.postSyncEvent(-1, null);
    }

    private JRexEventHandler getHandler(int eventType) {
        switch (eventType) {
            case 1: {
                return this.wEvtHandler;
            }
            case 2: {
                return this.hEvtHandler;
            }
            case 3: {
                return this.pEvtHandler;
            }
            case 4: {
                return this.cEvtHandler;
            }
            case 5: {
                return this.ttEvtHandler;
            }
            case 6: {
                return this.obEvtHandler;
            }
            case 7: {
                return this.ucEvtHandler;
            }
        }
        if (JRexL.on) {
            JRexL.log(className, "**** UNKNOWN eventType<" + eventType + "> ****");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (JRexL.on) {
            JRexL.log(className, "**** run()-->I AM HERE ****");
        }
        while (true) {
            block21: {
                Object var7_8;
                JRexEvent event;
                try {
                    event = this.eventQueue.dequeue();
                }
                catch (InterruptedException ex) {
                    if (JRexL.on) {
                        JRexL.log(className, "**** run()--> Thread Interrupted in dequeue ***");
                    }
                    this.dispatchThread = null;
                    return;
                }
                if (JRexL.on) {
                    JRexL.log(className, "**** run()--> Processing event<" + event + "> ***");
                }
                int type = event.getType();
                JRexEventLock notifier = (JRexEventLock)event.getNotifier();
                if (type == -1) {
                    if (JRexL.on) {
                        JRexL.log(className, "**** run()--> SHUTDOWN_EVENT recieved exiting ***");
                    }
                    this.dispatchThread = null;
                    if (notifier != null) {
                        if (JRexL.on) {
                            JRexL.log(className, "**** run()--> SHUTDOWN_EVENT Notifying  notifier<" + notifier + "> ***");
                        }
                        notifier.notified = true;
                    }
                    return;
                }
                JRexEventHandler handler = this.getHandler(type);
                if (JRexL.on) {
                    JRexL.log(className, "**** run()--> Using Eventhandler<" + handler + "> ***");
                }
                try {
                    block20: {
                        try {
                            Object rv = handler.handleEvent(event);
                            if (JRexL.on) {
                                JRexL.log(className, "**** run()--> handleEvent  rv<" + rv + "> ***");
                            }
                            if (rv == null) break block20;
                            this.retValTable.put(event, rv);
                        }
                        catch (Throwable ex) {
                            if (JRexL.on) {
                                JRexL.log(className, "**** run()--> handleEvent failed ***");
                            }
                            JRexL.printStackTrace(ex);
                            var7_8 = null;
                            if (notifier == null) continue;
                            if (JRexL.on) {
                                JRexL.log(className, "**** run()--> Notifying  notifier<" + notifier + "> ***");
                            }
                            notifier.notified = true;
                            continue;
                        }
                    }
                    var7_8 = null;
                    if (notifier == null) continue;
                    if (!JRexL.on) break block21;
                }
                catch (Throwable throwable) {
                    var7_8 = null;
                    if (notifier != null) {
                        if (JRexL.on) {
                            JRexL.log(className, "**** run()--> Notifying  notifier<" + notifier + "> ***");
                        }
                        notifier.notified = true;
                    }
                    throw throwable;
                }
                JRexL.log(className, "**** run()--> Notifying  notifier<" + notifier + "> ***");
            }
            notifier.notified = true;
        }
    }

    private static native void initIDs() throws JRexException;

    private static native void processNativeEvents() throws JRexException;

    static {
        $assertionsDisabled = !JRexEventManager.class.desiredAssertionStatus();
        className = JRexEventManager.class.getName();
        try {
            JRexEventManager.initIDs();
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
            throw new RuntimeException(ex);
        }
        inited = false;
        instance = new JRexEventManager();
    }

    public static class JRexEventLock {
        volatile boolean notified = false;
    }
}

