/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is MacroTracker Bug Tracking System Source Code
 *
 * The Initial Developer of the Original Code is
 * R.J. Keller.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
package org.mozdev.MacroTracker.toolkit;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import org.mozdev.firebirdhelp.general.ToolbarButton;

import com.trfenv.rlk.Debug;

/**
 *A JToolBar that provides a popup menu when right-clicked that let's the
 *user choose whether or not they want Icons, Icons and Text, or Text.
 *
 *@author R.J. Keller <rlk@trfenv.com>
 */
public class ContextToolbar extends JToolBar
{
	private LinkedList mButtons;
	private JPopupMenu mPopup;
	
	/**
	 * Creates a general JToolBar with a context menu.
	 */
	public ContextToolbar()
	{
		super();

		final Container window = getParent();

		Debug.createObject(mButtons);
		Debug.createObject(this);
		
		mPopup = makeContextMenu();
		mButtons = new LinkedList();
		
		class toolbarMouseListener implements MouseListener
		{
			public void mouseClicked(MouseEvent e)
			{
			}
			
			public void mousePressed(MouseEvent e){ maybeShowPopup(e); }
			public void mouseReleased(MouseEvent e){ maybeShowPopup(e); }
			public void mouseExited(MouseEvent e) {	}
			public void mouseEntered(MouseEvent e) { }
			
			public void maybeShowPopup(MouseEvent e)
			{
				if (e.isPopupTrigger())
				{
					Debug.println("Component: " + e.getComponent());
					try
					{
						mPopup.show(e.getComponent(), e.getX(), e.getY());
					}
					catch (Exception ex)
					{
						Debug.printException(ex);
					}
				}
			}
		}
		
		addMouseListener(new toolbarMouseListener());
		
		Debug.createObject(this);
	}

	public Component add(Component aComp)
	{
		Debug.printWarning("Adding a JButton to this toolbar may cause exceptions if setToolbarButonMode() is ran.");
		return super.add(aComp);
	}

	public void add(ToolbarButton aButton)
	{
		mButtons.add(aButton);
		super.add(aButton);
	}
	
	/**
	 *Sets whether or not the toolbar buttons should show pictures, text, or
	 *both.
	 *@param mode The mode to set all the ToolbarButton's too. This value must
	 *  be one of the ToolbarButton constants (ICONS_AND_TEXT, TEXT_ONLY,
	 *  PICTURE_ONLY).
	 */
	public void setToolbarButtonMode(byte mode)
	{
		try
		{
			for (Iterator i = mButtons.iterator(); i.hasNext(); )
			{
				ToolbarButton curButton = (ToolbarButton)i.next();
				
				curButton.setButtonMode(mode);
			}
		}
		catch (Exception ex)
		{
			Debug.printException(ex);
		}
	}
	
	/**
	 *Creates a context menu for the ContextToolbar that will be displayed
	 *when right-clicked.
	 */
	private JPopupMenu makeContextMenu()
	{
		JPopupMenu context = new JPopupMenu();
		
		JMenuItem mnuIcons = new JMenuItem("Icons");
		JMenuItem mnuIconsAndText = new JMenuItem("Icons and Text");
		JMenuItem mnuText = new JMenuItem("Text");
		
		context.add(mnuIcons);
		context.add(mnuIconsAndText);
		context.add(mnuText);
		
		/*
		 *The action listener to run when the menuitems are clicked.
		 */
		class ContextActionListener implements ActionListener
		{
			private byte mWhatToDo;
			
			/**
			 *Takes in what mode to set all of the ToolbarButtons to.<br>
			 *(precondition: whatToDo == ToolbarButton.IMAGE_AND_TEXT, 
			 *TEXT_ONLY, IMAGE_ONLY)
			 */
			public ContextActionListener(byte whatToDo)
			{
				mWhatToDo = whatToDo;
			}
			
			public void actionPerformed(ActionEvent event)
			{
				setToolbarButtonMode(mWhatToDo);
			}
		}

		mnuIcons.addActionListener(new ContextActionListener(ToolbarButton.IMAGE_ONLY));
		mnuIconsAndText.addActionListener(new ContextActionListener(ToolbarButton.IMAGE_AND_TEXT));
		mnuText.addActionListener(new ContextActionListener(ToolbarButton.TEXT_ONLY));
		
		return context;
	}
}