/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is MacroTracker Bug Tracking System Source Code
 *
 * The Initial Developer of the Original Code is
 * R.J. Keller.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
package org.mozdev.MacroTracker.toolkit;

import org.mozdev.MacroTracker.ui.frmMiniBrowser;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

import com.trfenv.rlk.Debug;
/**
 *A JLabel that looks like a HTML website hyperlink and can set it to load a
 *URL when clicked. This class requires the frmMiniBrowser class to load
 *URLs.
 *
 *@author R.J. Keller <rlk@trfenv.com>
 */
public class hyperlinkLabel extends JLabel
{
	/**
	 *Creates a hyperlinkLabel that, when clicked, loads a URL into the
	 *MiniBrowser.
	 *
	 *@param text The text to set the label.
	 *@param url The URL to load into the MiniBrowser when the hyperlinkLabel is clicked.
	 */
	public hyperlinkLabel(String text, String url)
	{
		this(text);
		
		addMouseListener(new miniBrowserLoader(url));

		Debug.createObject(this);
	}
	
	/**
	 *Creates a hyperlinkLabel with the text of the label already set.
	 *
	 *@param text The text to set the label.
	 */
	public hyperlinkLabel(String text)
	{
		this();
		setText(text);
	}
	
	/**
	 *Creates a hyperlinkLabel that is a regular JLabel but it looks like a
	 *hyperlink.
	 */
	public hyperlinkLabel()
	{
		setFont(new Font("sans-serif", Font.BOLD, 11));
		setForeground( Color.BLUE );
		setCursor( new Cursor(Cursor.HAND_CURSOR) );		
	}
	
	/**
	 *Defines the single line of text this component will display.
	 *@param text The text to set the label.
	 */
	public void setText(String text)
	{
		super.setText("<html><u>" + text + "</u></html>");
	}
	
	class miniBrowserLoader implements MouseListener
	{
		private String url;
		
		public miniBrowserLoader(String url)
		{
			this.url = url;
		}
		
		public void mouseClicked( MouseEvent e )
		{
			Debug.println("Hyperlink clicked. Loading MiniBrowser.");

			frmMiniBrowser miniBrowser = new frmMiniBrowser( url );
			miniBrowser.setVisible( true );
		}
				
		public void mouseEntered( MouseEvent e ){}
		public void mouseExited( MouseEvent e ){}		
		public void mousePressed( MouseEvent e ){}
		public void mouseReleased( MouseEvent e ){}
	}
}