/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Help Viewer API in Java.
 *
 * The Initial Developer of the Original Code is
 * R.J. Keller.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package org.mozdev.firebirdhelp.HelpViewer;

import java.util.*;
import javax.swing.tree.DefaultMutableTreeNode;

public class HelpTree implements iHelpTopic
{
	private String mName;
	private String mURL;
	private List   mSubTopics;
	private DefaultMutableTreeNode mThisNode;
	
	/**
	 *Creates a standard HelpTree object that is designed to create a tree
	 *of objects.
	 *@param aTopicName The name of this topic to display in the tree.
	 *@param aURL The url to load when this help topic is enabled.
	 */
	public HelpTree(String aTopicName, String aURL)
	{
		mName = aTopicName;
		mSubTopics = new LinkedList();
		mURL = aURL;
		
		mThisNode = new DefaultMutableTreeNode(aTopicName, true);
	}
	
	/**
	 *Add a sub-topic to branch out of this help topic in a JTree.
	 *
	 *<p>For example, JTree's will look like this:</p>
	 *<p><code>&nbsp;&nbsp;-- thisTopic<br>
	 *&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;-- subtopic taken in.
	 *</code></p>
	 *@param aSubTopic The subtopic of this help topic.
	 */
	public void addSubTopic(iHelpTopic aSubTopic)
	{
		mSubTopics.add(aSubTopic);
		DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(aSubTopic.name(), true);
		mThisNode.add(treeNode);
		treeNode.setParent(mThisNode);
	}
	
	/**
	 *Returns an iterator that iterates through all of the help sub-topics.
	 */
	public Iterator topicIterator()
	{
		Iterator iter = mSubTopics.iterator();

		if (iter == null)
		{
			return new Iterator(){
				public boolean hasNext() { return false; }
				public Object next() { return null; }
				public void remove() { return; }
			};
		}
		else
			return iter;
	}
	
	/**
	 *Returns a TreeNode of this object that can be added to a JTree to display
	 *this topic and its sub-topics in a tree visually.
	 */
	public DefaultMutableTreeNode getTreeNode()
	{
		return mThisNode;
	}
	
	/**
	 *Returns the URL of this help topic.
	 */
	public String url()
	{
		return mURL;
	}
	
	/**
	 *Returns the name of this help topic.
	 */
	public String name()
	{
		return mName;
	}
	
	/**
	 *Removes all of the sub-topics of this topic.
	 */
	public void removeSubTopics()
	{
		mSubTopics.clear();
	}
}