/*
The contents of this file are subject to the Mozilla Public
License Version 1.1 (the "License"); you may not use this file
except in compliance with the License. You may obtain a copy of
the License at http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS
IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
implied. See the License for the specific language governing
rights and limitations under the License.

The Original Code is jslib team code.
The Initial Developer of the Original Code is the jslib team.

Original Author: Brian King <brian@mozdev.org>
Contributor(s): 
*/

jslib.init(this);

function onloadAbout()
{
  include(jslib_fileutils);
  var fu = new FileUtils();


  var p1 = fu.chromeToPath("chrome://jslib/content/");
  var p2 = fu.chromeToPath("chrome://jsliblive/content/");

  getEl("jslibPath").value = p1;
  getEl("jsliblivePath").value = p2;

  // jslibLaunchConsole();
}

// Firefox only
function toOpenWindowByType(inType, uri, features, urlToLoad)
{
  var windowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService();
  var windowManagerInterface = windowManager.QueryInterface(Components.interfaces.nsIWindowMediator);
  var topWindow = windowManagerInterface.getMostRecentWindow(inType);
  
  if (topWindow)  {
    topWindow.focus();
    var theBrowser = topWindow.document.getElementById("content");
    var tabAdded = theBrowser.addTab(urlToLoad);
    theBrowser.selectedTab = tabAdded;
  }
  else  {
    window.openDialog(uri, "", features, urlToLoad);
  }
}

function goLink(evt)
{
  var href = evt.target.getAttribute("href");
  if (href){
    toOpenWindowByType("navigator:browser", "chrome://browser/content/browser.xul", "all,dialog=no", href)
    self.close();
  }
}

function getEl (aEl) { return document.getElementById(aEl); }

