// Save-prefs:
/*var mozcdPrefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);

if (mozcdPrefs.getPrefType("general.useragent.locale") != mozcdPrefs.PREF_INVALID){
	var mozcdLanguage = mozcdPrefs.getCharPref('general.useragent.locale');
}*/

var mozcdLanguage = "";

var moxcdprop = document.getElementById("mozcdprop");
var has_ownFF = moxcdprop.getString("has_ownFF");
var has_ownTB = moxcdprop.getString("has_ownTB");

var moxcdmainprop = document.getElementById("mozcdmainprop");
var ff_filename = moxcdmainprop.getString("ff_filename");
var tb_filename = moxcdmainprop.getString("tb_filename");

function closeWindow() {
	window.close();
}

function setLang(lang) {
	var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
	prefs.setCharPref("mozcd.lang", lang);
	prefs.setCharPref("general.useragent.locale", lang);

	mozcdLanguage = lang;
}

function saveAndOpenMain() {

	//Set language according to user preference
	var mozcdLanguage = document.getElementById("mozcd-language-list").selectedItem.value;
	setLang(mozcdLanguage);

	openMain();
}

function openMain() {	
	window.open("chrome://mozcd/content/mozcd_browse.xul","mozcd-main-window","chrome,centerscreen");
	closeWindow();
}

function openWindow(url) {	
	window.open(url,"mozcd-main-window","chrome,centerscreen");
	closeWindow();
}

//Check for a previously saved language
function mozcdCheckSavedLang() {
	var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
	var lang = prefs.getCharPref("mozcd.lang");

	if (lang != "") {
		setLang(lang);
		return true;
	}

	return false;
}


function mozcdGetFirefoxInstall(lang) {
	var mozcd_InstallDirService = Components.classes['@mozilla.org/file/directory_service;1']
								  .getService(Components.interfaces.nsIProperties);

	var mozcd_InstallFirefoxPath = mozcd_InstallDirService.get('CurProcD', Components.interfaces.nsIFile);
	
	mozcd_InstallFirefoxPath.append("..");
	mozcd_InstallFirefoxPath.append("installdata");
	mozcd_InstallFirefoxPath.append("firefox");

	mozcd_InstallFirefoxPath.append(lang);	

	mozcd_InstallFirefoxPath.append(ff_filename); //taken from mozcd.properties

	if (!mozcd_InstallFirefoxPath.exists()) {
		if (lang != "en-US") {
			return mozcdGetFirefoxInstall("en-US");
		} else {
			return false;
		}
	}

	return mozcd_InstallFirefoxPath.path;
}

function startFirefoxInstall() {

	var mozcd_InstallDirService = Components.classes['@mozilla.org/file/directory_service;1']
								  .getService(Components.interfaces.nsIProperties);


	//Set up the path to the Firefox installation (using .append() to get platform specific paths)
	var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
	var lang = prefs.getCharPref("mozcd.lang");

	var mozcd_FirefoxPath = mozcdGetFirefoxInstall(lang);

	if (!mozcd_FirefoxPath) {
		alert("Could not find a Firefox installation on the CD!");
		return;
	}

	/*if (has_ownFF == "true") {
		mozcd_InstallFirefoxPath.append(mozcdLanguage);
	} else {
		mozcd_InstallFirefoxPath.append("en-US");
	}*/
	
	//Set up the path to the mozcd launcher application
	var mozcd_launcher = mozcd_InstallDirService.get('CurProcD',
						 Components.interfaces.nsILocalFile);

	mozcd_launcher.append("..");

	//Detect mozcd_launcher app name according to OS
	//TODO: Mac & Linux support (Mac more important)
	if (navigator.appVersion.indexOf("Win") != -1) { //Windows
		mozcd_launcher.append(moxcdmainprop.getString("mozcd_launcher_win"));

		var mozcd_InstallProcess = Components.classes["@mozilla.org/process/util;1"]
						.getService(Components.interfaces.nsIProcess);

		mozcd_InstallProcess.init(mozcd_launcher);

		try {
			var args = [mozcd_FirefoxPath, "chrome://mozcd/content/mozcd.xul?firefox_install"];
			mozcd_InstallProcess.run(false, args, args.length);
		}
		
		//catch and alert about execution errors
		catch (err) {
			alert(err);
			//TODO: Display error on an error page...
			return; //so as not to close down mozcd
		}

		//Close mozcd so as not to interfere with the installation (can't install while ff is running)
		window.parent.close();

	} else { 
		alert("Your system is not currently supported for automatic firefox install... please install Firefox from the /installdata directory");
	}

}

//TODO: remove FF installation...
function startInstallation(installType) {
	/* ::: Fix the directory service and local file interface for installation program ::: */
	var mozcd_InstallDirService=Components.classes['@mozilla.org/file/directory_service;1']
	.getService(Components.interfaces.nsIProperties);

	var mozcd_InstallProgram = mozcd_InstallDirService.get('CurProcD',
                   	Components.interfaces.nsILocalFile);

	//Make sure language variables are set up properly
	mozcdCheckSavedLang();

	/* ::: Define the path to the exe ::: */
	mozcd_InstallProgram.append("..");
	mozcd_InstallProgram.append("installdata");
	if (installType == "firefox") {
		mozcd_InstallProgram.append("firefox");
		if (has_ownFF == "true") {
			mozcd_InstallProgram.append(mozcdLanguage);
		} else {
		    mozcd_InstallProgram.append("en-US");
		}
		mozcd_InstallProgram.append(ff_filename);
		
		
	} else if (installType == "thunderbird") {
		mozcd_InstallProgram.append("thunderbird");
		if (has_ownTB == "true") {
			mozcd_InstallProgram.append(mozcdLanguage);
		} else {
		    mozcd_InstallProgram.append("en-US");
		}
		mozcd_InstallProgram.append(tb_filename);
	}

	try {
		/* ::: Inititate the process ::: */
		var mozcd_InstallProcess = Components.classes["@mozilla.org/process/util;1"]
						.getService(Components.interfaces.nsIProcess);
		mozcd_InstallProcess.init(mozcd_InstallProgram);
		/* ::: run with the value as a parameter ::: */
		mozcd_InstallProcess.run(false,[],0);
	}
	catch(err) {
		alert("There was an error when attempting to launch the Thunderbird installation file.\n\nPlease run the installation directly from the CD\n\nError Info:\n" + err);
	}
	
}

function mozcd_InstallTheme(href, name) {
	InstallTrigger.installChrome(InstallTrigger.SKIN, href, name);
}

function htmlHideAll() {
	var i;

	var tabs = document.getElementById("tabs_content");

	for (i = 0; i < tabs.childNodes.length; i++) {
		var tag = tabs.childNodes[i];

		if ((tag.tagName && tag.tagName.toLowerCase() == "div") && (tag.id && tag.id.indexOf("mozcd_") == 0)) {
			htmlHide(tag.id);
		}
	}
}

function htmlHide(div) {
	document.getElementById(div).style.visibility = "hidden";
}

function htmlDisplay(div) {
	document.getElementById(div).style.visibility = "visible";
}

function htmlDisplayOnly(div) {
	var divname = "mozcd_" + div;
	htmlHideAll();

	htmlDisplay(divname);
}

function DisplayTab(tab) {
	var tabname = "tab_" + tab;
	var tabs = document.getElementById("tabs");
try {
	for (i = 0; i < tabs.childNodes.length; i++) {
		var curtab = tabs.childNodes[i];

		if (curtab.tagName) {
			if (curtab.tagName.toLowerCase() == "li" && (curtab.getAttribute("name") && curtab.getAttribute("name").indexOf("tab_") == 0)) {
				if (curtab.getAttribute("name") == tabname) {
					curtab.style.border = "3px ridge";
				} else {
					curtab.style.border = "1px solid";
				}
			}
		}
	}
} 
catch(err) {
	alert(err);
}
	htmlDisplayOnly(tab);
}