

/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozdom4java
 *
 * The Initial Developer of the Original Code is
 * Peter Szinek, Lixto Software GmbH, http://www.lixto.com.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Peter Szinek (peter@rubyrailways.com)
 *  Michal Ceresna (michal.ceresna@gmail.com)
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


package org.mozilla.dom.html;

//Java imports
import java.util.*;
import java.util.concurrent.*;

//org.w3c imports
import org.w3c.dom.*;
import org.w3c.dom.html2.*;
import org.w3c.dom.html.*;
import org.w3c.dom.events.*;
import org.w3c.dom.traversal.*;
import org.w3c.dom.ranges.*;
import org.w3c.dom.views.*;

//mozdom4java imports
import org.mozilla.dom.*;
import org.mozilla.dom.views.*;
import org.mozilla.dom.events.*;
import org.mozilla.dom.ranges.*;
import org.mozilla.dom.traversal.*;

//XPCOM import
import org.mozilla.xpcom.*;
import org.mozilla.interfaces.*;


public class HTMLDocumentImpl extends DocumentImpl implements org.w3c.dom.html.HTMLDocument
{


    public nsIDOMHTMLDocument getInstance()
    {
	return getInstanceAsnsIDOMHTMLDocument();
    }

    /***************************************************************
     *
     * HTMLDocument implementation code
     *
     ***************************************************************/

    public HTMLDocumentImpl(nsIDOMHTMLDocument mozInst)
    {
        super( mozInst );
    }

    public static HTMLDocumentImpl getDOMInstance(nsIDOMHTMLDocument mozInst)
    {
        
        HTMLDocumentImpl node = (HTMLDocumentImpl) instances.get(mozInst);
        return node == null ? new HTMLDocumentImpl(mozInst) : node;
    }

    public nsIDOMHTMLDocument getInstanceAsnsIDOMHTMLDocument()
    {
        if (moz==null)
            return null;
        else
            return (nsIDOMHTMLDocument) moz.queryInterface(nsIDOMHTMLDocument.NS_IDOMHTMLDOCUMENT_IID);
    }

    public String getDomain()
    {
        //METHOD-BODY-START - autogenerated code
        throw new UnsupportedException();
        //METHOD-BODY-END - autogenerated code
    }

    public void setBody(final HTMLElement body)
    {
        //METHOD-BODY-START - autogenerated code
        final nsIDOMHTMLElement mozBody = body!=null ? ((HTMLElementImpl) body).getInstance() : null;
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMHTMLDocument().setBody(mozBody);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public HTMLCollection getAnchors()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<HTMLCollection> c = new Callable<HTMLCollection>() { public HTMLCollection call() {
            nsIDOMHTMLCollection result = getInstanceAsnsIDOMHTMLDocument().getAnchors();
            return new HTMLCollectionImpl(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public String getCookie()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<String> c = new Callable<String>() { public String call() {
            String result = getInstanceAsnsIDOMHTMLDocument().getCookie();
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public String getURL()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<String> c = new Callable<String>() { public String call() {
            String result = getInstanceAsnsIDOMHTMLDocument().getURL();
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public void setTitle(final String title)
    {
        //METHOD-BODY-START - autogenerated code
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMHTMLDocument().setTitle(title);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public HTMLCollection getLinks()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<HTMLCollection> c = new Callable<HTMLCollection>() { public HTMLCollection call() {
            nsIDOMHTMLCollection result = getInstanceAsnsIDOMHTMLDocument().getLinks();
            return new HTMLCollectionImpl(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public void write(final String text)
    {
        //METHOD-BODY-START - autogenerated code
        throw new UnsupportedException();
        //METHOD-BODY-END - autogenerated code
    }

    public HTMLCollection getForms()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<HTMLCollection> c = new Callable<HTMLCollection>() { public HTMLCollection call() {
            nsIDOMHTMLCollection result = getInstanceAsnsIDOMHTMLDocument().getForms();
            return new HTMLCollectionImpl(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public HTMLCollection getImages()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<HTMLCollection> c = new Callable<HTMLCollection>() { public HTMLCollection call() {
            nsIDOMHTMLCollection result = getInstanceAsnsIDOMHTMLDocument().getImages();
            return new HTMLCollectionImpl(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public void writeln(final String text)
    {
        //METHOD-BODY-START - autogenerated code
        throw new UnsupportedException();
        //METHOD-BODY-END - autogenerated code
    }

    public NodeList getElementsByName(final String elementName)
    {
        //METHOD-BODY-START - autogenerated code
        Callable<NodeList> c = new Callable<NodeList>() { public NodeList call() {
            nsIDOMNodeList result = getInstanceAsnsIDOMHTMLDocument().getElementsByName(elementName);
            return new NodeListImpl(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public String getTitle()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<String> c = new Callable<String>() { public String call() {
            String result = getInstanceAsnsIDOMHTMLDocument().getTitle();
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public void close()
    {
        //METHOD-BODY-START - autogenerated code
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMHTMLDocument().close();
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public HTMLCollection getApplets()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<HTMLCollection> c = new Callable<HTMLCollection>() { public HTMLCollection call() {
            nsIDOMHTMLCollection result = getInstanceAsnsIDOMHTMLDocument().getApplets();
            return new HTMLCollectionImpl(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public void setCookie(final String cookie)
    {
        //METHOD-BODY-START - autogenerated code
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMHTMLDocument().setCookie(cookie);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public void open()
    {
        //METHOD-BODY-START - autogenerated code
        throw new UnsupportedException();
        //METHOD-BODY-END - autogenerated code
    }

    public String getReferrer()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<String> c = new Callable<String>() { public String call() {
            String result = getInstanceAsnsIDOMHTMLDocument().getReferrer();
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public HTMLElement getBody()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<HTMLElement> c = new Callable<HTMLElement>() { public HTMLElement call() {
            nsIDOMHTMLElement result = getInstanceAsnsIDOMHTMLDocument().getBody();
            return (HTMLElement) NodeFactory.getNodeInstance(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }



}
