/* 
   - The contents of this file are subject to the Mozilla Public
   - License Version 1.1 (the "License"); you may not use this file
   - except in compliance with the License. You may obtain a copy of
   - the License at http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS
   - IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
   - implied. See the License for the specific language governing
   - rights and limitations under the License.
   -
   - The Original Code is this file as it was released on
   - August 29, 2002.
   -
   - The Initial Developer of the Original Code is HJ van Rantwijk.
   - Portions created by HJ van Rantwijk are Copyright (C) 2002-2007
   - HJ van Rantwijk.  All Rights Reserved.
   -
   - Note: some portions of this file are copied from Mozilla source to
   - maintain full compatibility, and to fix some security issues, so 
   - all rights reserved to these good people!
   - 
   - Contributors:
   -	Michael Vincent van Rantwijk <mv_van_rantwijk@yahoo.com>
   -	Philip Chee <philip.chee@gmail.com> (bug 16469)

*/

  var pref = null;
  pref = Components.classes["@mozilla.org/preferences-service;1"]
                   .getService(Components.interfaces.nsIPrefBranch);

  // Prefill a single text field
  function prefillTextBox(target) {
    // obtain values to be used for prefilling
    var walletService = Components.classes["@mozilla.org/wallet/wallet-service;1"]
                                  .getService(Components.interfaces.nsIWalletService);
    var value = walletService.WALLET_PrefillOneElement(window.content, target);

    if (value) {
      // result is a linear sequence of values, each preceded by a separator character
      // convert linear sequence of values into an array of values
      var separator = value[0];
      var valueList = value.substring(1, value.length).split(separator);
      target.value = valueList[0];
    }
  }

  function contentAreaMouseDown(event)
  {
    // Restrict handling of events coming from the user, not web content
    if ('isTrusted' in event && event.isTrusted == true) { // https://bugzilla.mozilla.org/show_bug.cgi?id=265176
      // Left mouse button pressed?
      if (event.button == 0) {
        var target = event.target;
        var linkNode;

        if (target instanceof HTMLAnchorElement ||
            target instanceof HTMLAreaElement ||
            target instanceof HTMLLinkElement) {
          if (target.hasAttribute("href")) 
            linkNode = target;
        }
        else if (target instanceof HTMLInputElement) {
          if (event.target.type == "text")
            event.originalTarget.ownerDocument.defaultView.mouseClick = false;
          else if (event.target.type == "button")
            linkNode = target;
        }
        else {
          linkNode = event.originalTarget;

          while (linkNode && !(linkNode instanceof HTMLAnchorElement)) {
            linkNode = linkNode.parentNode;
          }
          /***
            * <a> cannot be nested.  So if we find an anchor without an
            * href, there is no useful <a> around the target
            */
          if (linkNode && !linkNode.hasAttribute("href"))
            linkNode = null;
        }
        if (linkNode) {
          var ownerDocument = new XPCNativeWrapper(event.target, "ownerDocument").ownerDocument;
          var browser = getBrowserForDocument(ownerDocument);
          event.originalTarget.ownerDocument.defaultView.mouseClick = browser;
        } // if (linkNode) {
      }
      try {
        if (event.button == 1 && (event.target != event.currentTarget) && 
            !hrefAndLinkNodeForClickEvent(event) && 
            !isAutoscrollBlocker(event.originalTarget))
        {
          startScrolling(event);
          return false;
        }
      } catch (ex) {
      }
    } // if ('isTrusted' in event && event.isTrusted == true) {
    return true;
  }

  function mzClearMouseClick(aWindow)
  {
     if (aWindow)
       aWindow.mouseClick = undefined;
  }

  function contentAreaClick(event)
  {
    // Restrict handling of events coming from the user, not web content
    if (!event.isTrusted || event.getPreventDefault()) { // https://bugzilla.mozilla.org/show_bug.cgi?id=265176
      return true;
    }
    var isKeyPress = (event.type == "keypress");
    var target = event.target;
    var linkNode;

    setTimeout(mzClearMouseClick, 50, event.originalTarget.ownerDocument.defaultView);

    if (target instanceof HTMLAnchorElement || target instanceof HTMLAreaElement || 
        target instanceof HTMLLinkElement) {
      if (target.hasAttribute("href")) {
        linkNode = target;
        // Send a 'link-clicked' notification out to our RSS panel!
        var _nsIObserverService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
        _nsIObserverService.notifyObservers(window, "link-clicked", linkNode);
      }
    }
    else if (target instanceof HTMLInputElement) {
      if ((event.target.type == "text" || event.target.type == "") && !isKeyPress && event.detail == 2 && event.button == 0 && 
          event.target.value.length == 0 && "@mozilla.org/wallet/wallet-service;1" in Components.classes) {
        prefillTextBox(target); // prefill the empty text field if possible
      }
      if (event.target.type == "text" || event.target.type == "password") {
        if (gMultiZilla.prefs.readBoolean("multizilla.forced.autocomplete", true))
          forcedAutocomplete(event);
      }
      if (event.target.type == "submit") {
        if (event.target.parentNode.hasAttribute("target") &&
            gMultiZilla.prefs.readBoolean("multizilla.remove.form-target", false)) { // load form in same tab
          var targetID = event.target.parentNode.target.toLowerCase();

          if (targetID == "_new" || targetID == "new" || targetID == "_blank" || targetID == "blank") {
            event.target.parentNode.removeAttribute("target"); // load in current page
            return true;
          }
        }
      }
    }
    else {
      linkNode = event.originalTarget;

      while (linkNode && !(linkNode instanceof HTMLAnchorElement)) {
        linkNode = linkNode.parentNode;
      }
      /***
        * <a> cannot be nested.  So if we find an anchor without an
        * href, there is no useful <a> around the target
        */
      if (linkNode && linkNode.hasAttribute("href") == false)
        linkNode = null;
    }
    var href;

    if (linkNode) {
      href = new XPCNativeWrapper(linkNode, "href").href;

      if (href.match(/^javascript:/i)) {
        var ownerDocument = new XPCNativeWrapper(event.target, "ownerDocument").ownerDocument;
        var browser = getBrowserForDocument(ownerDocument);
        event.originalTarget.ownerDocument.defaultView.clickedOnJSLink = browser;
      }
      else 
        event.originalTarget.ownerDocument.defaultView.clickedOnJSLink = undefined;

      if (handleLinkClick(event, href, linkNode) == -1)
        return false;
      else return true;
    } 
    else {
      // Try simple XLink
      linkNode = target;

      while (linkNode) {
        if (linkNode.nodeType == Node.ELEMENT_NODE) {
          var wrapper = new XPCNativeWrapper(linkNode, "getAttributeNS()");
          href = wrapper.getAttributeNS("http://www.w3.org/1999/xlink", "href");
          break;
        }
        linkNode = linkNode.parentNode;
      }
      if (href && href != "") {
        var baseURI = new XPCNativeWrapper(linkNode, "baseURI").baseURI;
        href = makeURLAbsolute(baseURI, href);
        handleLinkClick(event, href, null);
        return true;
      }
    }
    if (pref && !isKeyPress && event.button == 1 && 
        pref.getBoolPref("middlemouse.contentLoadURL")) {
      if (middleMousePaste(event))
        event.stopPropagation();
    }
    return true;
  }

  function handleLinkClick(event, href, linkNode)
  {
    // Make sure we are allowed to open this URL
    // if (Components.interfaces.nsIScriptSecurityManager.number == "{0b8a9b32-713f-4c39-bea0-6cacec46f385}") {
    if (Components.interfaces.nsIScriptSecurityManager.number == "{3fffd8e8-3fea-442e-a0ed-2ba81ae197d5}") {
      gMultiZilla.utility.doURLSecurityCheck(event.target.ownerDocument.nodePrincipal, href, 
                                             Components.interfaces.nsIScriptSecurityManager.STANDARD);
    }
    else // SeaMonkey v1.1.x
      urlSecurityCheck(href, document);

    var sourceTab = getBrowser().mCurrentTab;

    switch (event.button) {
      case 0:                                                         // if left button clicked
        if (event.metaKey || event.ctrlKey) {                         // and meta or ctrl are down
          if (href.toLowerCase().search("mailto:") == 0) {
            loadURI(href);
            return false;
          }
          if (openLinkInNewWindow(event, href) || openLinkInNewTab(event, href))
            return true;
        }
        var saveModifier = true;

        if (pref) {
          try {
            saveModifier = pref.getBoolPref("ui.key.saveLink.shift");
          }
          catch(ex) {            
          }
        }
        saveModifier = saveModifier ? event.shiftKey : event.altKey;
          
        if (saveModifier) {                                           // if saveModifier is down
          saveURL(href, linkNode ? gatherTextUnder(linkNode) : "");
          return true;
        }
        if (event.altKey)                                             // if alt is down
          return true;                                                // do nothing
        if (gMultiZilla.prefs.readBoolean("multizilla.newtabfor.windowopen", true) && 
            (linkNode.hasAttribute("target") || hasTarget("base", event))) {
          var targetID = null;

          if (linkNode.hasAttribute("target")) {
            targetID = linkNode.target;
          }
          else {
            var base = event.target.ownerDocument.getElementsByTagName("base");
            targetID = base[0].hasAttribute("target") ? base[0].getAttribute("target") : null;
          }
          if (targetID == "_content") { // see mz bugzilla bug 1706
            return true;
          }
          if (gMultiZilla.tabs.preventDuplicate(href)) {
            event.stopPropagation();
            return -1;
          }
          if (content.frames.length || isContentFrame(document.commandDispatcher.focusedWindow)) {
            for (var frame_nr = 0; frame_nr < content.frames.length; frame_nr++) {
              if (content.frames[frame_nr].length) { // deep nested
                if (hasChildFrameTargetID(content.frames[frame_nr], targetID))
                  return true;
              }
              if (targetID == content.frames[frame_nr].name)
                return true;
            }
          }
          if (hasTargetNew(targetID) && targetID != "") { // We've got a target attribute
            if (href.indexOf("#") == -1 && mzIsTargetPreviouslyBlocked(event, href))
              return false;
            if (mzIsWindowOpenAllowed(event))
              return true;
            var browser = mzGetNamedBrowser(targetID);

            if (browser) {
              if (gBrowser.mSelectedTab.hasAttribute("redirect-after-ask"))
                return false;
            }
            if (openLinkInNewTab(event, href, targetID)) // Redirect window to (a new) tab
              return -1;
          }
          else
            return true;
        }
        if (gMultiZilla.prefs.readInteger("multizilla.refspoof.spoofing", 1) != 1) {
          if (linkNode.ownerDocument != window.content.document || linkNode.getAttribute("href") == "#" || 
              linkNode.hasAttribute("target") || hasTarget("base", event))
            return true;
          else { 
            event.preventDefault();
            var referrer = getReferrer(document);
            getBrowser().loadURI(href, nsIWebNavigation.LOAD_FLAGS_NONE, referrer, null, null);
            return -1;
          }
        }
	return false;
      case 1: // middle button clicked
        if (href.toLowerCase().search("mailto:") == 0) {
          loadURI(href);
          return false;
        }
        if (openLinkInNewTab(event, href) || openLinkInNewWindow(event, href)) {
          return true;
        }
        break;
    }
    return false;
  }

function middleMousePaste(aEvent)
{
  var url = readFromClipboard();

  if (!url)
    return false;
  url = getShortcutOrURI(url);

  // On ctrl-middleclick, open in new window or tab.  Do not send referrer.
  if (aEvent.ctrlKey) {
    const nsIURIFixup = Components.interfaces.nsIURIFixup; // fix up our pasted URI in case it is malformed.

    if (!gURIFixup)
      gURIFixup = Components.classes["@mozilla.org/docshell/urifixup;1"].getService(nsIURIFixup);

    url = gURIFixup.createFixupURI(url, nsIURIFixup.FIXUP_FLAGS_MAKE_ALTERNATE_URI).spec;
    return openNewTabOrWindow(aEvent, url, false);
  }
  // If ctrl wasn't down, then just load the url in the current win/tab.
  if (url != "about:blank")
    gURLBar.value = url;

  loadURI(url);
  aEvent.stopPropagation();
  return true;
}

function makeURLAbsolute(base, url) 
{
  // Construct nsIURL.
  var ioService = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);

  try {
    var baseURI = ioService.newURI(base, null, null);
    return ioService.newURI(baseURI.resolve(url), null, null).spec;
  } catch(ex) {
    // dump("\nERROR in makeURLAbsolute(): " + ex);
  }
  return null;
}

function hasTarget(name, event)
{
  var sourceDoc = event.target.ownerDocument;
  var node = sourceDoc.getElementsByTagName(name);

  for (var i = 0; i < node.length; ++i) {
    if (node[i].hasAttribute("target"))
      return true;
  }
  return false;
}

function hasTargetNew(target)
{
  target = target.toLowerCase();
  // only the first three are conform HTML specifications
  if (target != "_self" && target != "_top" && target != "_parent" && 
      target != "self" && target != "top" && target != "parent") {
    return true;
  }
  return false;
}

function forcedAutocomplete(event)
{
  var sourceDoc = event.target.ownerDocument;
  var node = event.target;

  if (node.hasAttribute("autocomplete")) {
    if (node.getAttribute("autocomplete").toLowerCase() == "off") {
      node.setAttribute("autocomplete", "on");
      // return;
    }
  }  
  node = sourceDoc.getElementsByTagName("form");
  var onsubmitRemoval = gMultiZilla.prefs.readBoolean("multizilla.forced.autocomplete.onsubmit-remove", false);

  for (var i = 0; i < node.length; ++i) {
    if (onsubmitRemoval) {
      if (node[i].hasAttribute("onsubmit"))
        node[i].removeAttribute("onsubmit");
    }
    if (node[i].hasAttribute("autocomplete")) {
      if (node[i].getAttribute("autocomplete").toLowerCase() == "off") {
        node[i].setAttribute("autocomplete", "on");
      }
    }
  }
  return;
}

function openLinkInNewTab(aEvent, href, target)
{
  var linkNode = aEvent.originalTarget;
  var chromeHidden = (document.documentElement.getAttribute("chromehidden").indexOf("location") != -1);

  while (linkNode && !(linkNode instanceof HTMLAnchorElement)) {
    linkNode = linkNode.parentNode;
  }
  setLinkVisited(linkNode, href);
	
  if (pref && pref.getBoolPref("browser.tabs.opentabfor.middleclick") &&
      ("getBrowser" in window) && getBrowser().localName == "tabbrowser") {
    if (gMultiZilla.tabs.preventDuplicate(href))
      return true;
    // Chromeless window only, prevent hidden tabs (see also bug 2540)
    if (chromeHidden)
      document.documentElement.removeAttribute("chromehidden");

    var tab = null;
    var browser = mzGetNamedBrowser(target);
    var tabBrowser = getBrowser();

    if (browser)
      browser.loadURI(href, getReferrer(document));
    else { // No named tab (browser) available for this target
      browser = gMultiZilla.tabs.checkForBlankTab(); // Try to locate a new/unused blank tab

      if (browser)
        browser.loadURI(href, getReferrer(document));
      else { // No new/unused blank tab available, open a new one
        tab = tabBrowser.addTab(href, getReferrer(document));
      }
    }
    var loadInBackground = pref.getBoolPref("browser.tabs.loadInBackground");

    if (aEvent.shiftKey)
      loadInBackground = !loadInBackground;
    if (!loadInBackground || chromeHidden) {
      if (tab == null)
        tab = tabBrowser.getTabForBrowser(browser);
      tabBrowser.selectedTab = tab;
    }
    aEvent.stopPropagation();
  }
  else {
    openNewWindowWith(href, getReferrer(document));
    aEvent.stopPropagation();
  }
  return true;
}

function openLinkInNewWindow(event, href)
{
  if (pref && pref.getBoolPref("middlemouse.openNewWindow")) {  
    openNewWindowWith(href, getReferrer(document));
    var linkNode = event.originalTarget;

    while (linkNode && !(linkNode instanceof HTMLAnchorElement)) {
      linkNode = linkNode.parentNode;
    }
    setLinkVisited(linkNode, href);
    event.stopPropagation();
    return true;
  }
  return false;
}

function hasChildFrameTargetID(aFrame, frameName)
{
  if (!aFrame || !frameName)
    return false;
  for (var frame_nr = 0; frame_nr < aFrame.length; frame_nr++) {
    if (aFrame.frames[frame_nr].length) {
      if (hasChildFrameTargetID(aFrame.frames[frame_nr], frameName))
        return true;
    }
    if (aFrame.frames[frame_nr].name == frameName)
      return true;
  }
  return false;
}

function setLinkVisited(aNode, aURL, aReferrer)
{
  if (aURL && mzAddToHistory(aURL, aReferrer)) {
    if (aNode && typeof aURL == "string") {
      aNode.href = "";
      aNode.href = aURL;
    }
  }
} 

function mzAddToHistory(aURL, aReferrer)
{
  var globalHistory;
  // Builds 20040210 and up (see also mozilla bug 224829)
  if ("@mozilla.org/browser/global-history;2" in Components.classes)
    globalHistory = Components.classes["@mozilla.org/browser/global-history;2"].getService(Components.interfaces.nsIGlobalHistory2);
  else
    globalHistory = Components.classes["@mozilla.org/browser/global-history;1"].getService(Components.interfaces.nsIGlobalHistory);

  var ioService = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
  var uri = ioService.newURI(aURL, null, null);

  if (!globalHistory.isVisited(uri)) {
    if (aReferrer == undefined)
      aReferrer = null;
    try {
      globalHistory.addURI(uri, false, true, aReferrer);
      return true;
    } catch(ex) {
      globalHistory.addPage(aURL, aReferrer);
      return true;
    }
  }
  return false;
}

function mzIsWindowOpenAllowed(aEvent)
{
  dump("\nmzIsWindowOpenAllowed()");
  var capability = -1;
  var ioService = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
  var baseURI = new XPCNativeWrapper(aEvent.target, "baseURI").baseURI;
  var sourceURI = ioService.newURI(baseURI, null, null);
  var permissionmanager = Components.classes["@mozilla.org/permissionmanager;1"].getService(Components.interfaces.nsIPermissionManager);
  capability = permissionmanager.testPermission(sourceURI, "popup");
  return (capability == nsIPermissionManager.ALLOW_ACTION);
}

function mzGetNamedBrowser(aName)
{
  var browser = gBrowser.getNamedBrowser(aName);

  if (browser)
    return browser;
  else {
    var windowManager = Components.classes['@mozilla.org/appshell/window-mediator;1']
                                  .getService(Components.interfaces.nsIWindowMediator);
    var enumerator = windowManager.getEnumerator("navigator:browser");

    while (enumerator.hasMoreElements()) {
      var targetWindow = enumerator.getNext();
      browser = targetWindow.gBrowser.getNamedBrowser(aName);

      if (browser)
        return browser;
    }
  }
  return null;
}

function mzIsJavaScriptEnabled(aEvent) // No longer used?
{
  if (pref.getBoolPref("javascript.enabled") == false)
    return false;

  var ownerDocument = new XPCNativeWrapper(aEvent.target, "ownerDocument").ownerDocument;
  var browser = getBrowserForDocument(ownerDocument);

  if (browser.docShell.allowJavascript == false)
    return false;

  var prefValue, policyNames = "";
  var blackList = new Array();

  try {
    prefValue = pref.getComplexValue("capability.policy.policynames", Components.interfaces.nsIPrefLocalizedString);
    policyNames = prefValue.data;
  } catch(ex) {
    // throw("Error reading preference 'capability.policy.policynames'");
    return true; // No pref set, bail out early
  }
  if (policyNames.match(/jsblocked/)) { // Should we check for blocked sites?
    // Yes, get the black list
    try {
      prefValue = pref.getComplexValue("capability.policy.jsblocked.sites", Components.interfaces.nsIPrefLocalizedString);
      blackList = prefValue.data;
    } catch(ex) {
      // throw("Error reading preference 'capability.policy.jsblocked.sites'");
      return true; // No pref set, bail out early
    }
    blackList = blackList.split(' ').sort();

    if (blackList.length > 0) { // We should have at least one site on the black list
      var ioService = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
      // var sourceURI = ioService.newURI(event.target.ownerDocument.location.href, null, null);
      var sourceURI = ioService.newURI(ownerDocument.location.href, null, null);
      // var domain = sourceURI.scheme + "://" + event.target.ownerDocument.domain;
      var domain = sourceURI.scheme + "://" + ownerDocument.domain;

      for (i in blackList) {
        if (domain == blackList[i]) // Site on our black list?
	  return false; // Yes, kill onclick event
      }
    }
  }
  return true;
}

function mzIsTargetPreviouslyBlocked(aEvent, aHref)
{
  var ownerDocument = new XPCNativeWrapper(aEvent.target, "ownerDocument").ownerDocument;
  var browser = getBrowserForDocument(ownerDocument);

  if (browser && 'mBlockedWindows' in browser) {
    for (i in browser.mBlockedWindows) {
      if (browser.mBlockedWindows[i].popupWindowURI.spec == aHref)
        return true;
    }
  }
  return false;
}

