from unittest import TestCase, main
import sha256

def bytes(hexbytes):
    return [int(hexbyte, 16) for hexbyte in hexbytes.split()]

def chars(hexbytes):
    return ''.join(map(chr, bytes(hexbytes)))

class TestSHA256(TestCase):
    def test_pad(self):
        equal = self.assertEqual

        s = 'abcdefghijklmnopqrstuvwx ' * 4
        for i in range(0, 100):
            equal(len(sha256.pad(s[:i])) % 64, 0)

    def test_hash(self):
        equal = self.assertEqual

        # Examples from Appendix B of FIPS180-2.
        message = 'abc'
        hash = chars('''ba 78 16 bf 8f 01 cf ea 41 41 40 de 5d ae 22 23
                        b0 03 61 a3 96 17 7a 9c b4 10 ff 61 f2 00 15 ad''')
        equal(sha256.hash(message), hash)

        message = 'abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq'
        hash = chars('''24 8d 6a 61 d2 06 38 b8 e5 c0 26 93 0c 3e 60 39
                        a3 3c e4 59 64 ff 21 67 f6 ec ed d4 19 db 06 c1''')
        equal(sha256.hash(message), hash)

if __name__ == '__main__':
    main()
