from unittest import TestCase, main
import os, threading, sha, srp6a

N = 125617018995153554710546479714086468244499594888726646874671447258204721048803L
g = 2
srp = srp6a.SRP(N, g, lambda m: sha.sha(m).digest())

def readline(fd):
    line = ''
    while not line.endswith('\n'):
        line += os.read(fd, 1)
    return line

def pipe():
    readable, writable = os.pipe()
    def send(value):
        os.write(writable, str(value) + '\n')
    def recv():
        return int(readline(readable).strip())
    return send, recv

class PlayerThread(threading.Thread):
    def __init__(self, player, send, recv):
        threading.Thread.__init__(self)
        self.player = player
        self.send, self.recv = send, recv

    def run(self):
        push = self.player.next()
        for message in self.player:
            if message is None:
                push(self.recv())
            else:
                self.send(message)

class TestSRP6a(TestCase):
    def test_srp6a(self):
        equal = self.assertEqual

        s, v = srp.setup('abc123')
        csend, srecv = pipe()
        ssend, crecv = pipe()

        C = srp6a.Object()
        S = srp6a.Object()
        client = PlayerThread(srp.login('carol', 'abc123', C), csend, crecv)
        server = PlayerThread(srp.authenticate('carol', s, v, S), ssend, srecv)
        client.start()
        server.start()
        client.join()
        server.join()

        print 'client key', C.key
        print 'server key', S.key
        equal(C.key, S.key)

main()
