#include "stdafx.h"
#include <memory.h>
#include "CE_Common.h"

namespace CoreSync
{
	System::String ^Utils::ToBlindString(Contact ^oContact)
	{
		System::String ^input=gcnew System::String(L"");
		input+=System::Convert::ToString(oContact->anniversary.Ticks);
		input+=oContact->assistant;
		input+=oContact->assistantTel;
		input+=oContact->beeper;
		input+=System::Convert::ToString(oContact->birthDate.Ticks);
		input+=oContact->carTel;
		input+=oContact->children;
		// customID is not included
		input+=oContact->email;
		input+=oContact->email2;
		input+=oContact->email3;
		input+=oContact->firstName;
		input+=oContact->fullName;
		// hashValue is not included. It is produced by this function
		input+=oContact->homeCity;
		input+=oContact->homeCountry;
		input+=oContact->homeFax;
		input+=oContact->homeProvince;
		input+=oContact->homeStreet;
		input+=oContact->homeTel;
		input+=oContact->homeTel2;
		input+=oContact->homeZipcode;
		input+=oContact->job;
		input+=oContact->lastName;
		input+=oContact->middleName;
		input+=oContact->mobileTel;
		input+=oContact->officeCity;
		input+=oContact->officeCountry;
		input+=oContact->officeFax;
		input+=oContact->officeLocation;
		input+=oContact->officeProvince;
		input+=oContact->officeStreet;
		input+=oContact->officeTel;
		input+=oContact->officeTel2;
		input+=oContact->officeZipcode;
		input+=oContact->otherCity;
		input+=oContact->otherCountry;
		input+=oContact->otherProvince;
		input+=oContact->otherStreet;
		input+=oContact->otherZipcode;
		input+=oContact->radioTel;
		input+=oContact->society;
		input+=oContact->spouse;
		input+=oContact->suffix;
		// timeStamp is not included. It is... nearly useless, since there is no way to confirm its validity from PocketPC-side.
		input+=oContact->title;
		input+=oContact->unit;
		input+=oContact->webpage;
		return input;
	}

	System::String ^Utils::GetMD5(Contact ^oContact)
	{
		System::String ^input=ToBlindString(oContact);

		// Convert the string into an array of bytes.
		array<unsigned char> ^unicodeText = gcnew array<unsigned char>(input->Length * sizeof(wchar_t));
		System::Text::Encoder ^enc = System::Text::Encoding::Unicode->GetEncoder();
		enc->GetBytes(input->ToCharArray(), 0, input->Length, unicodeText, 0, true);

		// Calculate checksum
		System::Security::Cryptography::MD5 ^md5 = gcnew System::Security::Cryptography::MD5CryptoServiceProvider();
		array<unsigned char> ^result = md5->ComputeHash(unicodeText);

		// Build the final string by converting each byte into hex
		System::Text::StringBuilder ^sb = gcnew System::Text::StringBuilder();
		System::BitConverter::ToString(result);
		for(int i=0;i<result->Length;i++)
			sb->AppendFormat("{0:X2}", result[i]);
		System::String ^output=sb->ToString()->Replace(L" ", L"");

		// Return the calculated checksum
		return output;
	}

	System::String ^Utils::GetSHA1(Contact ^oContact)
	{
		System::String ^input=ToBlindString(oContact);

		// Convert the string into an array of bytes.
		array<unsigned char> ^unicodeText = gcnew array<unsigned char>(input->Length * sizeof(wchar_t));
		System::Text::Encoder ^enc = System::Text::Encoding::Unicode->GetEncoder();
		enc->GetBytes(input->ToCharArray(), 0, input->Length, unicodeText, 0, true);

		// Calculate checksum
		System::Security::Cryptography::SHA1 ^sha1 = gcnew System::Security::Cryptography::SHA1CryptoServiceProvider();
		array<unsigned char> ^result = sha1->ComputeHash(unicodeText);

		// Build the final string by converting each byte into hex
		System::Text::StringBuilder ^sb = gcnew System::Text::StringBuilder();
		System::BitConverter::ToString(result);
		for(int i=0;i<result->Length;i++)
			sb->AppendFormat("{0:X2}", result[i]);
		System::String ^output=sb->ToString()->Replace(L" ", L"");

		// Return the calculated checksum
		return output;
	}



	System::String ^getPropertyType(int iPropID)
	{
		switch(LOWORD(iPropID))
		{
		case CEVT_BLOB:
			return gcnew System::String(L"BLOB");
			break;
		case CEVT_BOOL:
			return gcnew System::String(L"BOOL");
			break;
		case CEVT_FILETIME:
			return gcnew System::String(L"FILETIME");
			break;
		case CEVT_I2:
			return gcnew System::String(L"I2");
			break;
		case CEVT_I4:
			return gcnew System::String(L"I4");
			break;
		case CEVT_LPWSTR:
			return gcnew System::String(L"LPWSTR");
			break;
		case CEVT_R8:
			return gcnew System::String(L"R8");
			break;
		case CEVT_UI2:
			return gcnew System::String(L"UI2");
			break;
		case CEVT_UI4:
			return gcnew System::String(L"UI4");
			break;
		default:
			return gcnew System::String(L"Unknown");
			break;
		}
	}

	System::String ^getPropertyValue(CEPROPVAL* oValues,int iProperty, int iTotalProperties)
	{
		CEPROPVAL *values=oValues;
		CEPROPVAL value;
		/*
		for(int i=0;i<iTotalProperties;i++)
		{
			value=values[i];
			System::String ^test=getPropertyType(value.propid);
			System::String ^test2=getPropertyType(iProperty);
		}
		*/

		for(int i=0;i<iTotalProperties;i++)
		{
			value=values[i];
			if(value.propid==iProperty)
			{
				System::String ^retval = gcnew System::String(value.val.lpwstr);
				return retval;
			}
		}
		return gcnew System::String(L"");
	}

	System::DateTime getDTPropertyValue(CEPROPVAL* oValues,int iProperty, int iTotalProperties)
	{
		CEPROPVAL *values=oValues;
		CEPROPVAL value;

		for(int i=0;i<iTotalProperties;i++)
		{
			value=values[i];
			if(value.propid==iProperty)
			{
				__int64 hFT2 = (((__int64) value.val.filetime.dwHighDateTime) << 32);
				hFT2+= value.val.filetime.dwLowDateTime;
				System::DateTime retval;
				retval=retval.FromFileTime(hFT2);
				//retval=retval->AddYears(1600);		// Needed because FILETIME starts on January 1th, 1601
				return retval;
			}
		}
		return System::DateTime(0);
	}

	FILETIME toFILETIME(System::DateTime oDateTime)
	{
		try
		{
			System::DateTime dt = oDateTime;
			//dt=dt->AddYears(-1600);
			System::TimeSpan ts=(dt.Now - dt.UtcNow);
			dt = dt.AddHours(ts.Hours);
			__int64 hFT1 = dt.ToFileTime();
			FILETIME ft;
			ft.dwLowDateTime = (int) ((__int64)(hFT1 & 0xFFFFFFFF));
			ft.dwHighDateTime = (int) (hFT1 >> 32);
			return ft;
		}
		catch(System::Exception ^e)
		{
			FILETIME ft;
			ft.dwLowDateTime = 0;
			ft.dwHighDateTime = 0;
			return ft;
		}
	}

	LPWSTR toLPWSTR(System::String ^oString)
	{
		LPWSTR retval = (LPWSTR)malloc((1+oString->Length)*sizeof(WCHAR));
		memset(retval, 0, (1+oString->Length)*sizeof(WCHAR));
		array<wchar_t> ^arr = oString->ToCharArray();
		int i=0;
		for each(wchar_t ch in arr)
		{
			retval[i++]=ch;
		}

		return retval;
	}

}

