/***********************************************************************
*                           DesignDocument
*                       (xmDesignDocument.js)
*                           version 0.40
************************************************************************
*
* Description:
* ===========
*
* Contributors:
* ============
*	Franklin de Graaf (version 0.20-0.50)
*	Michael Hearn (version 0.10) 
*
***********************************************************************/
if(TRACE_LOADING){ alert("Start loading: xmDesignDocument.js"); }


//======================================================================
//  DesignDocument
//======================================================================
// This is the target XUL document

//----------------------------------------------------------------------
// DesignDocument::DesignDocument() (Constructor)
//----------------------------------------------------------------------

function DesignDocument() {
const METHOD_NAME = "DesignDocument::DesignDocument";
trace(METHOD_NAME, "BEGIN" );

	this.topNode;
	this.activeNode;
	this.fileName;
	this.windowDebugMode = true; //The initial value should correspond to the menuitem value

	this.newFile(); //this initializes topNode and activeNode and fileName;



	// create palette of elements (widgets)
	this.elementData = new Array();
	this.elementData[0] = this.makeElementData("default","*");
	this.elementData[1] = this.makeElementData("window","*");
	this.elementData[2] = this.makeElementData("box","*");
	this.elementData[3] = this.makeElementData("hbox","*");
	this.elementData[4] = this.makeElementData("vbox","*");
	this.elementData[5] = this.makeElementData("button","");
	this.elementData[6] = this.makeElementData("label","");
	this.elementData[7] = this.makeElementData("textbox","");
	this.elementData[8] = this.makeElementData("image","");
	this.elementData[9] = this.makeElementData("groupbox","");
	this.elementData[10] = this.makeElementData("spacer","");
	this.elementData[11] = this.makeElementData("grid","rows");
	this.elementData[12] = this.makeElementData("rows","row");
	this.elementData[13] = this.makeElementData("row","label textbox"); //<<<<<<****** temporary
	this.elementData[14] = this.makeElementData("tabbox","tabs tabpanels");
	this.elementData[15] = this.makeElementData("tabs","tab");
	this.elementData[16] = this.makeElementData("tab","");
	this.elementData[17] = this.makeElementData("tabpanels","tabpanel");
	this.elementData[18] = this.makeElementData("tabpanel","*");
	this.elementData[19] = this.makeElementData("toolbox","menubar toolbar");
	this.elementData[20] = this.makeElementData("menubar","box vbox hbox menu menupopup menuitem");
	this.elementData[21] = this.makeElementData("menu","menuitem menupopup");
	this.elementData[22] = this.makeElementData("menupopup","menuitem menu");
	this.elementData[23] = this.makeElementData("menuitem","");
	this.elementData[24] = this.makeElementData("toolbar","toolbarbutton");
	this.elementData[25] = this.makeElementData("toolbarbutton","");
	this.elementData[26] = this.makeElementData("undefined","*");

	// create an idcounter for each element and initialize it to "0"
      this.idcounter = new Array();
	for (i=0; i < this.elementData.length; i++) {
		this.idcounter[this.elementData[i].tag] = 0;
	}

trace(METHOD_NAME, "END" );
}
 
//----------------------------------------------------------------------
// DesignDocument::accesors/mutators
//----------------------------------------------------------------------

DesignDocument.prototype.getTopNode = function(){
	return this.topNode;
}
DesignDocument.prototype.getActiveNode = function(){
	return this.activeNode;
}

//----------------------------------------------------------------------
// DesignDocument::makeElementData()
//----------------------------------------------------------------------

DesignDocument.prototype.makeElementData = function(tag,acceptsChildren) {
	// acceptschildren can be:
	//   a space separated list of elements
	//   * = all
	//   "" = none
	obj = new Object();
	obj.tag = tag;
	obj.acceptsChildren = acceptsChildren;
	return obj;
}

//----------------------------------------------------------------------
// DesignDocument::getElementData()
//----------------------------------------------------------------------

DesignDocument.prototype.getElementData = function(tag) {
	for (i=0; i<this.elementData.length; i++) {
		if (this.elementData[i].tag == tag) { return this.elementData[i] }
	}
	return null;
}

//----------------------------------------------------------------------
// DesignDocument::showBadChildWarning()
//----------------------------------------------------------------------

DesignDocument.prototype.showBadChildWarning = function(what) {
	alert("Warning: Cannot add "+what+" to this type of node!");
}

//----------------------------------------------------------------------
// DesignDocument::removeDocument(designView)
//----------------------------------------------------------------------
// Removes the window element (tree node) from the contained view element.
// (There may be other elements in the view element, e.g. observe elements.)

DesignDocument.prototype.removeDocument = function (designView) {
const METHOD_NAME = "DesignDocument::removeDocument";
trace(METHOD_NAME, "BEGIN" );

	// Remove any current window element(s)
	if (designView.hasChildNodes) {
		var nodelist = designView.childNodes;
		//alert("Design View has " + nodelist.length + " nodes.");
		for (var i=0; i<nodelist.length; i++) {
			//alert("design-view node[" + i + "]=" + nodelist[i].tagName);
			var elementName = nodelist[i].tagName;
			elementName = elementName.substring(elementName.indexOf(":")+1, elementName.length); // strip off leading namespace
			if (elementName=="window") {
				designView.removeChild(nodelist[i]);
			}
		}
	}

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// DesignDocument::newDocument(designView)
//----------------------------------------------------------------------

DesignDocument.prototype.newDocument = function (designView) {
const METHOD_NAME = "DesignDocument::newDocument";
trace(METHOD_NAME, "BEGIN" );

	// Generate the window element in the design view
	// <window id="window" xulmaker-active="true" debug="true" onclick="xm.theDesignDocument.onClick(event.target);return false;"/>
	//this.topNode = document.getElementById("window");
	this.topNode = document.createElement("window");
	this.topNode.setAttribute("xmlns", "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul");
	this.topNode.setAttribute("id", "window");
	this.topNode.setAttribute(ACTIVE_ATTRNAME, "true");
	if (this.windowDebugMode) {
		this.topNode.setAttribute("debug", "true");
	}
	this.topNode.addEventListener("click",this.onClick,false);
	designView.appendChild(this.topNode);

	this.activeNode = this.topNode;
	// setting attributes here seems to temporarily	block any attributes that are already defined
	this.activeNode.setAttribute(ACTIVE_ATTRNAME, "true");

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// DesignDocument::newFile()
//----------------------------------------------------------------------

DesignDocument.prototype.newFile = function(){
const METHOD_NAME = "DesignDocument::newFile";
trace(METHOD_NAME, "BEGIN" );

	try {

	var theDesignView = document.getElementById(DESIGN_VIEW_ID);
	this.removeDocument(theDesignView);
	this.newDocument(theDesignView);

	this.fileName = null; // reset file name
	} catch (e) {
		alert("DesignDocument::newFile() ERROR: " + e);
	}

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// DesignDocument::openFile()
//----------------------------------------------------------------------

DesignDocument.prototype.openFile = function () {
const METHOD_NAME = "DesignDocument::openFile";
trace(METHOD_NAME, "BEGIN" );

	//if (browserMode) { setSecurity(); }
	if (browserMode) { 
		try {
			netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
			//netscape.security.PrivilegeManager.enablePrivilege("UniversalFileAccess");
			netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserWrite");
	     		trace( METHOD_NAME, "INFO", "Set Security");
		} catch (e) {
 	     		trace( METHOD_NAME, "ERROR", "Could NOT set security. " + e );
		}
	}

	// Get File from "Open File" dialog
	// TODO: should persist last path chosen in a preference
	// TODO: for efficiency we should parse direcly from the InputStream (using "parseFromStream")
	var path = null;
	var fileDialog = FilePickerUtils.pickFile("Open File ", path, ["filterAll", "filterXML", "filterXUL"], "Open");
	trace( METHOD_NAME, "MSG", "selected file path: " + fileDialog.path);

	if (fileDialog) { //skip if we cancelled out of the file dialog

		this.fileName = fileDialog.path;

		// Read XUL file (text)
		var file; 
		var xulString;
		try {
			file = new File(this.fileName); 
			file.open("r");
			trace( METHOD_NAME, "MSG", "opened file for read.");
			xulString = file.read();
			trace( METHOD_NAME, "MSG", "read: " + xulString);
			file.close();
			trace( METHOD_NAME, "MSG", "closed file.");
		} catch (e) {
			alert(METHOD_NAME+"() Create, Open, Read, or Close ERROR - " + e);
		}

		// Parse XUL document (text)
		if (xulString) {
      		var aParser = new DOMParser();
			trace( METHOD_NAME, "MSG", "Created DOMParser");
			var xulDocument;
			try {
				xulDocument = aParser.parseFromString( xulString , "text/xml" ) ;
				trace( METHOD_NAME, "MSG", "Parsed the XUL string.");
			} catch (e) {
				alert(e);
			}

			// Place XUL document (tree node) into the design view (tree node)
			if (xulDocument) {
				var theDesignView = document.getElementById(DESIGN_VIEW_ID);
				this.removeDocument(theDesignView);
				// this function copies the contents of the XUL Document into the Design View
				this.topNode=xulDocument.documentElement.cloneNode(true);
				theDesignView.appendChild(this.topNode);

				// The window element is destroyed when we save, so we rebuild it here
				this.topNode.setAttribute("xmlns", "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul");
				this.topNode.setAttribute("id", "window");
				this.topNode.setAttribute(ACTIVE_ATTRNAME, "true");
				this.topNode.setAttribute("debug", "true");
				this.topNode.addEventListener("click",this.onClick,false);
			}
		}

	}

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// DesignDocument::saveFile()
//----------------------------------------------------------------------
// Serialize the XUL document

DesignDocument.prototype.saveFile = function () {
const METHOD_NAME = "DesignDocument::saveFile";
trace(METHOD_NAME, "BEGIN" );

	if(!this.fileName) {
		this.saveAsFile();
	} else {

	// Cleans the document
	this.activeNode.removeAttribute(ACTIVE_ATTRNAME);
	
	// Create XUL document (node tree)
	var w = this.topNode;
	var xulDocument = document.implementation.createDocument("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul","window",null);
	for (var i = 0; i < w.childNodes.length; i++) {
  		copyNodeToDoc(w.childNodes.item(i),xulDocument);
	}
	
	// Serialize the document (from nodes to text)
	var serializer = new XMLSerializer();
	//var xulString = serializer.serializeToString(xulDocument);
	var xulString = serializer.serializeToString(this.topNode);
      trace( METHOD_NAME, "MSG", "Serialized the XUL document: " + xulString);
	
	var path = this.fileName;
	// Put the file
		try {
			var file = new File(path);
			file.open('w');
			trace( METHOD_NAME, "MSG", "opened file for write.");
			file.write('<?xml version="1.0"?>');
			file.write('<?xml-stylesheet href="chrome://global/skin" type="text/css"?>');
			file.write(xulString);
			trace( METHOD_NAME, "MSG", "wrote: " + xulString);
			file.close();
			trace( METHOD_NAME, "MSG", "closed file.");
		} catch (e) {
			alert("File io error: " + e);
		}
	
	// Restore the document
	this.activeNode.setAttribute(ACTIVE_ATTRNAME, "true");

	}

trace(METHOD_NAME, "END" );
}


//----------------------------------------------------------------------
// DesignDocument::saveAsFile()
//----------------------------------------------------------------------
// Serialize the XUL document

DesignDocument.prototype.saveAsFile = function () {
const METHOD_NAME = "DesignDocument::saveAsFile";
trace(METHOD_NAME, "BEGIN" );

	//if (browserMode) { setSecurity(); }
	if (browserMode) {
		try {
			netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
			//netscape.security.PrivilegeManager.enablePrivilege("UniversalFileAccess");
			netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserWrite");
      		trace( METHOD_NAME, "INFO", "Set Security");
		} catch (e) {
      		trace( METHOD_NAME, "ERROR", "Could NOT set security. " + e );
		}
	}



	// Select file path and name
	var path = null; // TODO: should persist last path chosen in a pref
	var fileDialog = FilePickerUtils.pickFile("Save As File ", path, ["filterAll", "filterXML"], "Save");
	path = fileDialog.path;
      trace( METHOD_NAME, "MSG", "path: " + fileDialog.path);
/*
	if (fileDialog) {
      	var ioService = XPCU.getService("@mozilla.org/network/io-service;1","nsIIOService");
      	var url = ioService.getURLSpecFromFile(nsFile);
      	// XX temporary until 56354 is fixed
      	//url = url.replace("file://", "file:///");
		alert("URL: " + url);
		path= url;
	}      
*/
	this.fileName = path;
	this.saveFile();

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// DesignDocument::setWindowDebugMode(debugMode)
//----------------------------------------------------------------------

DesignDocument.prototype.setWindowDebugMode = function (windowDebugMode) {
const METHOD_NAME = "DesignDocument::setWindowDebugMode";
trace(METHOD_NAME, "BEGIN" );

	//var booleanStr = (windowDebugMode) ? "true" : "false"; alert("request to set windowDebugMode = " + booleanStr );
	this.windowDebugMode = windowDebugMode;

trace(METHOD_NAME,"INFO","current debug: " + this.topNode.getAttribute("debug"));
	if (this.topNode.hasAttribute("debug")) {
		if ((this.topNode.getAttribute("debug")=="true")& windowDebugMode) {
			//this.topNode.removeAttribute("debug");
			this.topNode.setAttribute("debug", "false");
		} else {
			this.topNode.setAttribute("debug", "true");
		}
	} else {
		this.topNode.setAttribute("debug", "true")
	}
trace(METHOD_NAME,"INFO","toggled debug: " + this.topNode.getAttribute("debug"));

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// DesignDocument::addElement(elementType)
//----------------------------------------------------------------------
// adds an element of element type to the active element

DesignDocument.prototype.addElement = function(elementType) {
const METHOD_NAME = "DesignDocument::addElement";
trace(METHOD_NAME, "BEGIN" );
trace(METHOD_NAME, "INFO", "elementType=" + elementType );

	//alert("this.activeNode.getAttribute('xulmaker-active') == " + this.activeNode.getAttribute(ACTIVE_ATTRNAME) );
	//assert(this.activeNode.getAttribute(ACTIVE_ATTRNAME)=="true");

	// check that the parent can accept tags of type elementType
	this.activeNodeData = this.getElementData(this.activeNode.tagName);
	accepts = false;
trace(METHOD_NAME, "MSG", "parent node: " + this.activeNode.elementType + " accepts: " + this.activeNodeData.acceptsChildren );
	if (this.activeNodeData.acceptsChildren == "*") {
		accepts = true
	} else {
		acceptsChildren = this.activeNodeData.acceptsChildren.split(" ");
		for (i=0; i < acceptsChildren.length; i++) {
			if (acceptsChildren[i] == elementType) { accepts = true; }
		}
	}
	if (!accepts) {
		this.showBadChildWarning(elementType);
		return null;
	}

	// Create whitespace at start of each element - newline plus tabs
	indent = "\t";  //TODO: iterate indent according to depth of element
	whitespace = document.createTextNode("\n" + indent);
	xx=this.activeNode.appendChild(whitespace);

	//if (elementType == "grid") { elementType = "box"; } //<<<<<<<<<<<<<***************
	var newChild = document.createElement(elementType);

	// Revert to using "undefined" as elementType if not in our standard list
//alert("this.idcounter[" + elementType + "]=\"" + this.idcounter[elementType] + "\"");
	if (this.idcounter[elementType] == undefined) { elementType = "undefined"; }
//alert("elementType=\"" + elementType + "\"");

	// Create a unique id = elementType + number, for the new node
	newid = elementType+this.idcounter[elementType];
	if (isIDUnique(newid) == false) {

		do {
			this.idcounter[elementType]++;
			newid = elementType+this.idcounter[elementType];
		} while (isIDUnique(newid) == false)

	}
	newChild.setAttribute("id",newid);
	this.idcounter[elementType]++;

trace(METHOD_NAME, "MSG", "newChild: " + newChild);  //newChild is [XUL Element]
	// some assertions
	if (this.activeNode == null) { alert("System Error: "); }
	if (newChild == null) { alert("System Error: "); }

trace(METHOD_NAME, "MSG", "adding " + newChild.id + " to " + this.activeNode.id + ".");
	//this.activeNode.appendChild(newChild); //<<<<<<<<<<*********** adding grid crashes here, but not other elements
	xx=this.activeNode.appendChild(newChild);
trace(METHOD_NAME, "MSG", "added");
		//Note: we need to appendChild before we can add the eventListener to get access to the event

	// Assign event listener for click event to the new node
	newChild.addEventListener("click",this.onClick,false);  //<====*******************
		// (Isn't this the same as adding an "onclick" attribute to the element?)
		// No. We don't want a visible "onclick" attribute in the Design Document.
		// Note also that onClick can't have arguments in this case, but the event
		// is passed by default.

	if (elementType == "button") { newChild.setAttribute("label", newid); }
	if (elementType == "label") { newChild.setAttribute("value", newid); }
	if (elementType == "textbox") { newChild.setAttribute("value", newid); }
	if (elementType == "tab") { newChild.setAttribute("label", newid); }
	if (elementType == "menu") { newChild.setAttribute("label", newid); }
	if (elementType == "menuitem") { newChild.setAttribute("label", newid); }

trace(METHOD_NAME, "MSG", "added \"" + newid + "\"");
trace(METHOD_NAME, "MSG", "with value/label attribute = " + newid );
trace(METHOD_NAME, "END" );
	//return (newChild.getAttribute("id"));
	return (newChild);
}

//----------------------------------------------------------------------
// DesignDocument::deleteElement()
//----------------------------------------------------------------------
// deletes the active element

DesignDocument.prototype.deleteElement = function() {
const METHOD_NAME = "DesignDocument::deleteElement";
trace(METHOD_NAME, "BEGIN" );
trace(METHOD_NAME, "MSG", "Deleting: " + this.activeNode.tagName );

	pnode = this.activeNode.parentNode;
	old = this.activeNode;
	// change selection of the active node - before removing the currently active node
	this.selectElement(pnode.getAttribute("id")); // make parent the new active element (OR some sibling)
	pnode.removeChild(old);

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// DesignDocument::selectElement(id)
//----------------------------------------------------------------------

DesignDocument.prototype.selectElement = function (id) {
const METHOD_NAME = "DesignDocument::selectElement";
trace(METHOD_NAME, "BEGIN" );

	newnode = document.getElementById(id);

	//make some assertions
	if (newnode == null) { alert("System Error: DesignDocument: Selected element \"" + id + "\" could not be found."); }
	if (this.activeNode.getAttribute(ACTIVE_ATTRNAME)==null) { alert("System error: DesignDocument: The active element: " + this.activeNode.id + " doesn't have the  'xulmaker-active' attribute."); }

trace(METHOD_NAME, "MSG", "deselecting " + this.activeNode.id );
	this.activeNode.removeAttribute(ACTIVE_ATTRNAME); // deselect currently active node
trace(METHOD_NAME, "MSG", "selecting " + newnode.id );
 	newnode.setAttribute(ACTIVE_ATTRNAME,"true"); // select new active node
	this.activeNode = newnode;

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// DesignDocument::onChangeElementSelection(event)
//----------------------------------------------------------------------

DesignDocument.prototype.onChangeElementSelection = function(event) {
const METHOD_NAME = "DesignDocument::onChangeElementSelection";
trace(METHOD_NAME, "BEGIN" );

	// get the id of the new selection
	// (There should be an easier way of getting this.)
	var broadcaster = document.getElementById(event.target.getAttribute("element"));
	id = broadcaster.getAttribute("selection");
trace(METHOD_NAME, "MSG", "selection: " + id );

	this.selectElement(id);

trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// DesignDocument::onClick(event)
//----------------------------------------------------------------------

DesignDocument.prototype.onClick = function(event) {
const METHOD_NAME = "DesignDocument::onClick";
trace(METHOD_NAME, "BEGIN" );

	var id = event.target.getAttribute("id");
trace(METHOD_NAME, "MSG", "Clicked on \"" + id + "\".");

	// Fire an "selection" event which gets broadcast to other observers as well as to theDesignDocument (here).
	var broadcaster = document.getElementById(NAMESPACE + "onChangeElementSelection");
	broadcaster.setAttribute("selection", id );

trace(METHOD_NAME, "MSG", "Broadcaster element attribute set to \"" + id + "\".");
trace(METHOD_NAME, "END" );
}

//----------------------------------------------------------------------
// DesignDocument::updateModel(xmlDOM)
//----------------------------------------------------------------------

//TODO: change this to "replaceModel()"
DesignDocument.prototype.updateModel = function(xmlDOM) {
const METHOD_NAME = "DesignDocument::updateModel";
trace(METHOD_NAME, "BEGIN" );

				var theDesignView = document.getElementById(DESIGN_VIEW_ID);
				this.removeDocument(theDesignView);
				theDesignView.appendChild(xmlDOM);
				this.topNode = xmlDOM;

trace(METHOD_NAME, "END" );
}
/***********************************************************************
if(TRACE_LOADING){ alert("Continuing loading: xmDesignDocument.js"); }
***********************************************************************/
if(TRACE_LOADING){ alert("Finish loading: xmDesignDocument.js"); }
