#ifndef VIDEOAUDIOINPUT_HPP
#define VIDEOAUDIOINPUT_HPP

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qobject.h>
#include <qvector.h>

class CVideoDevice;

class CVideoAudioInput: public QObject
{
   Q_OBJECT
private:
   CVideoDevice *pVideo;
   int Channel;

   int Flags;
   QString Name;

public:
   enum {
     Mono,
     Stereo,
     Language1,
     Language2,   
   } Modes;

   CVideoAudioInput(CVideoDevice *video, int channel);

   int GetNumber() const;   
   QString GetName() const;

   bool IsMutable();
   bool IsMuted();
   int GetVolume() const;
   int GetBass() const;
   int GetTreble() const;
   
public slots:
   void Mute(bool mute_on);
   void SetVolume(int volume);
   void SetBass(int bass);
   void SetTreble(int treble);
};


#endif
