/*** Warning! This file has been generated by the script makeaddressee ***/
/*
    This file is part of libkabc.
    Copyright (c) 2002 Cornelius Schumacher <schumacher@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

/*
Enhanced Version of the file for platform independent KDE tools.
Copyright (c) 2004 Ulf Schenk

$Id: field.cpp,v 1.4 2004/09/09 18:57:58 ulf69 Exp $
*/

#include <klocale.h>
#include <kconfig.h>
#include <kconfigbase.h>
#include <kglobal.h>

#include "field.h"
#include "resource.h"

using namespace KABC;

class Field::FieldImpl
{
  public:
    FieldImpl( int fieldId, int category = 0,
               const QString &label = QString::null,
               const QString &key = QString::null,
               const QString &app = QString::null )
      : mFieldId( fieldId ), mCategory( category ), mLabel( label ),
        mKey( key ), mApp( app ) {}
  
    enum FieldId
    {
      CustomField,
      FormattedName,
      FamilyName,
      GivenName,
      AdditionalName,
      Prefix,
      Suffix,
      NickName,
      Birthday,
      HomeAddressStreet,
      HomeAddressLocality,
      HomeAddressRegion,
      HomeAddressPostalCode,
      HomeAddressCountry,
      HomeAddressLabel,
      BusinessAddressStreet,
      BusinessAddressLocality,
      BusinessAddressRegion,
      BusinessAddressPostalCode,
      BusinessAddressCountry,
      BusinessAddressLabel,
      HomePhone,
      BusinessPhone,
      MobilePhone,
      HomeFax,
      BusinessFax,
      CarPhone,
      Isdn,
      Pager,
      Email,
      Mailer,
      Title,
      Role,
      Organization,
      Note,
      Url,
      Resource,
      Sip
    };

    int fieldId() { return mFieldId; }
    int category() { return mCategory; }
    
    QString label() { return mLabel; }
    QString key() { return mKey; }
    QString app() { return mApp; }
    
  private:
    int mFieldId;
    int mCategory;

    QString mLabel;
    QString mKey;
    QString mApp;
};


Field::List Field::mAllFields;
Field::List Field::mDefaultFields;
Field::List Field::mCustomFields;


Field::Field( FieldImpl *impl )
{
  mImpl = impl;
}

Field::~Field()
{
  delete mImpl;
}

QString Field::label()
{
  switch ( mImpl->fieldId() ) {
    case FieldImpl::FormattedName:
      return Addressee::formattedNameLabel();
    case FieldImpl::FamilyName:
      return Addressee::familyNameLabel();
    case FieldImpl::GivenName:
      return Addressee::givenNameLabel();
    case FieldImpl::AdditionalName:
      return Addressee::additionalNameLabel();
    case FieldImpl::Prefix:
      return Addressee::prefixLabel();
    case FieldImpl::Suffix:
      return Addressee::suffixLabel();
    case FieldImpl::NickName:
      return Addressee::nickNameLabel();
    case FieldImpl::Birthday:
      return Addressee::birthdayLabel();
    case FieldImpl::HomeAddressStreet:
      return Addressee::homeAddressStreetLabel();
    case FieldImpl::HomeAddressLocality:
      return Addressee::homeAddressLocalityLabel();
    case FieldImpl::HomeAddressRegion:
      return Addressee::homeAddressRegionLabel();
    case FieldImpl::HomeAddressPostalCode:
      return Addressee::homeAddressPostalCodeLabel();
    case FieldImpl::HomeAddressCountry:
      return Addressee::homeAddressCountryLabel();
    case FieldImpl::HomeAddressLabel:
      return Addressee::homeAddressLabelLabel();
    case FieldImpl::BusinessAddressStreet:
      return Addressee::businessAddressStreetLabel();
    case FieldImpl::BusinessAddressLocality:
      return Addressee::businessAddressLocalityLabel();
    case FieldImpl::BusinessAddressRegion:
      return Addressee::businessAddressRegionLabel();
    case FieldImpl::BusinessAddressPostalCode:
      return Addressee::businessAddressPostalCodeLabel();
    case FieldImpl::BusinessAddressCountry:
      return Addressee::businessAddressCountryLabel();
    case FieldImpl::BusinessAddressLabel:
      return Addressee::businessAddressLabelLabel();
    case FieldImpl::HomePhone:
      return Addressee::homePhoneLabel();
    case FieldImpl::BusinessPhone:
      return Addressee::businessPhoneLabel();
    case FieldImpl::MobilePhone:
      return Addressee::mobilePhoneLabel();
    case FieldImpl::HomeFax:
      return Addressee::homeFaxLabel();
    case FieldImpl::BusinessFax:
      return Addressee::businessFaxLabel();
    case FieldImpl::CarPhone:
      return Addressee::carPhoneLabel();
    case FieldImpl::Isdn:
      return Addressee::isdnLabel();
    case FieldImpl::Pager:
      return Addressee::pagerLabel();
    case FieldImpl::Email:
      return Addressee::emailLabel();
    case FieldImpl::Mailer:
      return Addressee::mailerLabel();
    case FieldImpl::Title:
      return Addressee::titleLabel();
    case FieldImpl::Role:
      return Addressee::roleLabel();
    case FieldImpl::Organization:
      return Addressee::organizationLabel();
    case FieldImpl::Note:
      return Addressee::noteLabel();
    case FieldImpl::Url:
      return Addressee::urlLabel();
    case FieldImpl::Resource:
      return Addressee::resourceLabel();
    case FieldImpl::Sip:
      return Addressee::sipLabel();
    case FieldImpl::CustomField:
      return mImpl->label();
    default:
      return i18n("Unknown Field");
  }
}

int Field::category()
{
  return mImpl->category();
}

QString Field::categoryLabel( int category )
{
  switch ( category ) {
    case All:
      return i18n("All");
    case Frequent:
      return i18n("Frequent");
    case Address:
      return i18n("Address");
    case Email:
      return i18n("Email");
    case Personal:
      return i18n("Personal");
    case Organization:
      return i18n("Organization");
    case CustomCategory:
      return i18n("Custom");
    default:
      return i18n("Undefined");
  }
}

QString Field::value( const KABC::Addressee &a )
{
  switch ( mImpl->fieldId() ) {
    case FieldImpl::FormattedName:
      return a.formattedName();
    case FieldImpl::FamilyName:
      return a.familyName();
    case FieldImpl::GivenName:
      return a.givenName();
    case FieldImpl::AdditionalName:
      return a.additionalName();
    case FieldImpl::Prefix:
      return a.prefix();
    case FieldImpl::Suffix:
      return a.suffix();
    case FieldImpl::NickName:
      return a.nickName();
    case FieldImpl::Mailer:
      return a.mailer();
    case FieldImpl::Title:
      return a.title();
    case FieldImpl::Role:
      return a.role();
    case FieldImpl::Organization:
      return a.organization();
    case FieldImpl::Note:
      return a.note();
    case FieldImpl::Email:
      return a.preferredEmail();
    case FieldImpl::Birthday:
      if ( a.birthday().isValid() ) {
//the generated code had the following format: return a.birthday().date().toString( Qt::ISODate );
// But Qt::IsoDate was not specified.
//       QString _oldFormat = KGlobal::locale()->dateFormat();
//       KGlobal::locale()->setDateFormat("%Y-%m-%d"); // = Qt::ISODate
       QString dt = KGlobal::locale()->formatDate(a.birthday().date(), false, KLocale::ISODate);
//       KGlobal::locale()->setDateFormat(_oldFormat);
       return dt;
     }
     else
        return QString::null;
    case FieldImpl::Url:
      return a.url().prettyURL();
//US    
    case FieldImpl::Resource:
      return a.resource()->resourceName();
    case FieldImpl::HomePhone:
      return a.phoneNumber( PhoneNumber::Home ).number();
    case FieldImpl::BusinessPhone:
      return a.phoneNumber( PhoneNumber::Work ).number();
    case FieldImpl::MobilePhone:
      return a.phoneNumber( PhoneNumber::Cell ).number();
    case FieldImpl::HomeFax:
      return a.phoneNumber( PhoneNumber::Home | PhoneNumber::Fax ).number();
    case FieldImpl::BusinessFax:
      return a.phoneNumber( PhoneNumber::Work | PhoneNumber::Fax ).number();
    case FieldImpl::CarPhone:
      return a.phoneNumber( PhoneNumber::Car ).number();
    case FieldImpl::Isdn:
      return a.phoneNumber( PhoneNumber::Isdn ).number();
    case FieldImpl::Pager:
      return a.phoneNumber( PhoneNumber::Pager ).number();
    case FieldImpl::Sip:
      return a.phoneNumber( PhoneNumber::Sip ).number();
    case FieldImpl::HomeAddressStreet:
      return a.address( Address::Home ).street();
    case FieldImpl::HomeAddressLocality:
      return a.address( Address::Home ).locality();
    case FieldImpl::HomeAddressRegion:
      return a.address( Address::Home ).region();
    case FieldImpl::HomeAddressPostalCode:
      return a.address( Address::Home ).postalCode();
    case FieldImpl::HomeAddressCountry:
      return a.address( Address::Home ).country();
    case FieldImpl::BusinessAddressStreet:
      return a.address( Address::Work ).street();
    case FieldImpl::BusinessAddressLocality:
      return a.address( Address::Work ).locality();
    case FieldImpl::BusinessAddressRegion:
      return a.address( Address::Work ).region();
    case FieldImpl::BusinessAddressPostalCode:
      return a.address( Address::Work ).postalCode();
    case FieldImpl::BusinessAddressCountry:
      return a.address( Address::Work ).country();
    case FieldImpl::CustomField:
      return a.custom( mImpl->app(), mImpl->key() );
    default:
      return QString::null;
  }
}

bool Field::setValue( KABC::Addressee &a, const QString &value )
{
  switch ( mImpl->fieldId() ) {
    case FieldImpl::FormattedName:
      a.setFormattedName( value );
      return true;
    case FieldImpl::FamilyName:
      a.setFamilyName( value );
      return true;
    case FieldImpl::GivenName:
      a.setGivenName( value );
      return true;
    case FieldImpl::AdditionalName:
      a.setAdditionalName( value );
      return true;
    case FieldImpl::Prefix:
      a.setPrefix( value );
      return true;
    case FieldImpl::Suffix:
      a.setSuffix( value );
      return true;
    case FieldImpl::NickName:
      a.setNickName( value );
      return true;
    case FieldImpl::Mailer:
      a.setMailer( value );
      return true;
    case FieldImpl::Title:
      a.setTitle( value );
      return true;
    case FieldImpl::Role:
      a.setRole( value );
      return true;
    case FieldImpl::Organization:
      a.setOrganization( value );
      return true;
    case FieldImpl::Note:
      a.setNote( value );
      return true;
    case FieldImpl::Birthday:
//US
//the generated code had the following format: return a.setBirthday( QDate::fromString( value, Qt::ISODate ) );
// But Qt::IsoDate and QDate::fromString was not specified. Do I have the wrong QT version ?
      {
      QDate dt = KGlobal::locale()->readDate( value, "%Y-%m-%d");  // = Qt::ISODate
      a.setBirthday(dt);
      }
      return true;
    case FieldImpl::CustomField:
      a.insertCustom( mImpl->app(), mImpl->key(), value );
//US never copy the resourcename back to the adressee. 
    case FieldImpl::Resource:
    default:
      return false;
  }
}

bool Field::isCustom()
{
  return mImpl->fieldId() == FieldImpl::CustomField;
}

Field::List Field::allFields()
{
  if ( mAllFields.isEmpty() ) {
    createField( FieldImpl::FormattedName, Frequent );
    createField( FieldImpl::FamilyName, Frequent );
    createField( FieldImpl::GivenName, Frequent );
    createField( FieldImpl::AdditionalName );
    createField( FieldImpl::Prefix );
    createField( FieldImpl::Suffix );
    createField( FieldImpl::NickName, Personal );
    createField( FieldImpl::Birthday, Personal );
    createField( FieldImpl::HomeAddressStreet, Address|Personal );
    createField( FieldImpl::HomeAddressLocality, Address|Personal );
    createField( FieldImpl::HomeAddressRegion, Address|Personal );
    createField( FieldImpl::HomeAddressPostalCode, Address|Personal );
    createField( FieldImpl::HomeAddressCountry, Address|Personal );
    createField( FieldImpl::HomeAddressLabel, Address|Personal );
    createField( FieldImpl::BusinessAddressStreet, Address|Organization );
    createField( FieldImpl::BusinessAddressLocality, Address|Organization );
    createField( FieldImpl::BusinessAddressRegion, Address|Organization );
    createField( FieldImpl::BusinessAddressPostalCode, Address|Organization );
    createField( FieldImpl::BusinessAddressCountry, Address|Organization );
    createField( FieldImpl::BusinessAddressLabel, Address|Organization );
    createField( FieldImpl::HomePhone, Personal|Frequent );
    createField( FieldImpl::BusinessPhone, Organization|Frequent );
    createField( FieldImpl::MobilePhone, Frequent );
    createField( FieldImpl::HomeFax );
    createField( FieldImpl::BusinessFax );
    createField( FieldImpl::CarPhone );
    createField( FieldImpl::Isdn );
    createField( FieldImpl::Pager );
    createField( FieldImpl::Email, Email|Frequent );
    createField( FieldImpl::Mailer, Email );
    createField( FieldImpl::Title, Organization );
    createField( FieldImpl::Role, Organization );
    createField( FieldImpl::Organization, Organization );
    createField( FieldImpl::Note );
    createField( FieldImpl::Url );
    createField( FieldImpl::Resource );
    createField( FieldImpl::Sip );
  }

  return mAllFields;
}

Field::List Field::defaultFields()
{
  if ( mDefaultFields.isEmpty() ) {
    createDefaultField( FieldImpl::GivenName );
    createDefaultField( FieldImpl::FamilyName );
    createDefaultField( FieldImpl::Email );
  }

  return mDefaultFields;
}

void Field::createField( int id, int category )
{
  mAllFields.append( new Field( new FieldImpl( id, category ) ) );
}

void Field::createDefaultField( int id, int category )
{
  mDefaultFields.append( new Field( new FieldImpl( id, category ) ) );
}

void Field::deleteFields()
{
  Field::List::ConstIterator it;

  for( it = mAllFields.begin(); it != mAllFields.end(); ++it ) {
    delete (*it);
  }
  mAllFields.clear();

  for( it = mDefaultFields.begin(); it != mDefaultFields.end(); ++it ) {
    delete (*it);
  }
  mDefaultFields.clear();

  for( it = mCustomFields.begin(); it != mCustomFields.end(); ++it ) {
    delete (*it);
  }
  mCustomFields.clear();
}

void Field::saveFields( const QString &identifier,
                        const Field::List &fields )
{
  KConfig *cfg = KGlobal::config();
  KConfigGroupSaver( cfg, "KABCFields" );
  saveFields( cfg, identifier, fields );
}

void Field::saveFields( KConfig *cfg, const QString &identifier,
                        const Field::List &fields )
{
  QValueList<int> fieldIds;

//US
//  qDebug("Field::saveFields to %s %s", cfg->getFileName().latin1(), identifier.latin1());
    
  int custom = 0;
  Field::List::ConstIterator it;
  for( it = fields.begin(); it != fields.end(); ++it ) {
//US  
//  qDebug("Field::saveFields field:%i", (*it)->mImpl->fieldId());
    
    fieldIds.append( (*it)->mImpl->fieldId() );
    if( (*it)->isCustom() ) {
      QStringList customEntry;
      customEntry << (*it)->mImpl->label();
      customEntry << (*it)->mImpl->key();
      customEntry << (*it)->mImpl->app();
      cfg->writeEntry( "KABC_CustomEntry_" + identifier + "_" +
                       QString::number( custom++ ), customEntry );
    }
  }
  cfg->writeEntry( identifier, fieldIds );
}

Field::List Field::restoreFields( const QString &identifier )
{
//US
//  qDebug("Field::restoreFields, identifier: %s", identifier.latin1());
  
  KConfig *cfg = KGlobal::config();
  KConfigGroupSaver( cfg, "KABCFields" );
  cfg->setGroup( "KABCFields" );
  
  Field::List l = restoreFields( cfg, identifier );

  return l;
}

Field::List Field::restoreFields( KConfig *cfg, const QString &identifier )
{
  QValueList<int> fieldIds = cfg->readIntListEntry( identifier);
//US
//  qDebug("Field::restoreFields from %s, identifier: %s", cfg->getFileName().latin1(), identifier.latin1());
  
  Field::List fields;

  int custom = 0;
  QValueList<int>::ConstIterator it;
  for( it = fieldIds.begin(); it != fieldIds.end(); ++it ) {
    FieldImpl *f = 0;
    if ( (*it) == FieldImpl::CustomField ) {
      QStringList customEntry = cfg->readListEntry( "KABC_CustomEntry_" +
                                                 identifier + "_" +
                                                 QString::number( custom++ ) );
      f = new FieldImpl( *it, CustomCategory, customEntry[ 0 ],
                         customEntry[ 1 ], customEntry[ 2 ] );
    } else {
      f = new FieldImpl( *it );
    }
    fields.append( new Field( f ) );
  }
  
  return fields;
}

bool Field::equals( Field *field )
{
  bool sameId = ( mImpl->fieldId() == field->mImpl->fieldId() );

  if ( !sameId ) return false;

  if ( mImpl->fieldId() != FieldImpl::CustomField ) return true;
  
  return mImpl->key() == field->mImpl->key();
}

Field *Field::createCustomField( const QString &label, int category,
                                 const QString &key, const QString &app )
{
  Field *field = new Field( new FieldImpl( FieldImpl::CustomField,
                                           category | CustomCategory,
                                           label, key, app ) );
//US
//  qDebug("Field::createCustomField label %s", label.latin1() );
  
  mCustomFields.append( field );

  return field;
}
