/*
    This file is part of KAddressbook/Pi.
    Copyright (c) 2004 Lutz Rogowski <rogowski@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/

#include <qtooltip.h>
#include <qframe.h>
#include <qpixmap.h>
#include <qlayout.h>
#include <qprogressbar.h>
#include <qwidgetstack.h>
#include <qdatetime.h>
#include <qdir.h>
#include <qapplication.h>
#include <qhbox.h>
#include <qheader.h>
#include <qdatetime.h>
#include <qlistview.h>

#include <kdebug.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <kmessagebox.h>
#include <kfiledialog.h>

#include <libkdepim/categoryselectdialog.h>
#include <libkdepim/kinputdialog.h>

#include <libkcal/calendarlocal.h>
#include <libkcal/icalformat.h>

#include <kabc/addresseelist.h>
#include <kabc/phonenumber.h>

#include "kaimportoldialog.h"

#include "../outport/msoutl9.h"
#include <ole2.h>
#include <comutil.h>
_Application gOlAppAB;

QDateTime mDdate2Qdtr( DATE dt)
{
    COleDateTime odt;
    SYSTEMTIME st;
    odt = dt;
    if ( odt.GetStatus() != 0 )
      return QDateTime();
    odt.GetAsSystemTime(st);
    if ( st.wYear > 4000  ) // this program as a year 4000 bug!
      return QDateTime();
    // it seems so, that 1.1.4501 indicates: DATE invalid
    QDateTime qdt (QDate(st.wYear, st.wMonth,st.wDay ),QTime( st.wHour, st.wMinute,st.wSecond ) );
    return qdt;
}

class OLEListViewItem : public QCheckListItem
{
  public:
    OLEListViewItem( QListView *parent, QString text ) :
      QCheckListItem( parent, text, QCheckListItem::CheckBox ) { ; };
    OLEListViewItem(  QListViewItem *after, QString text ) :
      QCheckListItem( after, text, QCheckListItem::CheckBox ) { ; };
    ~OLEListViewItem() {};
  void setData( DWORD data ) {mData= data; };
  DWORD data() { return mData ;};
  private:
     DWORD  mData;
}; 

KAImportOLdialog::KAImportOLdialog( const QString &caption, 
                                      KABC::AddressBook * aBook, QWidget *parent ) :
    KDialogBase( Plain, caption, User1 | Close, Ok,
               parent, caption, true, false, i18n("Import!") )
{
  QHBox * mw = new  QHBox( this );
  setMainWidget( mw );
  mListView = new QListView( mw );
  mListView->addColumn(i18n("Select Folder to import"));
  mListView->addColumn(i18n("Content Type"));
  mABook = aBook;
  connect( this, SIGNAL( user1Clicked() ),SLOT ( slotApply()));
  setupFolderView();
  resize( sizeHint().width()+50,  sizeHint().height()+50 );
}

KAImportOLdialog::~KAImportOLdialog()
{
   
}

KABC::Addressee::List KAImportOLdialog::getAddressList()
{
  return mAList;
}
void KAImportOLdialog::setupFolderView()
{
  SCODE sc = ::OleInitialize(NULL);
  if ( FAILED ( sc ) ) {
    KMessageBox::information(this,"OLE initialisation failed");
    return;
  }
  
  if(!gOlAppAB.CreateDispatch(_T("Outlook.Application"),NULL)){
    KMessageBox::information(this,"Sorry, cannot access Outlook");
    return ;
  }
  MAPIFolder mfInbox;
  MAPIFolder mfRoot;
  CString szName;
  _NameSpace olNS; 
  olNS = gOlAppAB.GetNamespace(_T("MAPI"));
  mfInbox = olNS.GetDefaultFolder(6);
  mfRoot = mfInbox.GetParent();
  szName = mfRoot.GetName();
  long iType = mfRoot.GetDefaultItemType();
  QString mes;
  mes = QString::fromUcs2( szName.GetBuffer() );
  OLEListViewItem * root = new OLEListViewItem( mListView, mes );
  mfRoot.m_lpDispatch->AddRef();
  addFolder( root, mfRoot.m_lpDispatch );
  root->setOpen( true );
  mListView->setSortColumn( 0 );
  mListView->sort( );
}


void KAImportOLdialog::addFolder(OLEListViewItem* iParent, LPDISPATCH dispParent)
{
  MAPIFolder mfParent(dispParent), mfChild;
  _Folders folders;
  _variant_t fndx((long)0);
  CString szName;
  long iType;
  OLEListViewItem* hChild;

    folders = mfParent.GetFolders();    
    for(int i=1; i <= folders.GetCount(); ++i)
    {
      fndx = (long)i;
      mfChild = folders.Item(fndx.Detach());
      mfChild.m_lpDispatch->AddRef();
      szName = mfChild.GetName();
      iType = mfChild.GetDefaultItemType();
      hChild = new OLEListViewItem( iParent , QString::fromUcs2( szName.GetBuffer() ) );
      if ( iType != 2)
	hChild->setEnabled( false );
      QString ts; 
      switch( iType ) {
      case 0:
	ts = i18n("Mail");
	break;
      case 1:
	ts = i18n("Calendar");
	break;
      case 2:
	ts = i18n("Contacts");
	break;
      case 3:
	ts = i18n("Todos");
	break;
      case 4:
	ts = i18n("Journals");
	break;
      case 5:
	ts = i18n("Notes");
	break;
      default:
	ts = i18n("Unknown");
      }
      hChild->setText( 1,ts);
      hChild->setData( (DWORD) mfChild.m_lpDispatch );
      mfChild.m_lpDispatch->AddRef();
      addFolder(hChild, mfChild.m_lpDispatch);
    }
}

void KAImportOLdialog::slotApply()
{
  importedItems = 0;
  OLEListViewItem* child = (OLEListViewItem*) mListView->firstChild();
  while ( child ) {
    if ( child->isOn() )
      readContactData( child->data() );
    child = (OLEListViewItem*) child->itemBelow();
  }
  QString mes = i18n("Importing complete.\n\n%1 items imported.").arg( importedItems);
  KMessageBox::information(this,mes);
}
void KAImportOLdialog::readContactData( DWORD folder )
{

  LPDISPATCH dispItem = (LPDISPATCH)folder;
  dispItem->AddRef();
  MAPIFolder mf(dispItem);
  mf.m_lpDispatch->AddRef();
  _Items folderItems;
  _variant_t indx((long)0);
  LPDISPATCH itm;
  int i;
  folderItems = mf.GetItems(); 
  QProgressBar bar( folderItems.GetCount(),0 );
  bar.setCaption (i18n("Importing - close to abort!") );
  int h = bar.sizeHint().height() ;
  int w = 300;
  int dw = QApplication::desktop()->width();
  int dh = QApplication::desktop()->height();
  bar.setGeometry( (dw-w)/2, (dh - h )/2 ,w,h );
  bar.show();
  for(i=1; i <= folderItems.GetCount(); ++i)
    {
      qApp->processEvents();
      if ( ! bar.isVisible() )
            return ;
      bar.setProgress( i );
      indx = (long)i;
      itm = folderItems.Item(indx.Detach());
      _ContactItem * pItem = (_ContactItem *)&itm;
      ol2kapiContact( pItem );
      itm->Release();
    }
}
void KAImportOLdialog::slotOk()
{
   QDialog::accept();
}

void KAImportOLdialog::ol2kapiContact( _ContactItem * aItem )
{
  KABC::Addressee  addressee;
  
  addressee.setUid( QString::fromUcs2(aItem->GetEntryID().GetBuffer()));
  //GetLastModificationTime()
  //addressee.setName( const QString &name );
  //addressee.setFormattedName( const QString &formattedName );
  addressee.setFamilyName( QString::fromUcs2(aItem->GetLastName().GetBuffer()) );
  addressee.setGivenName( QString::fromUcs2(aItem->GetFirstName().GetBuffer()) );
  addressee.setAdditionalName( QString::fromUcs2(aItem->GetMiddleName().GetBuffer()) );
  addressee.setPrefix(QString::fromUcs2(aItem->GetTitle().GetBuffer()) );
  addressee.setSuffix( QString::fromUcs2(aItem->GetSuffix().GetBuffer()) );
  addressee.setNickName( QString::fromUcs2(aItem->GetNickName().GetBuffer()) );
  QDateTime dtb = mDdate2Qdtr(aItem->GetBirthday());
  if ( dtb.isValid() )
    addressee.setBirthday( mDdate2Qdtr(aItem->GetBirthday()));

  //QString::fromUcs2(aItem->.GetBuffer())
  //addressee.setMailer( const QString &mailer );
  //addressee.setTimeZone( const TimeZone &timeZone );
  //addressee.setGeo( const Geo &geo );
  //addressee.setTitle( QString::fromUcs2(aItem->GetJobTitle().GetBuffer()) );// titel is the prefix
  addressee.setRole( QString::fromUcs2(aItem->GetJobTitle().GetBuffer()) );
  addressee.setOrganization( QString::fromUcs2(aItem->GetCompanyName().GetBuffer()) );
  addressee.setNote( QString::fromUcs2(aItem->GetBody().GetBuffer()) );
   
  addressee.setProductId( QString::fromUcs2(aItem->GetCustomerID().GetBuffer()) );
  //addressee.setRevision( const QDateTime &revision );
  // addressee.setSortString( const QString &sortString );
  addressee.setUrl( QString::fromUcs2(aItem->GetWebPage().GetBuffer()) );

  QString tempS;
  tempS = QString::fromUcs2(aItem->GetNetMeetingAlias().GetBuffer())+" AT SERVER: " +QString::fromUcs2(aItem->GetNetMeetingServer().GetBuffer());
  if ( tempS.length() > 12 )
    addressee.insertCustom( "KADDRESSBOOK", "X-IMAddress", tempS );
  tempS = QString::fromUcs2(aItem->GetSpouse().GetBuffer());
  if ( !tempS.isEmpty() )
    addressee.insertCustom( "KADDRESSBOOK", "X-SpousesName", tempS );
  tempS = QString::fromUcs2(aItem->GetManagerName().GetBuffer());
  if ( !tempS.isEmpty() )
    addressee.insertCustom( "KADDRESSBOOK", "X-ManagersName", tempS );
  tempS = QString::fromUcs2(aItem->GetAssistantName().GetBuffer());
  if ( !tempS.isEmpty() )
    addressee.insertCustom( "KADDRESSBOOK", "X-AssistantsName", tempS );
  tempS = QString::fromUcs2(aItem->GetDepartment().GetBuffer());
  if ( !tempS.isEmpty() )
    addressee.insertCustom( "KADDRESSBOOK", "X-Department", tempS );
  tempS = QString::fromUcs2(aItem->GetOfficeLocation().GetBuffer());
  if ( !tempS.isEmpty() )
    addressee.insertCustom( "KADDRESSBOOK", "X-Office",tempS );
  tempS = QString::fromUcs2(aItem->GetProfession().GetBuffer());
  if ( !tempS.isEmpty() )
    addressee.insertCustom( "KADDRESSBOOK", "X-Profession", tempS );
  dtb =  mDdate2Qdtr(aItem->GetAnniversary());
  if (dtb.isValid() ) {
    QString dt = KGlobal::locale()->formatDate( dtb.date() , true, KLocale::ISODate);
    addressee.insertCustom( "KADDRESSBOOK", "X-Anniversary", dt);
  }
  int sec =   aItem->GetSensitivity() ;
  if ( sec > 1 )// mapping pers -> private
    --sec;
  addressee.setSecrecy( sec );
  //addressee.setLogo( const Picture &logo );
  //addressee.setPhoto( const Picture &photo );
  //addressee.setSound( const Sound &sound );
  //addressee.setAgent( const Agent &agent );
  QString cat = QString::fromUcs2( aItem->GetCategories().GetBuffer());
  addressee.setCategories( QStringList::split( ";", cat ));
  
  QString phoneS;

  phoneS = QString::fromUcs2( aItem->GetAssistantTelephoneNumber().GetBuffer());
  if ( ! phoneS.isEmpty()) 
    addressee.insertPhoneNumber( KABC::PhoneNumber(phoneS ,KABC::PhoneNumber::Work + KABC::PhoneNumber::Voice ) );
  phoneS = QString::fromUcs2( aItem->GetBusinessTelephoneNumber().GetBuffer());
  if ( ! phoneS.isEmpty()) 
    addressee.insertPhoneNumber( KABC::PhoneNumber(phoneS ,KABC::PhoneNumber::Work ) );
  phoneS = QString::fromUcs2( aItem->GetBusiness2TelephoneNumber().GetBuffer());
  if ( ! phoneS.isEmpty()) 
    addressee.insertPhoneNumber( KABC::PhoneNumber(phoneS ,KABC::PhoneNumber::Work ) );
  phoneS = QString::fromUcs2( aItem->GetBusinessFaxNumber().GetBuffer());
  if ( ! phoneS.isEmpty()) 
    addressee.insertPhoneNumber( KABC::PhoneNumber(phoneS ,KABC::PhoneNumber::Work + KABC::PhoneNumber::Fax ) );
  phoneS = QString::fromUcs2( aItem->GetCarTelephoneNumber().GetBuffer());
  if ( ! phoneS.isEmpty()) 
    addressee.insertPhoneNumber( KABC::PhoneNumber(phoneS ,KABC::PhoneNumber::Car ) );
  phoneS = QString::fromUcs2( aItem->GetHomeTelephoneNumber().GetBuffer());
  if ( ! phoneS.isEmpty()) 
    addressee.insertPhoneNumber( KABC::PhoneNumber(phoneS ,KABC::PhoneNumber::Home  ) );
  phoneS = QString::fromUcs2( aItem->GetHome2TelephoneNumber().GetBuffer());
  if ( ! phoneS.isEmpty()) 
    addressee.insertPhoneNumber( KABC::PhoneNumber(phoneS ,KABC::PhoneNumber::Home ) );
  phoneS = QString::fromUcs2( aItem->GetHomeFaxNumber().GetBuffer());
  if ( ! phoneS.isEmpty()) 
    addressee.insertPhoneNumber( KABC::PhoneNumber(phoneS ,KABC::PhoneNumber::Home + KABC::PhoneNumber::Fax ) );
  phoneS = QString::fromUcs2( aItem->GetISDNNumber().GetBuffer());
  if ( ! phoneS.isEmpty()) 
    addressee.insertPhoneNumber( KABC::PhoneNumber(phoneS ,KABC::PhoneNumber::Isdn ) );
  phoneS = QString::fromUcs2( aItem->GetMobileTelephoneNumber().GetBuffer());
  if ( ! phoneS.isEmpty()) 
    addressee.insertPhoneNumber( KABC::PhoneNumber(phoneS ,KABC::PhoneNumber::Cell ) );
  phoneS = QString::fromUcs2( aItem->GetOtherFaxNumber().GetBuffer());
  if ( ! phoneS.isEmpty()) 
    addressee.insertPhoneNumber( KABC::PhoneNumber(phoneS ,KABC::PhoneNumber::Fax ) );
  phoneS = QString::fromUcs2( aItem->GetOtherTelephoneNumber().GetBuffer());
  if ( ! phoneS.isEmpty()) 
    addressee.insertPhoneNumber( KABC::PhoneNumber(phoneS ,KABC::PhoneNumber::Voice ) );
  phoneS = QString::fromUcs2( aItem->GetPagerNumber().GetBuffer());
  if ( ! phoneS.isEmpty()) 
    addressee.insertPhoneNumber( KABC::PhoneNumber(phoneS ,KABC::PhoneNumber::Pager ) );
  phoneS = QString::fromUcs2( aItem->GetPrimaryTelephoneNumber().GetBuffer());
  if ( ! phoneS.isEmpty()) 
    addressee.insertPhoneNumber( KABC::PhoneNumber(phoneS ,KABC::PhoneNumber::Pref ) );
  phoneS = QString::fromUcs2( aItem->GetTTYTDDTelephoneNumber().GetBuffer());
  if ( ! phoneS.isEmpty()) 
    addressee.insertPhoneNumber( KABC::PhoneNumber(phoneS ,KABC::PhoneNumber::Modem ) );
  phoneS = QString::fromUcs2( aItem->GetTelexNumber().GetBuffer());
  if ( ! phoneS.isEmpty()) 
    addressee.insertPhoneNumber( KABC::PhoneNumber(phoneS ,KABC::PhoneNumber::Fax + KABC::PhoneNumber::Bbs ) );
  phoneS = QString::fromUcs2( aItem->GetCompanyMainTelephoneNumber().GetBuffer());
  if ( ! phoneS.isEmpty()) 
    addressee.insertPhoneNumber( KABC::PhoneNumber(phoneS ,KABC::PhoneNumber::Work + KABC::PhoneNumber::Pref ) );
  phoneS = QString::fromUcs2( aItem->GetRadioTelephoneNumber().GetBuffer());
  if ( ! phoneS.isEmpty()) 
    addressee.insertPhoneNumber( KABC::PhoneNumber(phoneS ,KABC::PhoneNumber::Video  ) );
  phoneS = QString::fromUcs2( aItem->GetCallbackTelephoneNumber().GetBuffer());
  if ( ! phoneS.isEmpty()) 
    addressee.insertPhoneNumber( KABC::PhoneNumber(phoneS ,KABC::PhoneNumber::Voice + KABC::PhoneNumber::Pref ) );
 
  bool preferred = true;
  phoneS = QString::fromUcs2( aItem->GetEmail1Address().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressee.insertEmail(phoneS  , preferred );
    preferred = false;
  }
  phoneS = QString::fromUcs2( aItem->GetEmail2Address().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressee.insertEmail(phoneS  , preferred );
    preferred = false;
  }
  phoneS = QString::fromUcs2( aItem->GetEmail3Address().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressee.insertEmail(phoneS  , preferred );
    preferred = false;
  }
  // is this the number of the preferred email?
  //	long GetSelectedMailingAddress();???
 
  KABC::Address addressHome;
  KABC::Address* addressAdd = &addressHome;
  bool insert = false;
  phoneS = QString::fromUcs2( aItem->GetHomeAddressCountry().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressAdd->setCountry(phoneS  );
    insert = true;
  }
  phoneS = QString::fromUcs2( aItem->GetHomeAddressState().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressAdd->setRegion(phoneS   );
    insert = true;
  }
  phoneS = QString::fromUcs2( aItem->GetHomeAddressCity().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressAdd->setLocality(phoneS  );
    insert = true;
  }
  phoneS = QString::fromUcs2( aItem->GetHomeAddressPostalCode().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressAdd->setPostalCode(phoneS  );
    insert = true;
  }
  phoneS = QString::fromUcs2( aItem->GetHomeAddressPostOfficeBox().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressAdd->setPostOfficeBox(phoneS  );
    insert = true;
  }
  phoneS = QString::fromUcs2( aItem->GetHomeAddressStreet().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressAdd->setStreet(phoneS  );
    insert = true;
  }
  phoneS = QString::fromUcs2( aItem->GetHomeAddress().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    // redundant !addressAdd->setExtended(phoneS  );
    // insert = true;
  }
  addressAdd->setType( KABC::Address::Home );
  if ( insert )
    addressee.insertAddress( *addressAdd );
  // ++++++++++++++++++++++ end of address

  KABC::Address addressWork;
  addressAdd = &addressWork;
  insert = false;
  phoneS = QString::fromUcs2( aItem->GetBusinessAddressCountry().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressAdd->setCountry(phoneS  );
    insert = true;
  }
  phoneS = QString::fromUcs2( aItem->GetBusinessAddressState().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressAdd->setRegion(phoneS   );
    insert = true;
  }
  phoneS = QString::fromUcs2( aItem->GetBusinessAddressCity().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressAdd->setLocality(phoneS  );
    insert = true;
  }
  phoneS = QString::fromUcs2( aItem->GetBusinessAddressPostalCode().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressAdd->setPostalCode(phoneS  );
    insert = true;
  }
  phoneS = QString::fromUcs2( aItem->GetBusinessAddressPostOfficeBox().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressAdd->setPostOfficeBox(phoneS  );
    insert = true;
  }
  phoneS = QString::fromUcs2( aItem->GetBusinessAddressStreet().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressAdd->setStreet(phoneS  );
    insert = true;
  }
  phoneS = QString::fromUcs2( aItem->GetBusinessAddress().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    // redundant !addressAdd->setExtended(phoneS  );
    // insert = true;
  }
  addressAdd->setType( KABC::Address::Work );
  if ( insert )
    addressee.insertAddress( *addressAdd );
  // ++++++++++++++++++++++ end of address

 KABC::Address addressOther;
  addressAdd = &addressOther;
  insert = false;
  phoneS = QString::fromUcs2( aItem->GetOtherAddressCountry().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressAdd->setCountry(phoneS  );
    insert = true;
  }
  phoneS = QString::fromUcs2( aItem->GetOtherAddressState().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressAdd->setRegion(phoneS   );
    insert = true;
  }
  phoneS = QString::fromUcs2( aItem->GetOtherAddressCity().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressAdd->setLocality(phoneS  );
    insert = true;
  }
  phoneS = QString::fromUcs2( aItem->GetOtherAddressPostalCode().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressAdd->setPostalCode(phoneS  );
    insert = true;
  }
  phoneS = QString::fromUcs2( aItem->GetOtherAddressPostOfficeBox().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressAdd->setPostOfficeBox(phoneS  );
    insert = true;
  }
  phoneS = QString::fromUcs2( aItem->GetOtherAddressStreet().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressAdd->setStreet(phoneS  );
    insert = true;
  }
  phoneS = QString::fromUcs2( aItem->GetOtherAddress().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    // redundant !addressAdd->setExtended(phoneS  );
    //insert = true;
  }
  //addressAdd->setId(  );
  if ( insert )
    addressee.insertAddress( *addressAdd );
  // ++++++++++++++++++++++ end of address
 KABC::Address addressMail;
  addressAdd = &addressMail;
  insert = false;
  phoneS = QString::fromUcs2( aItem->GetMailingAddressCountry().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressAdd->setCountry(phoneS  );
    insert = true;
  }
  phoneS = QString::fromUcs2( aItem->GetMailingAddressState().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressAdd->setRegion(phoneS   );
    insert = true;
  }
  phoneS = QString::fromUcs2( aItem->GetMailingAddressCity().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressAdd->setLocality(phoneS  );
    insert = true;
  }
  phoneS = QString::fromUcs2( aItem->GetMailingAddressPostalCode().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressAdd->setPostalCode(phoneS  );
    insert = true;
  }
  phoneS = QString::fromUcs2( aItem->GetMailingAddressPostOfficeBox().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressAdd->setPostOfficeBox(phoneS  );
    insert = true;
  }
  phoneS = QString::fromUcs2( aItem->GetMailingAddressStreet().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    addressAdd->setStreet(phoneS  );
    insert = true;
  }
  phoneS = QString::fromUcs2( aItem->GetMailingAddress().GetBuffer());
  if ( ! phoneS.isEmpty()) {
    // redundant ! addressAdd->setExtended(phoneS  );
    // insert = true;
  }
  addressAdd->setType( KABC::Address::Postal ); 
  if ( insert ) {
    addressee.insertAddress( *addressAdd );
  }
  // the following code is disabled
  // it does not seem to be useful
#if 0
  if ( insert ) {
    addressAdd->setType( KABC::Address::Home );
    if ( addressMail == addressHome ) {
      addressHome.setType( KABC::Address::Postal+ KABC::Address::Home );
      addressee.insertAddress( addressHome );
    } else { 
      addressAdd->setType( KABC::Address::Work );
      if ( addressMail == addressWork ){
	addressWork.setType( KABC::Address::Postal+ KABC::Address::Work );
	addressee.insertAddress( addressWork );

      } else {
	addressAdd->setType( 0 );
	if ( addressOther == addressMail ){
	  addressOther.setType( KABC::Address::Postal );
	  addressee.insertAddress( addressOther );
	} else {
	  addressee.insertAddress( *addressAdd );
	}
      }
    }
  }
#endif
  // ++++++++++++++++++++++ end of ALL addresses
  //GetUserProperties();
  tempS = QString::fromUcs2(aItem->GetInternetFreeBusyAddress().GetBuffer());
  if ( !tempS.isEmpty() )
    addressee.insertCustom( "KADDRESSBOOK", "X-FreeBusyUrl", tempS );
  tempS = QString::fromUcs2(aItem->GetChildren().GetBuffer());
  if ( !tempS.isEmpty() )
    addressee.insertCustom( "KADDRESSBOOK", "X-Children", tempS );
  int gen  = aItem->GetGender();
  if ( gen != 0  ) { // 0 undef - 1 female - 2 male 
    if ( gen == 1 )
      addressee.insertCustom( "KADDRESSBOOK", "X-Gender", "female" );
    else
      addressee.insertCustom( "KADDRESSBOOK", "X-Gender", "male" );
  }

#if 0  
  // pending
  - IM address: no clue where to get info about the helper ID
    -custom fields: difficult to implement - not implemented
    -keys: makes no sense
#endif
   
  if ( addAddressee( addressee ))
    ++importedItems;
}
void KAImportOLdialog::slotCancel()
{
  reject();
}

bool KAImportOLdialog::addAddressee( KABC::Addressee a )
{
  bool add = true;
  KABC::Addressee::List::Iterator it;
    for ( it = mAList.begin(); it != mAList.end(); ++it ) {
      if ( (*it).uid() == a.uid() ) {
	add = false;
	break;
      }
    }
    if ( add ) {
      if ( mABook->findByUid(a.uid() ).isEmpty())
	mAList.append ( a );
      else 
	add = false;
    }
    return add;
}
