/*
    This file is part of KOrganizer.
    Copyright (c) 2001 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <qlayout.h>
#include <qtextbrowser.h>
#include <qtextcodec.h>
#include <qfileinfo.h>
#include <qlabel.h>

#include <qapplication.h>

#include <kglobal.h>
#include <klocale.h>
#include <kdebug.h>
#include <kiconloader.h>
#include <kmessagebox.h>

#include <libkcal/calendar.h>

#ifndef KORG_NOPRINTER
#include "calprinter.h"
#endif
#include "koglobals.h"
#include "koprefs.h"
#include "koeventviewerdialog.h"

#include "kowhatsnextview.h"
using namespace KOrg;

void WhatsNextTextBrowser::setSource(const QString& n)
{

    if (n.startsWith("event:")) {
        emit showIncidence(n);
        return;
    } else if (n.startsWith("todo:")) {
        emit showIncidence(n);
        return;
    } else {
        QTextBrowser::setSource(n);
    }
}

KOWhatsNextView::KOWhatsNextView(Calendar *calendar, QWidget *parent,
                                 const char *name)
    : KOrg::BaseView(calendar, parent, name)
{
    //  mDateLabel =
    //       new QLabel(KGlobal::locale()->formatDate(QDate::currentDate()),this);
    //   mDateLabel->setMargin(2);
    //   mDateLabel->setAlignment(AlignCenter);
    setFont( KOPrefs::instance()->mWhatsNextFont );
    mView = new WhatsNextTextBrowser(this);
    connect(mView,SIGNAL(showIncidence(const QString &)),SLOT(showIncidence(const QString &)));
 
    mEventViewer = 0;

    QBoxLayout *topLayout = new QVBoxLayout(this);
    //  topLayout->addWidget(mDateLabel);
    topLayout->addWidget(mView);
}

KOWhatsNextView::~KOWhatsNextView()
{
}

int KOWhatsNextView::maxDatesHint()
{
    return 0;
}

int KOWhatsNextView::currentDateCount()
{
    return 0;
}

QPtrList<Incidence> KOWhatsNextView::selectedIncidences()
{
    QPtrList<Incidence> eventList;

    return eventList;
}


void KOWhatsNextView::printPreview(CalPrinter *calPrinter, const QDate &fd,
                                   const QDate &td)
{
#ifndef KORG_NOPRINTER
    calPrinter->preview(CalPrinter::Day, fd, td);
#endif
}
void KOWhatsNextView::updateConfig()
{
    setFont( KOPrefs::instance()->mWhatsNextFont );
    updateView();

}
void KOWhatsNextView::updateView()
{

    //  mDateLabel->setText(KGlobal::locale()->formatDate(QDate::currentDate()));
    KIconLoader kil("korganizer");
    QString ipath;// = new QString();
    //  kil.loadIcon("korganizer",KIcon::NoGroup,32,KIcon::DefaultState,&ipath);
    //<big><big><strong>" + date + "</strong></big></big>\n";
    mText = "<table width=\"100%\">\n";
    //mText += "<tr bgcolor=\"#3679AD\"><td><h2>"; 
#ifdef DESKTOP_VERSION
    mText += "<tr bgcolor=\"#5699CD\"><td align=\"center\"><h1>";
#else
    mText += "<tr bgcolor=\"#5699CD\"><td align=\"center\"><h2>";
#endif
    //  mText += "<img src=\"";
    //   mText += ipath;
    //   mText += "\">";
    mEventDate = QDate::currentDate();
#ifdef DESKTOP_VERSION
    mText += "<font color=\"#FFFFFF\"> <em>" +  KGlobal::locale()->formatDate( mEventDate , false )+"</em></font></h1>";
#else
    mText += "<font color=\"#FFFFFF\"> <em>" +  KGlobal::locale()->formatDate( mEventDate , false )+"</em></font></h2>";
#endif
    mText += "</td></tr>\n<tr  bgcolor=\"#EAF8FA\"><td>";
    int iii;
    mTodos.clear();
    QPtrList<Event> events;  
    QPtrList<Todo> todos = calendar()->todos(); 
    Todo * todo;
    //mText += "<h2>" + i18n("Events: ") + "</h2>\n";
    int daysToShow = KOPrefs::instance()->mWhatsNextDays ;
    bool itemAdded = false;
    for ( iii = 0; iii <  daysToShow; ++iii ) {
        QString date;
        itemAdded = false;
        events = calendar()->events( mEventDate, true );
      
        if ( iii == 0 ) { // today !!!
            todo = todos.first();
            while(todo) {
                if ( !todo->isCompleted() &&todo->hasDueDate() && todo->dtDue().date() < mEventDate ) {
                    if ( ! itemAdded ) {
                        appendDay ( iii, mEventDate );
                        itemAdded = true;
                      
                    }
                    appendEvent(todo);
                }
                todo = todos.next();
            }
        }
      
      
        if (events.count() > 0) {
            //  mText += "<p></p>";
            // kil.loadIcon("month",KIcon::NoGroup,22,KIcon::DefaultState,&ipath);
            // mText += "<h2>";
            //mText += "   <img src=\"";
            //mText += ipath;
            //mText += "\">"; 
            if ( ! itemAdded ) {
                appendDay ( iii, mEventDate );
                itemAdded = true;
              
            }
            Event *ev = events.first();
            while(ev) {
                //qDebug("+++++event append %s", ev->summary().latin1());
                if ( true /*!ev->recurrence()->doesRecur() || ev->recursOn( mEventDate)*/) {
                    appendEvent(ev, false , iii!= 0 );
                }
                ev = events.next();
            }
         
            //mText += "</table>\n";
        } 
      
        todo = todos.first();
        while(todo) {
            if ( !todo->isCompleted() &&todo->hasDueDate() && todo->dtDue().date() == mEventDate ) {
                if ( ! itemAdded ) {
                    appendDay ( iii, mEventDate );
                    itemAdded = true;
                }
                appendEvent(todo);
            }
            todo = todos.next();
        }
        if ( !itemAdded && iii == 0 ) {
            // appendDay ( iii, mEventDate );
            //mText += "<table>";
            // mText += "<b><font color=\"#000080\"><em>"+i18n("No event, nothing to do.") +"</em></font></b>\n";
            mText += "<h3 align=\"center\"><font color=\"#008000\"><em>"+i18n("No event, nothing to do. ") +"</em></font></h3>\n";
            //mText +="</table>";
        }
        if ( itemAdded )
            mText += "</table>\n";
        mEventDate = mEventDate.addDays( 1 );
    }
  
    int topmostPrios =  KOPrefs::instance()->mWhatsNextPrios;
    if (todos.count() > 0 && topmostPrios > 0 ) {
        //   kil.loadIcon("todo",KIcon::NoGroup,22,KIcon::DefaultState,&ipath);
        // mText += "<h2>";
        //<img src=\"";
        //     mText += ipath;
        //     mText += "\">";
        // mText += i18n("Overdue To-Do:") + "</h2>\n";
  
        //mText += "<ul>\n";
        bool gotone = false;
        int priority = 1; 
        int priosFound = 0;
#ifdef DESKTOP_VERSION
        mText +="<p></p>";
#endif

        mText +="<big><big><strong><em><font color=\"#000080\">" + i18n("Incomplete Todo:") + "</font></em></strong></big></big>\n";
        mText += "<ul>\n";
        while (!gotone && priority<6) {
            todo = todos.first();
            while(todo) {
                if (!todo->isCompleted() && (todo->priority() == priority) ) {
                    if ( appendTodo(todo) )
                        gotone = true;
                }
                todo = todos.next();
            }
            if ( gotone ) {
                gotone = false;
                ++priosFound;
                if ( priosFound == topmostPrios )
                    break;
            }
            priority++;
            // kdDebug() << "adding the todos..." << endl;
        }
        mText += "</ul>\n";
    }

    int replys = 0;
    events = calendar()->events(QDate::currentDate(), QDate(2975,12,6));
    if (events.count() > 0) {
        Event *ev = events.first();
        while(ev) {
            Attendee *me = ev->attendeeByMails(KOPrefs::instance()->mAdditionalMails,KOPrefs::instance()->email());
            if (me!=0) {
                if (me->status()==Attendee::NeedsAction && me->RSVP()) {
                    if (replys == 0) {
                        mText += "<p></p>";
                        //    kil.loadIcon("reply",KIcon::NoGroup,22,KIcon::DefaultState,&ipath);
                        mText += "<h2>";
                        //<img src=\"";
                        //             mText += ipath;
                        //             mText += "\">";    
                        mText += i18n("Events and To-Dos that need a reply:") + "</h2>\n";
                        mText += "<table>\n";
                    }
                    replys++;
                    appendEvent(ev,true);
                }
            }
            ev = events.next();
        }
    }
    todos = calendar()->todos();
    if (todos.count() > 0) {
        Todo *to = todos.first();
        while(to) {
            Attendee *me = to->attendeeByMails(KOPrefs::instance()->mAdditionalMails,KOPrefs::instance()->email());
            if (me!=0) {
                if (me->status()==Attendee::NeedsAction && me->RSVP()) {
                    if (replys == 0) {
                        mText += "<p></p>";
                        //     kil.loadIcon("reply",KIcon::NoGroup,22,KIcon::DefaultState,&ipath);
                        mText += "<h2>";
                        //<img src=\"";
                        //             mText += ipath;
                        //             mText += "\">";    
                        mText += i18n("Events and To-Dos that need a reply:") + "</h2>\n";
                        mText += "<table>\n";
                    }
                    replys++;
                    appendEvent(to);
                }
            }
            kdDebug () << "check for todo-replys..." << endl;
            to = todos.next();
        }
    }
    if (replys > 0 ) mText += "</table>\n";


    mText += "</td></tr>\n</table>\n";

    kdDebug() << "KOWhatsNextView::updateView: text: " << mText << endl;
    mView->setText(mText);
    mView->setFocus();

    //  QPixmap bPix = SmallIcon( "back" );
    //   qDebug("xxxxxxxxxxxxxxxxxxxxx ");
    //   QWidget* test = new QWidget();
    //  test->setBackgroundMode(FixedPixmap  );
    //  test->setBackgroundPixmap ( bPix );
    //  test->resize( 300, 400 );
    //  test->show();
    //   mView->setBackgroundMode(FixedPixmap  );
    //   mView->setBackgroundPixmap ( bPix );
}

void  KOWhatsNextView::appendDay( int i, QDate eventDate )
{
    QString date;
    QString day = KGlobal::locale()->formatDate( eventDate , KOPrefs::instance()->mShortDateInViewer); 
    if ( ! KOPrefs::instance()->mShortDateInViewer && QApplication::desktop()->width() < 320 ) {
        if ( i == 0 ) {
            mText += "<table>\n";
            return;//date = "<em><font color=\"#008000\"><em>" +  day+"</font></em>";
        }
        else if ( i == 1 )
            date = "<em><font color=\"#000080\">" + day + "</font></em>" ;
        else date = "<em><font color=\"#000080\">" + day + "</font></em>";
        //mText += "<h2>" + date + "</h2>\n";
        mText += "<big><big><strong>" + date + "</strong></big></big>\n";
        mText += "<table>\n";



    } else { 
        if ( i == 0 ) {
            mText += "<table>\n";
            return;// date = "<font color=\"#008000\"><em>" +i18n("Today: ") +"</em>" + day+"</font>";
        }

#ifdef DESKTOP_VERSION
        else if ( i == 1 ) {
            date = "<h2><em><font color=\"#000080\">" + i18n("Tomorrow: ") + day +"</font></em></h2>" ;
        }
        else date = "<h2><em><font color=\"#000080\">" + i18n("In %1 days: ").arg( i ) +day + "</font></em></h2>";
#else
        else if ( i == 1 ) {
            date = "<em><font color=\"#000080\">" + i18n("Tomorrow: ") + day +"</font></em>" ;
        }
        else date = "<em><font color=\"#000080\">" + i18n("In %1 days: ").arg( i ) +day + "</font></em>";

#endif
        //mText += "<h2>" + date + "</h2>\n";
        mText += "<big><big><strong>" + date + "</strong></big></big>\n";
        mText += "<table>\n";
    }
}


void KOWhatsNextView::showDates(const QDate &, const QDate &)
{
    updateView();
}

void KOWhatsNextView::showEvents(QPtrList<Event>)
{
}

void KOWhatsNextView::changeEventDisplay(Event *, int action)
{
    switch(action) {
    case KOGlobals::EVENTADDED:
        updateView();
        break;
    case KOGlobals::EVENTEDITED:
        updateView();
        break;
    case KOGlobals::EVENTDELETED:
        updateView();
        break;
    default:
        updateView();
        kdDebug() << "KOWhatsNextView::changeEventDisplay(): Illegal action " << action << endl;
    }
}

void KOWhatsNextView::appendEvent(Incidence *ev, bool reply, bool notRed )
{
    if ( !KOPrefs::instance()->mShowSyncEvents && ev->uid().left(21) == QString("last-syncEvent-device") )
    return;
    QDateTime cdt =  QDateTime::currentDateTime();
    mText += "<tr><td><b>";
    if (ev->type()=="Event") {

        if (!ev->doesFloat()) {
            Event *event = static_cast<Event *>(ev);
            QDateTime st,end;
            if ( event->recurrence()->doesRecur() ) {
                QDate  recDate= mEventDate;
                int days =  event->dtStart().date().daysTo (event->dtEnd().date()  );
                while ( ! event->recursOn(  recDate ) ) {
                    recDate = recDate.addDays( -1 );

                }
                st =  QDateTime ( recDate,  event->dtStart().time() );
                end = QDateTime ( recDate.addDays( days ),  event->dtEnd().time() );
            }
            else {
                st = event->dtStart();
                end = event->dtEnd();
            }
      
            if (reply) mText += "on " + event->dtStartDateStr() + ": ";
            QString dateText;
            // qDebug("%s %s %s %s ", mEventDate.toString().latin1(),event->summary().latin1(), st .toString().latin1(),end.toString().latin1() );
            if ( st.date() < mEventDate )
                dateText = "++:++-";
            else
                dateText =  event->dtStartTimeStr() + "-";
            if ( end.date() > mEventDate ) 
                dateText += "++:++";
            else
                dateText += event->dtEndTimeStr();
            if ( notRed ) 
                mText += dateText;
            else {
                if ( end < cdt  )
                    mText += "<font color=\"#F00000\">" + dateText + "</font>";
                else if ( st < cdt )
                    mText += "<font color=\"#008000\">" + dateText + "</font>";
                else
                    mText += dateText;
            }
    
        } else {
            mText += i18n("Allday:");

        }
    } else {
        mTodos.append( ev );
        mText += i18n("ToDo:"); 
        if ( ((Todo*)ev)->dtDue().date() < QDate::currentDate() ) {
            // mText +="<font color=\"#F00000\">" + i18n("O-due!") + "</font>";
            QString dfs = KGlobal::locale()->dateFormatShort();
            KGlobal::locale()->setDateFormatShort("%d.%b");
             mText +="<font color=\"#F00000\">" + KGlobal::locale()->formatDate(((Todo*)ev)->dtDue().date(), true, KLocale::Userdefined) + "</font>";
            KGlobal::locale()->setDateFormatShort(dfs);
        } else {
            if (!ev->doesFloat() )
                if( ( (Todo*)ev)->dtDue()  < cdt  ) {
                    mText +="<font color=\"#F00000\">" + ((Todo*)ev)->dtDueTimeStr() + "</font>";


                } else 
                    mText +=((Todo*)ev)->dtDueTimeStr();
            mTodos.append( ev );
        }
    }
    mText += "</b></td><td>";
    bool needClose = false;
    if ( ev->cancelled() ) {
        mText += "<font color=\"#F00000\">[c";
        needClose =true;

    }
    if ( ev->isAlarmEnabled() ) { 
        if ( !needClose)
            mText +="[";
        mText += "a";
        needClose =true;

    }
    if ( ev->description().length() > 0 ) {
        if ( !needClose)
            mText +="[";
        mText += "i";
        needClose =true;
    }
    if ( ev->recurrence()->doesRecur() ) {
        if ( !needClose)
            mText +="[";
        mText += "r";
        needClose =true;
    }
    if ( needClose ) {
        mText += "] ";
    }
    if ( ev->cancelled() ) 
        mText += "</font>";
    mText += "<a ";
    if (ev->type()=="Event") mText += "href=\"event:";
    if (ev->type()=="Todo") mText += "href=\"todo:";
    mText += ev->uid() + "\">";
    if ( ev->summary().length() > 0 )
        mText += ev->summary();
    else
        mText += i18n("-no summary-"); 
    mText += "</a>";
    if ( KOPrefs::instance()->mWNViewShowLocation )
        if ( !ev->location().isEmpty() )
            mText += " ("+ev->location() +")";
    if ( ev->relatedTo() && KOPrefs::instance()->mWNViewShowsParents)
            mText += " ["+ev->relatedTo()->summary() +"]";
    mText += "</td></tr>\n";
}

bool KOWhatsNextView::appendTodo(Incidence *ev, QString ind , bool isSub )
{
    if ( mTodos.find( ev ) != mTodos.end() ) return false;

    mTodos.append( ev );
    if ( !isSub )
        mText += "<p>";
    else
        mText += "<li>";
    mText += "[" +QString::number(ev->priority()) + "/" + QString::number(((Todo*)ev)->percentComplete())+"%] ";


    mText += ind;
    bool needClose = false;
    if ( ev->cancelled() ) {
        mText += "<font color=\"#F00000\">[c";
        needClose =true;

    }
    if ( ev->isAlarmEnabled() ) { 
        if ( !needClose)
            mText +="[";
        mText += "a";
        needClose =true;

    }
   
    if ( ev->description().length() > 0 ) {
        if ( !needClose)
            mText +="[";
        mText += "i";
        needClose =true;
    }
    //  if ( ev->recurrence()->doesRecur() ) {
    //       if ( !needClose)
    //           mText +="(";
    //       mText += "r";
    //       needClose =true;
    //   }
    if ( needClose )
        mText += "] ";
    if ( ev->cancelled() ) 
        mText += "</font>";
    mText += "<a href=\"todo:" + ev->uid() + "\">";
    mText += ev->summary();
    mText += "</a>"; 
    if ( ((Todo*)ev)->hasDueDate () ) {
        QString year = "";
        int ye = ((Todo*)ev)->dtDue().date().year();
        if ( QDateTime::currentDateTime().date().year() != ye )
            year = QString::number( ye );
        QString dfs = KGlobal::locale()->dateFormatShort();
        KGlobal::locale()->setDateFormatShort("%d.%b");
        mText +="<font color=\"#00A000\"> [" + KGlobal::locale()->formatDate(((Todo*)ev)->dtDue().date(), true, KLocale::Userdefined) + "."+ year +"]</font>";
        KGlobal::locale()->setDateFormatShort(dfs);
    }
    if ( KOPrefs::instance()->mWNViewShowLocation )
        if ( !ev->location().isEmpty() )
            mText += " ("+ev->location() +")";
    if ( !isSub ) {
        if ( ((Todo*)ev)->relatedTo()&& KOPrefs::instance()->mWNViewShowsParents)
            mText += " ["+ev->relatedTo()->summary() +"]";
        mText += "</p>\n";
    }
    else {
        ind += "-";
        mText += "</li>\n";
    }
    QPtrList<Incidence> Relations = ev->relations();
    Incidence *to;
    for (to=Relations.first();to;to=Relations.next()) {
        if (!((Todo*)to)->isCompleted())
            appendTodo( to, ind , true );
    } 
    
    return true;
}

/*
  void KOWhatsNextView::createEventViewer()
  {
  if (!mEventViewer) {
      
  mEventViewer = new KOEventViewerDialog(this);
  }
  }
*/
void KOWhatsNextView::setEventViewer(KOEventViewerDialog* v )
{
    if ( mEventViewer )
        delete mEventViewer;
    mEventViewer = v;
}

// TODO: Create this function in CalendarView and remove it from here
void KOWhatsNextView::showIncidence(const QString &uid)
{
    if ( !mEventViewer  ) {
        qDebug("KOWhatsNextView::showIncidence::sorry, no event viewer set ");
        return;
    }
    //kdDebug() << "KOWhatsNextView::showIncidence(): " << uid << endl;
    //qDebug("KOWhatsNextView::showIncidence %s ", uid.latin1());
    if (uid.startsWith("event:")) {
#ifdef DESKTOP_VERSION
        Event *event = calendar()->event(uid.mid(8));
#else
        Event *event = calendar()->event(uid.mid(6));
#endif
        //qDebug("event %d uid %s ", event, uid.mid(6).latin1());
        if (!event) return;
        //createEventViewer();
        mEventViewer->setEvent(event);
    } else if (uid.startsWith("todo:")) {
#ifdef DESKTOP_VERSION
        Todo *todo = calendar()->todo(uid.mid(7));
#else
        Todo *todo = calendar()->todo(uid.mid(5));
#endif
        if (!todo) return;
        //createEventViewer();
        mEventViewer->setTodo(todo);
    } else {
        return;

  }
  mEventViewer->showMe();
  mEventViewer->raise();
}
