/*
    This file is part of KOrganizer.

    Copyright (c) 2003 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/

#include <qstring.h>
#include <qtooltip.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qframe.h>
#include <qlabel.h>
#include <qapplication.h>

#include <kdebug.h>
#include <klocale.h>
#include <kglobal.h>
#include <kiconloader.h>
#include "libkdepim/kdatepicker.h"
#include <knotifyclient.h>
#include "kdatetbl.h"

#include "koglobals.h"
#include "koprefs.h"
#ifndef KORG_NOPLUGINS
#include "kocore.h"
#endif

#include <kcalendarsystem.h>

#include "navigatorbar.h"

NavigatorBar::NavigatorBar( const QDate & date, QWidget *parent, const char *name )
  : QWidget( parent, name )
{
  QBoxLayout *topLayout = new QHBoxLayout( this );

  // Set up the control buttons and date label
  mCtrlFrame = new QFrame( this );
  mCtrlFrame->setFrameStyle(QFrame::Panel|QFrame::Raised);
  mCtrlFrame->setLineWidth(1);

  topLayout->addWidget( mCtrlFrame );

  QFont tfont = font();
  if ( QApplication::desktop()->width() >= 480 ) 
      tfont.setPointSize(tfont.pointSize()+2);
  tfont.setBold(true);

  bool isRTL = KOGlobals::self()->reverseLayout();
#ifndef DESKTOP_VERSION
  bool isDesktop = false;
#else
  bool isDesktop = true;
#endif
  if ( QString ( name ) == QString("useBigPixmaps") && QApplication::desktop()->width() > 320 )
      isDesktop = true;
  // Create backward navigation buttons
  mPrevYear = new QPushButton( mCtrlFrame );
  mPrevYear->setPixmap( SmallIcon( isDesktop ? "2leftarrowB" : "2leftarrow" ) );
  QToolTip::add( mPrevYear, i18n("Previous Year") );

  mPrevMonth = new QPushButton( mCtrlFrame );
  mPrevMonth->setPixmap( SmallIcon( isDesktop ? "1leftarrowB" : "1leftarrow") );
  QToolTip::add( mPrevMonth, i18n("Previous Month") );

  // Create forward navigation buttons
  mNextMonth = new QPushButton( mCtrlFrame );
  mNextMonth->setPixmap( SmallIcon( isDesktop ? "1rightarrowB" : "1rightarrow") );
  QToolTip::add( mNextMonth, i18n("Next Month") );

  mNextYear = new QPushButton( mCtrlFrame );
  mNextYear->setPixmap( SmallIcon( isDesktop ? "2rightarrowB": "2rightarrow") );
  QToolTip::add( mNextYear, i18n("Next Year") );
  mSelectMonth = new QPushButton( mCtrlFrame );
  // Create month name label
  //selectMonth->setFont( tfont );
  // selectMonth->setAlignment( AlignCenter );
  //mDateLabel = new QLabel( selectMonth );
  //mDateLabel->setFont( tfont );
  //mDateLabel->setAlignment( AlignCenter );
  if ( QString ( name ) == QString("useBigPixmaps") ) {
      mNextMonth->setFlat( true);
      mNextYear->setFlat( true);
      mSelectMonth->setFlat( true);
      mPrevYear->setFlat( true);
      mPrevMonth->setFlat( true);
  }
  mSelectMonth->setFont( tfont );
  // Set minimum width to width of widest month name label
  int i;
  int maxwidth = 0;
  QFontMetrics fm ( mSelectMonth->font() );
  int width = fm.width("September '00" );
//   for( i = 1; i <= KOGlobals::self()->calendarSystem()->monthsInYear(date);
//       ++i ) {
//       //int width = fm.width( KOGlobals::self()->calendarSystem()->monthName(i,
//       //   KOGlobals::self()->calendarSystem()->year(date) ) + " 2000" );
//       int width = fm.width("September 2000" );
//     if ( width > maxwidth ) maxwidth = width;
//   }
  maxwidth = width+2;
  int size = fm.height()+2;
  if ( QApplication::desktop()->width() >= 480 ) { 
      size += 6;
      maxwidth+= 6;
  }
  mSelectMonth->setFixedWidth( maxwidth );
  mSelectMonth->setFixedHeight( size );
   mPrevYear->setFixedHeight(  size );
  mPrevMonth->setFixedHeight( size );
   mNextMonth->setFixedHeight( size );
  mNextYear->setFixedHeight ( size );
  // set up control frame layout
  QBoxLayout *ctrlLayout = new QHBoxLayout( mCtrlFrame, 1 );
  ctrlLayout->addWidget( mPrevYear, 3 );
  ctrlLayout->addWidget( mPrevMonth, 3 );
  //ctrlLayout->addStretch( 1 );
  // ctrlLayout->addSpacing( 1 );
  // ctrlLayout->addWidget( mDateLabel );
  ctrlLayout->addWidget( mSelectMonth );
  //  ctrlLayout->addSpacing( 1 );
  // ctrlLayout->addStretch( 1 );
  ctrlLayout->addWidget( mNextMonth, 3 );
  ctrlLayout->addWidget( mNextYear, 3 );

  connect( mPrevYear, SIGNAL( clicked() ), SIGNAL( goPrevYear() ) );
  connect( mPrevMonth, SIGNAL( clicked() ), SIGNAL( goPrevMonth() ) );
  connect( mNextMonth, SIGNAL( clicked() ), SIGNAL( goNextMonth() ) );
  connect( mNextYear, SIGNAL( clicked() ), SIGNAL( goNextYear() ) );
  connect( mSelectMonth, SIGNAL( clicked() ),SLOT( selectMonth() ) );
  mPrevYear->setFocusPolicy(NoFocus);
  mPrevMonth->setFocusPolicy(NoFocus);
  mNextMonth->setFocusPolicy(NoFocus);
  mNextYear->setFocusPolicy(NoFocus);
  mSelectMonth->setFocusPolicy(NoFocus);
}

NavigatorBar::~NavigatorBar()
{
}

void NavigatorBar::selectMonth()
{

    int month;
  KPopupFrame* popup = new KPopupFrame(this);
  int size = 12;
  if ( QApplication::desktop()->width() >= 480 ) 
      size = 18;
  KDateInternalMonthPicker* picker = new KDateInternalMonthPicker(size, popup);
  // -----
  picker->resize(picker->sizeHint());
  popup->setMainWidget(picker);
  picker->setFocus();
  connect(picker, SIGNAL(closeMe(int)), popup, SLOT(close(int)));
  if(popup->exec(mSelectMonth->mapToGlobal(QPoint(0, mSelectMonth->height()))))
    {
        month = picker->getResult();
        emit monthSelected ( month );
    } else {
      KNotifyClient::beep();
    }
  delete popup;
}
void NavigatorBar::selectDates( const KCal::DateList &dateList )
{
  if (dateList.count() > 0) {
    QDate date = dateList.first();

    const KCalendarSystem *calSys = KOGlobals::self()->calendarSystem();

    // compute the label at the top of the navigator
    QString dtstr = i18n(calSys->monthName( date )) + " '" +
                    QString::number( calSys->year( date ) ).right(2);

    mSelectMonth->setText( dtstr );
  }
}

