/*
    This file is part of KdePim/Pi.
    Copyright (c) 2004 Ulf Schenk

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/

/*
Enhanced Version of the file for platform independent KDE tools.
Copyright (c) 2004 Ulf Schenk

$Id: kdepimconfigwidget.cpp,v 1.4 2004/08/10 22:39:35 ulf69 Exp $
*/

#include <qlayout.h>
#include <qtabwidget.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qfile.h>

#include <kdialog.h>
#include <klocale.h>

#include <stdlib.h>

/*US
#include <qcheckbox.h>
#include <qframe.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qfile.h>

#include <kconfig.h>
#include <kdebug.h>
#include <kdialog.h>
#include <klistview.h>
#include <klocale.h>
#include <kglobal.h>
#include <kmessagebox.h>
#include <kstandarddirs.h>

#ifndef KAB_EMBEDDED
#include <ktrader.h>
#else // KAB_EMBEDDED
#include <mergewidget.h>
#include <distributionlistwidget.h>
#endif // KAB_EMBEDDED

#include "addresseewidget.h"
#include "extensionconfigdialog.h"
#include "extensionwidget.h"
*/

#include "kpimglobalprefs.h"

#include "kdepimconfigwidget.h"


KDEPIMConfigWidget::KDEPIMConfigWidget( QWidget *parent, const char *name )
  : QWidget( parent, name )
{
  mExternalAppsMap.insert(ExternalAppHandler::EMAIL, i18n("Email"));
  mExternalAppsMap.insert(ExternalAppHandler::PHONE, i18n("Phone"));
  mExternalAppsMap.insert(ExternalAppHandler::SMS, i18n("SMS"));
  mExternalAppsMap.insert(ExternalAppHandler::FAX, i18n("Fax"));
  mExternalAppsMap.insert(ExternalAppHandler::PAGER, i18n("Pager"));


  QVBoxLayout *topLayout = new QVBoxLayout( this, 0,
                                            KDialog::spacingHint() );

  QTabWidget *tabWidget = new QTabWidget( this );
  topLayout->addWidget( tabWidget );



  // mailclient page
  QWidget *externalAppsPage = new QWidget( this );
  QVBoxLayout* layout = new QVBoxLayout( externalAppsPage, KDialog::marginHintSmall(),
                                            KDialog::spacingHintSmall() );

  mExternalApps = new QComboBox( externalAppsPage );

  QMap<ExternalAppHandler::Types, QString>::Iterator it;
  for( it = mExternalAppsMap.begin(); it != mExternalAppsMap.end(); ++it )
    mExternalApps->insertItem( it.data(), it.key() );

  layout->addWidget( mExternalApps );

  connect( mExternalApps, SIGNAL( activated( int ) ),
           this, SLOT (externalapp_changed( int ) ) );




  mExternalAppGroupBox = new QGroupBox( 0, Qt::Vertical, i18n( "Used Mail Client" ), externalAppsPage );
  QGridLayout *boxLayout = new QGridLayout( mExternalAppGroupBox->layout(), 4, 2,    -1, "gridlayout" );


  mClient = new QComboBox( mExternalAppGroupBox );
  boxLayout->addMultiCellWidget( mClient, 0, 0, 0, 1 );

  connect( mClient, SIGNAL( activated( int ) ),
           this, SLOT (client_changed( int ) ) );

  QLabel* lab = new QLabel( i18n("Channel:"), mExternalAppGroupBox);
  boxLayout->addWidget( lab, 1, 0 );
  mChannel = new QLineEdit(mExternalAppGroupBox);
  mChannel->setReadOnly(true);
  boxLayout->addMultiCellWidget( mChannel, 2 , 2, 0, 1 );

  lab = new QLabel( i18n("Message:"), mExternalAppGroupBox);
  boxLayout->addWidget( lab, 3, 0 );
  mMessage = new QLineEdit(mExternalAppGroupBox);
  mMessage->setReadOnly(true);
  boxLayout->addWidget( mMessage , 4, 0);

  lab = new QLabel( i18n("Parameters:"), mExternalAppGroupBox);
  boxLayout->addWidget( lab, 3, 1 );
  mParameters = new QLineEdit(mExternalAppGroupBox);
  mParameters->setReadOnly(true);
  boxLayout->addWidget( mParameters, 4, 1 );

  lab = new QLabel( i18n("HINT: Delimiter=; Name=%1,Email=%2"), mExternalAppGroupBox);
  boxLayout->addMultiCellWidget( lab, 5, 5, 0, 1 );

  lab = new QLabel( i18n("extra Message:"), mExternalAppGroupBox);
  boxLayout->addWidget( lab, 6, 0 );
  mMessage2 = new QLineEdit(mExternalAppGroupBox);
  mMessage2->setReadOnly(true);
  boxLayout->addWidget( mMessage2 , 7, 0);

  lab = new QLabel( i18n("extra Parameters:"), mExternalAppGroupBox);
  boxLayout->addWidget( lab, 6, 1 );
  mParameters2 = new QLineEdit(mExternalAppGroupBox);
  mParameters2->setReadOnly(true);
  boxLayout->addWidget( mParameters2, 7, 1 );

  lab = new QLabel( i18n("HINT: Emails=%1,Attachments=%2"), mExternalAppGroupBox);
  boxLayout->addMultiCellWidget( lab, 8, 8, 0, 1 );


  connect( mChannel, SIGNAL( textChanged ( const QString & )), this, SLOT( textChanged ( const QString & ))  );
  connect( mMessage, SIGNAL( textChanged ( const QString & )), this, SLOT( textChanged ( const QString & ))  );
  connect( mParameters, SIGNAL( textChanged ( const QString & )), this, SLOT( textChanged ( const QString & ))  );
  connect( mMessage2, SIGNAL( textChanged ( const QString & )), this, SLOT( textChanged ( const QString & ))  );
  connect( mParameters2, SIGNAL( textChanged ( const QString & )), this, SLOT( textChanged ( const QString & ))  );



  layout->addWidget( mExternalAppGroupBox );
  tabWidget->addTab( externalAppsPage, i18n( "External Apps." ) );

}

void KDEPIMConfigWidget::externalapp_changed( int newApp )
{
  // first store the current data
  saveEditFieldSettings();

  // set mCurrentApp
  mCurrentApp = (ExternalAppHandler::Types)newApp;

  // set mCurrentClient
  switch(mCurrentApp)
  {
    case(ExternalAppHandler::EMAIL):
      mCurrentClient = mEmailClient;
      break;
    case(ExternalAppHandler::PHONE):
      mCurrentClient = mPhoneClient;
      break;
    case(ExternalAppHandler::SMS):
      mCurrentClient = mSMSClient;
      break;
    case(ExternalAppHandler::FAX):
      mCurrentClient = mFaxClient;
      break;
    case(ExternalAppHandler::PAGER):
      mCurrentClient = mPagerClient;
      break;
    default:
      return;
  }

  // and at last update the widgets
  updateClientWidgets();
}



void KDEPIMConfigWidget::client_changed( int newClient )
{
  if (newClient == mCurrentClient)
    return;

  // first store the current data
  saveEditFieldSettings();


  //then reset the clientvariable
  mCurrentClient = newClient;

  // and at last update the widgets
  updateClientWidgets();

  modified();
}

void KDEPIMConfigWidget::saveEditFieldSettings()
{

  switch(mCurrentApp)
  {
    case(ExternalAppHandler::EMAIL):
      mEmailClient = mClient->currentItem();
      break;
    case(ExternalAppHandler::PHONE):
      mPhoneClient= mClient->currentItem();
      break;
    case(ExternalAppHandler::SMS):
      mSMSClient = mClient->currentItem();
      break;
    case(ExternalAppHandler::FAX):
      mFaxClient = mClient->currentItem();
      break;
    case(ExternalAppHandler::PAGER):
      mPagerClient = mClient->currentItem();
      break;
    default:
      return;
  }

  //store the current data back to the apropriate membervariables if we had set it to "other"
  if ((mCurrentApp == ExternalAppHandler::EMAIL) && (mCurrentClient == KPimGlobalPrefs::OTHER_EMC))
  {
    mEmailOtherChannel = mChannel->text();
    mEmailOtherMessage = mMessage->text();
    mEmailOtherMessageParameters = mParameters->text();
    mEmailOtherMessage2 = mMessage2->text();
    mEmailOtherMessageParameters2 = mParameters2->text();
  }
  else if ((mCurrentApp == ExternalAppHandler::PHONE) && (mCurrentClient == KPimGlobalPrefs::OTHER_PHC))
  {
    mPhoneOtherChannel = mChannel->text();
    mPhoneOtherMessage = mMessage->text();
    mPhoneOtherMessageParameters = mParameters->text();
  }
  else if ((mCurrentApp == ExternalAppHandler::SMS) && (mCurrentClient == KPimGlobalPrefs::OTHER_SMC))
  {
    mSMSOtherChannel = mChannel->text();
    mSMSOtherMessage = mMessage->text();
    mSMSOtherMessageParameters = mParameters->text();
  }
  else if ((mCurrentApp == ExternalAppHandler::FAX) && (mCurrentClient == KPimGlobalPrefs::OTHER_FAC))
  {
    mFaxOtherChannel = mChannel->text();
    mFaxOtherMessage = mMessage->text();
    mFaxOtherMessageParameters = mParameters->text();
  }
  else if ((mCurrentApp == ExternalAppHandler::PAGER) && (mCurrentClient == KPimGlobalPrefs::OTHER_PAC))
  {
    mPagerOtherChannel = mChannel->text();
    mPagerOtherMessage = mMessage->text();
    mPagerOtherMessageParameters = mParameters->text();
  }


}

void KDEPIMConfigWidget::updateClientWidgets()
{
  bool blocked = signalsBlocked();
  blockSignals( true );

  // at this point we assume, that mCurrentApp and mCurrentClient are set to the values that we want to display
  QMap<ExternalAppHandler::Types, QString>::Iterator it = mExternalAppsMap.find ( mCurrentApp );
  if (it == mExternalAppsMap.end())
    return;

  // update group box
  mExternalAppGroupBox->setTitle(i18n( "Used %1 Client" ).arg(it.data()));

  //update the entries in the client combobox
  mClient->clear();

  QList<DefaultAppItem> items = ExternalAppHandler::instance()->getAvailableDefaultItems(mCurrentApp);
  DefaultAppItem* dai;
  for ( dai=items.first(); dai != 0; dai=items.next() )
  {
    mClient->insertItem( i18n(dai->_label), dai->_id );

    if (dai->_id == mCurrentClient)
    {
      //restore the edit fields with the data of the local membervariables if we had set it to "other".
      //Otherwise take the default data from externalapphandler.
      mChannel->setText(dai->_channel);
      mMessage->setText(dai->_message);
      mParameters->setText(dai->_parameters);
      mMessage2->setText(dai->_message2);
      mParameters2->setText(dai->_parameters2);


      if ((mCurrentApp == ExternalAppHandler::EMAIL) && (mCurrentClient == KPimGlobalPrefs::OTHER_EMC))
      {
        mChannel->setText(mEmailOtherChannel);
        mMessage->setText(mEmailOtherMessage);
        mParameters->setText(mEmailOtherMessageParameters);
        mMessage2->setText(mEmailOtherMessage2);
        mParameters2->setText(mEmailOtherMessageParameters2);
      }
      else if ((mCurrentApp == ExternalAppHandler::PHONE) && (mCurrentClient == KPimGlobalPrefs::OTHER_PHC))
      {
        mChannel->setText(mPhoneOtherChannel);
        mMessage->setText(mPhoneOtherMessage);
        mParameters->setText(mPhoneOtherMessageParameters);
      }
      else if ((mCurrentApp == ExternalAppHandler::SMS) && (mCurrentClient == KPimGlobalPrefs::OTHER_SMC))
      {
        mChannel->setText(mSMSOtherChannel);
        mMessage->setText(mSMSOtherMessage);
        mParameters->setText(mSMSOtherMessageParameters);
      }
      else if ((mCurrentApp == ExternalAppHandler::FAX) && (mCurrentClient == KPimGlobalPrefs::OTHER_FAC))
      {
        mChannel->setText(mFaxOtherChannel);
        mMessage->setText(mFaxOtherMessage);
        mParameters->setText(mFaxOtherMessageParameters);
      }
      else if ((mCurrentApp == ExternalAppHandler::PAGER) && (mCurrentClient == KPimGlobalPrefs::OTHER_PAC))
      {
        mChannel->setText(mPagerOtherChannel);
        mMessage->setText(mPagerOtherMessage);
        mParameters->setText(mPagerOtherMessageParameters);
      }
    }

  }

  bool readonly;
  bool enabled;
  if ( ((mCurrentApp == ExternalAppHandler::EMAIL) && (mCurrentClient == KPimGlobalPrefs::OTHER_EMC))
     ||((mCurrentApp == ExternalAppHandler::PHONE) && (mCurrentClient == KPimGlobalPrefs::OTHER_PHC))
     ||((mCurrentApp == ExternalAppHandler::SMS) && (mCurrentClient == KPimGlobalPrefs::OTHER_SMC))
     ||((mCurrentApp == ExternalAppHandler::FAX) && (mCurrentClient == KPimGlobalPrefs::OTHER_FAC))
     ||((mCurrentApp == ExternalAppHandler::PAGER) && (mCurrentClient == KPimGlobalPrefs::OTHER_PAC)))
     {
       readonly = false;
	 }
	 else
	 {
       readonly = true;
	 }

  if ( ((mCurrentApp == ExternalAppHandler::EMAIL) && (mCurrentClient == KPimGlobalPrefs::NONE_EMC))
     ||((mCurrentApp == ExternalAppHandler::PHONE) && (mCurrentClient == KPimGlobalPrefs::NONE_PHC))
     ||((mCurrentApp == ExternalAppHandler::SMS) && (mCurrentClient == KPimGlobalPrefs::NONE_SMC))
     ||((mCurrentApp == ExternalAppHandler::FAX) && (mCurrentClient == KPimGlobalPrefs::NONE_FAC))
     ||((mCurrentApp == ExternalAppHandler::PAGER) && (mCurrentClient == KPimGlobalPrefs::NONE_PAC)))
     {
       enabled = false;
	 }
	 else
	 {
       enabled = true;
	 }


  mChannel->setReadOnly(readonly);
  mMessage->setReadOnly(readonly);
  mParameters->setReadOnly(readonly);
  mMessage2->setReadOnly(readonly);
  mParameters2->setReadOnly(readonly);

  mChannel->setEnabled(enabled);
  mMessage->setEnabled(enabled);
  mParameters->setEnabled(enabled);
  mMessage2->setEnabled(enabled);
  mParameters2->setEnabled(enabled);



  mClient->setCurrentItem(mCurrentClient);


  // enable/disable the extra message/parameter field
  if (mCurrentApp == ExternalAppHandler::EMAIL)
  {
  }
  else
  {
    mMessage2->setText( "" );
    mParameters2->setText( "" );
  }

  if (enabled == true) {
    mMessage2->setEnabled(mCurrentApp == ExternalAppHandler::EMAIL);
    mParameters2->setEnabled(mCurrentApp == ExternalAppHandler::EMAIL);
  }


  blockSignals( blocked );

}




void KDEPIMConfigWidget::restoreSettings(KPimGlobalPrefs* prefs)
{
  bool blocked = signalsBlocked();
  blockSignals( true );

  mEmailClient = prefs->mEmailClient;
  mEmailOtherChannel = prefs->mEmailOtherChannel;
  mEmailOtherMessage = prefs->mEmailOtherMessage;
  mEmailOtherMessageParameters = prefs->mEmailOtherMessageParameters;
  mEmailOtherMessage2 = prefs->mEmailOtherMessage2;
  mEmailOtherMessageParameters2 = prefs->mEmailOtherMessageParameters2;

  mPhoneClient = prefs->mPhoneClient;
  mPhoneOtherChannel = prefs->mPhoneOtherChannel;
  mPhoneOtherMessage = prefs->mPhoneOtherMessage;
  mPhoneOtherMessageParameters = prefs->mPhoneOtherMessageParameters;

  mFaxClient = prefs->mFaxClient;
  mFaxOtherChannel = prefs->mFaxOtherChannel;
  mFaxOtherMessage = prefs->mFaxOtherMessage;
  mFaxOtherMessageParameters = prefs->mFaxOtherMessageParameters;

  mSMSClient = prefs->mSMSClient;
  mSMSOtherChannel = prefs->mSMSOtherChannel;
  mSMSOtherMessage = prefs->mSMSOtherMessage;
  mSMSOtherMessageParameters = prefs->mSMSOtherMessageParameters;

  mPagerClient = prefs->mPagerClient;
  mPagerOtherChannel = prefs->mPagerOtherChannel;
  mPagerOtherMessage = prefs->mPagerOtherMessage;
  mPagerOtherMessageParameters = prefs->mPagerOtherMessageParameters;

  mCurrentApp = ExternalAppHandler::EMAIL;
  mCurrentClient = mEmailClient;

  updateClientWidgets();

  blockSignals( blocked );

  emit changed( false );

}

void KDEPIMConfigWidget::saveSettings(KPimGlobalPrefs* prefs)
{
  saveEditFieldSettings();

  prefs->mEmailClient = mEmailClient;
  prefs->mEmailOtherChannel = mEmailOtherChannel;
  prefs->mEmailOtherMessage = mEmailOtherMessage;
  prefs->mEmailOtherMessageParameters = mEmailOtherMessageParameters;
  prefs->mEmailOtherMessage2 = mEmailOtherMessage2;
  prefs->mEmailOtherMessageParameters2 = mEmailOtherMessageParameters2;

  prefs->mPhoneClient = mPhoneClient;
  prefs->mPhoneOtherChannel = mPhoneOtherChannel;
  prefs->mPhoneOtherMessage = mPhoneOtherMessage;
  prefs->mPhoneOtherMessageParameters = mPhoneOtherMessageParameters;

  prefs->mFaxClient = mFaxClient;
  prefs->mFaxOtherChannel = mFaxOtherChannel;
  prefs->mFaxOtherMessage = mFaxOtherMessage;
  prefs->mFaxOtherMessageParameters = mFaxOtherMessageParameters;

  prefs->mSMSClient = mSMSClient;
  prefs->mSMSOtherChannel = mSMSOtherChannel;
  prefs->mSMSOtherMessage = mSMSOtherMessage;
  prefs->mSMSOtherMessageParameters = mSMSOtherMessageParameters;

  prefs->mPagerClient = mPagerClient;
  prefs->mPagerOtherChannel = mPagerOtherChannel;
  prefs->mPagerOtherMessage = mPagerOtherMessage;
  prefs->mPagerOtherMessageParameters = mPagerOtherMessageParameters;

  prefs->writeConfig();

  //release the cache that other views can access the changed values instantanious
  ExternalAppHandler::instance()->loadConfig();

  emit changed( false );
}

void KDEPIMConfigWidget::defaults(KPimGlobalPrefs* prefs)
{

  DefaultAppItem* dai = ExternalAppHandler::instance()->getDefaultItem(ExternalAppHandler::EMAIL, KPimGlobalPrefs::NONE_EMC);

  mEmailClient = dai->_id;
  mEmailOtherChannel = dai->_channel;
  mEmailOtherMessage = dai->_message;
  mEmailOtherMessageParameters = dai->_parameters;
  mEmailOtherMessage2 = dai->_message2;
  mEmailOtherMessageParameters2 = dai->_parameters2;


  dai = ExternalAppHandler::instance()->getDefaultItem(ExternalAppHandler::PHONE, KPimGlobalPrefs::NONE_PHC);

  mPhoneClient = dai->_id;
  mPhoneOtherChannel = dai->_channel;
  mPhoneOtherMessage = dai->_message;
  mPhoneOtherMessageParameters = dai->_parameters;

  dai = ExternalAppHandler::instance()->getDefaultItem(ExternalAppHandler::FAX, KPimGlobalPrefs::NONE_FAC);

  mFaxClient = dai->_id;
  mFaxOtherChannel = dai->_channel;
  mFaxOtherMessage = dai->_message;
  mFaxOtherMessageParameters = dai->_parameters;

  dai = ExternalAppHandler::instance()->getDefaultItem(ExternalAppHandler::SMS, KPimGlobalPrefs::NONE_SMC);

  mSMSClient = dai->_id;
  mSMSOtherChannel = dai->_channel;
  mSMSOtherMessage = dai->_message;
  mSMSOtherMessageParameters = dai->_parameters;

  dai = ExternalAppHandler::instance()->getDefaultItem(ExternalAppHandler::PAGER, KPimGlobalPrefs::NONE_PAC);

  mPagerClient = dai->_id;
  mPagerOtherChannel = dai->_channel;
  mPagerOtherMessage = dai->_message;
  mPagerOtherMessageParameters = dai->_parameters;


  emit changed( true );
}

void KDEPIMConfigWidget::modified()
{
  emit changed( true );
}

void KDEPIMConfigWidget::textChanged( const QString& text )
{
  emit changed( true );
}
