/*
    This file is part of libkresources.

    Copyright (c) 2002 Tobias Koenig <tokoe@kde.org>
    Copyright (c) 2002 Jan-Pascal van Best <janpascal@vanbest.org>
    Copyright (c) 2003 Cornelius Schumacher <schumacher@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include <klocale.h>
#include <kglobal.h>
#include <kmessagebox.h>

#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qvbox.h>

#include <qcheckbox.h>
#include <qscrollview.h>

#include <kbuttonbox.h>
#include <kdialog.h>
#include <klineedit.h>

#include "factory.h"
#include "configwidget.h"
#include "configdialog.h"
#include "syncwidget.h"

using namespace KRES;

ConfigDialog::ConfigDialog( QWidget *parent, const QString& resourceFamily,
    Resource* resource, const char *name )
  : KDialogBase( parent, name, true, resource->isSyncable()?i18n( "Sync Profile Configuration" ):i18n( "Resource Configuration" ),
    Ok|Cancel, Ok, true )/*, mConfig( config )*/, mSyncWidget_Settings(0), mSyncWidget_Conflicts(0),mSyncWidget_Remote(0), mResource( resource ), mPersistentReadOnly(false)
{

  Factory *factory = Factory::self( resourceFamily );

//US  resize( 250, 240 );
  resize( KMIN(KGlobal::getDesktopWidth(), 250), KMIN(KGlobal::getDesktopHeight(), 240));

  QFrame *main;

  if (!mResource->isSyncable())
    main = plainPage();
  else
    main = addPage("Profile");

  QVBoxLayout *mainLayout = new QVBoxLayout( main, 0, spacingHint() );


  QGroupBox *generalGroupBox = new QGroupBox( 2, Qt::Horizontal, main );
  generalGroupBox->layout()->setSpacing( spacingHint() );
  generalGroupBox->setTitle( i18n( "General Settings" ) );

  new QLabel( mResource->isSyncable()?i18n( "Profile Name:" ):i18n( "Name:" ), generalGroupBox );

  mName = new KLineEdit( generalGroupBox );

  if (!mResource->isSyncable()) {
  	mReadOnly = new QCheckBox( i18n( "Read-only" ), generalGroupBox );
    mReadOnly->setChecked( mResource->readOnly() );
  }

  mName->setText( mResource->resourceName() );

  mainLayout->addWidget( generalGroupBox );

  QGroupBox *resourceGroupBox = new QGroupBox( 2, Qt::Horizontal,  main );
  resourceGroupBox->layout()->setSpacing( spacingHint());
  resourceGroupBox->setTitle( i18n( "%1 Resource Settings" )
                              .arg( factory->typeName( resource->type() ) ) );
  mainLayout->addWidget( resourceGroupBox );

  mainLayout->addStretch();

  mConfigWidget = factory->configWidget( resource->type(), resourceGroupBox );
  if ( mConfigWidget ) {
    connect( mConfigWidget, SIGNAL( setReadOnly( bool ) ),
        SLOT( setReadOnly( bool ) ) );
    connect( mConfigWidget, SIGNAL( setPersistentReadOnly( bool ) ),
        SLOT( setPersistentReadOnly( bool ) ) );
    mConfigWidget->setInEditMode( false );
    mConfigWidget->loadSettings( mResource );
    mConfigWidget->show();

  }

  if (mResource->isSyncable())
  {
    SyncWidgetContainer* c = factory->syncWidgetContainer( resource->type() );

    QFrame* syncPage = addPage("Settings");
  	QVBoxLayout *syncLayout = new QVBoxLayout( syncPage, 0, spacingHint() );
    mSyncWidget_Settings = c->generateSettingsTab(syncPage);
    syncLayout->addWidget( mSyncWidget_Settings );

    syncPage = addPage("Conflicts");
  	syncLayout = new QVBoxLayout( syncPage, 0, spacingHint() );
    mSyncWidget_Conflicts = c->generateConflictsTab(syncPage);
    syncLayout->addWidget( mSyncWidget_Conflicts );

    syncPage = addPage("Remote");
  	syncLayout = new QVBoxLayout( syncPage, 0, spacingHint() );
    mSyncWidget_Remote = c->generateRemoteTab(syncPage);
    syncLayout->addWidget( mSyncWidget_Remote );


    mSyncWidget_Settings->setInEditMode( false );
    mSyncWidget_Settings->loadSettings( mResource );
    mSyncWidget_Settings->show();

    mSyncWidget_Conflicts->setInEditMode( false );
    mSyncWidget_Conflicts->loadSettings( mResource );
    mSyncWidget_Conflicts->show();

    mSyncWidget_Remote->setInEditMode( false );
    mSyncWidget_Remote->loadSettings( mResource );
    mSyncWidget_Remote->show();

    delete c;

//    QGroupBox *syncGroupBox = new QGroupBox( 2, Qt::Horizontal,  syncPage );
//    syncGroupBox->layout()->setSpacing( spacingHint());
//    syncGroupBox->setTitle( i18n( "Syncronize Preferences" ) );
//    syncLayout->addWidget( syncGroupBox );

//    syncLayout->addStretch();
/*US
    mSyncWidget = factory->syncWidget( resource->type(), syncPage );
    syncLayout->addWidget( mSyncWidget );
    if ( mSyncWidget ) {
      mSyncWidget->setInEditMode( false );
      mSyncWidget->loadSettings( mResource );
      mSyncWidget->show();
    }
    */
  }




  connect( mName, SIGNAL( textChanged(const QString &)),
      SLOT( slotNameChanged(const QString &)));

  slotNameChanged( mName->text() );

//US  setMinimumSize( 400, 250 );
  setMinimumSize( KMIN(KGlobal::getDesktopWidth(), 400), KMIN(KGlobal::getDesktopHeight(), 250));

}

void ConfigDialog::setInEditMode( bool value )
{
  if ( mConfigWidget )
    mConfigWidget->setInEditMode( value );

  if ( mSyncWidget_Settings )
    mSyncWidget_Settings->setInEditMode( value );
  if ( mSyncWidget_Conflicts )
    mSyncWidget_Conflicts->setInEditMode( value );
  if ( mSyncWidget_Remote )
    mSyncWidget_Remote->setInEditMode( value );

}

void ConfigDialog::slotNameChanged( const QString &text)
{
  enableButtonOK( !text.isEmpty() );
}

void ConfigDialog::setReadOnly( bool value )
{
  if (!mResource->isSyncable()) {

    if (mPersistentReadOnly == false)
      mReadOnly->setChecked( value );
    else
      mReadOnly->setChecked( true );
  }
}

void ConfigDialog::setPersistentReadOnly( bool value )
{
  if (!mResource->isSyncable()) {

    mPersistentReadOnly = value;

    if (value == true)
      setReadOnly( true );

    mReadOnly->setEnabled( !value );
  }
}

void ConfigDialog::accept()
{
  if ( mName->text().isEmpty() ) {
    KMessageBox::sorry( this, mResource->isSyncable()?i18n( "Please enter a profile name" ):i18n( "Please enter a resource name" ) );
    return;
  }

  mResource->setResourceName( mName->text() );
  if (!mResource->isSyncable())
    mResource->setReadOnly( mReadOnly->isChecked() );

  if ( mConfigWidget ) {
    // First save generic information
    // Also save setting of specific resource type
    mConfigWidget->saveSettings( mResource );
  }

  if ( mSyncWidget_Settings )
    mSyncWidget_Settings->saveSettings( mResource );
  if ( mSyncWidget_Conflicts )
    mSyncWidget_Conflicts->saveSettings( mResource );
  if ( mSyncWidget_Remote )
    mSyncWidget_Remote->saveSettings( mResource );


  KDialog::accept();
}

//US #include "configdialog.moc"
