DECLARE SUB addArg (theType$, theName$, theCast$)
DECLARE SUB pre (a$, b$)
DECLARE SUB add (a$, b$)
DECLARE FUNCTION removeComma$ (text$)
DECLARE FUNCTION remove$ (source$, substring$)
DECLARE FUNCTION readLine$ ()
DECLARE SUB emit (tabsize!, text$)

'
' TO DO:
'   code to destructors so they remove reference to objects in lookup table
'
'   method for passing back values by reference. perhaps:
'       returnByRef( Variant& v, Number n )

CLS


DIM classes$(100)
classCount = 0
lineNum = 0

CLS
'INPUT "file to convert"; file$
file$ = "class.i"
OPEN file$ FOR INPUT AS #1
OPEN "tmp.1" FOR OUTPUT AS #2
OPEN "tmp.2" FOR OUTPUT AS #3
OPEN "tmp.3" FOR OUTPUT AS #4
OPEN "tmp.4" FOR OUTPUT AS #5
OPEN "out" FOR OUTPUT AS #6


PRINT #5, "// autogenerated - do not edit"
PRINT #5, "// (c) 2002 David Cuny"
PRINT #5, "// email: dcuny@lanset.com"
PRINT #5, ""

PRINT #5, "#ifdef __BORLANDC__"
PRINT #5, "    #pragma warn -8028"
PRINT #5, "    #pragma warn -8006"
PRINT #5, "#endif"


PRINT #4, "// init_wrappers: link methods to classes"
PRINT #4, "void init_wrappers()"
PRINT #4, "{"

stopFlag = 0

DO WHILE NOT EOF(1)
	
	' read a line
	a$ = readLine$
	lineNum = lineNum + 1
	PRINT a$

	' prevent code in comments from being interpreted
	IF INSTR(a$, "//") THEN
		' comment
		a$ = ""
	END IF

'win:
	IF INSTR(a$, "win:") THEN
		IF win THEN
			a$ = MID$(a$, 5)
		ELSE
			a$ = ""
		END IF
	END IF

'gtk:
	IF INSTR(a$, "gtk:") THEN
		IF gtk THEN
			a$ = MID$(a$, 5)
		ELSE
			a$ = ""
		END IF
	END IF

' %stop
	' %stop
	IF INSTR(a$, "%stop") THEN
		a$ = ""
		EXIT DO
	END IF


' %alias
	' %alias <alias> ...
	IF INSTR(a$, "%alias") THEN
		b$ = remove$(a$, "%alias")
		alias$ = remove$(a$, " ")
		a$ = ""
	ELSE
		alias$ = ""
	END IF


' %rename
	' %rename <new name> ...
	IF INSTR(a$, "%rename") THEN
		b$ = remove$(a$, "%rename")
		rename$ = remove$(a$, " ")
		a$ = ""
	ELSE
		rename$ = ""
	END IF

' %class
	IF INSTR(a$, "%class") = 1 THEN
		b$ = remove$(a$, "%class")
		IF INSTR(a$, ",") THEN
			' %class <CLASS>, <SUPER>
			class$ = remove$(a$, ",")
			super$ = "_" + a$
		ELSE
			' %class <CLASS>
			class$ = a$
			super$ = "NULL"
		END IF

		classCount = classCount + 1
		classes$(classCount) = class$

		'PRINT "Class = "; class$
		'PRINT "Super = "; super$
		a$ = ""

		classes = classes + 1
		PRINT #3, "int " + "_" + class$ + " = addClass( " + super$ + ", " + CHR$(34) + LCASE$(class$) + CHR$(34) + " );"

		' the delete routine
		delName$ = class$ + "_del"
		emit 0, "\void " + delName$ + "()\{"
		emit 4, "\delete (" + class$ + " *)me;"
		emit 0, "\};\\"
	  
		' link delete routine
		PRINT #4, "    addMethod( _" + class$ + ", ";
		PRINT #4, CHR$(34) + "del" + CHR$(34) + ", ";
		PRINT #4, delName$ + ", 0, 0 );"

	ELSEIF INSTR(a$, "%include") = 1 THEN
		b$ = remove$(a$, "%include")
		PRINT #5, "#include " + a$
		a$ = ""

	END IF

' %{
	IF a$ = "%{" THEN
		' echo until "%}"
		DO
			a$ = readLine$
			IF INSTR(a$, "%}") THEN
				EXIT DO
			ELSE
				'PRINT a$
			END IF
		LOOP
		a$ = ""
	END IF

	IF INSTR(a$, "(") = 0 THEN
		' ignore, not a method
		a$ = ""
	END IF

' virtual
	IF INSTR(a$, "virtual") = 1 THEN
		b$ = remove$(a$, "virtual")
	END IF

' static
	IF INSTR(a$, "static") = 1 THEN
		b$ = remove$(a$, "static")
	END IF



	IF a$ <> "" THEN


' ---------------------------------------------------------
' GET THE TYPE
' ---------------------------------------------------------

		'PRINT a$

		deref = 0

		' remove const
		IF INSTR(a$, "const") = 1 THEN
			ignore$ = remove$(a$, "const")
		END IF


		' constructor?
		IF INSTR(a$, class$ + "(") THEN
			type$ = "void"

		ELSE
			' type should follow...
			type$ = remove$(a$, " ")
		END IF
	  
		' pointers?
		WHILE INSTR(a$, "*") = 1
			b$ = remove$(a$, "*")
			type$ = type$ + "*"
		WEND

		IF INSTR(type$, "&") THEN
			type$ = remove$(type$, "&")
			type$ = type$ + "*"
			deref = -1
		END IF
			

		'PRINT "Type="; type$




' ---------------------------------------------------------
' GET THE FUNCTION NAME
' ---------------------------------------------------------


		func$ = remove$(a$, "(")
		'PRINT "Function='"; func$; "'"
		argList$ = ""
		defList$ = ""
		callList$ = ""
		preCode$ = ""
		postCode$ = ""
		popCode$ = ""
		hasOptional = 0

		moreArgs = 1
		args = 0
		opts = 0

		' read the args
		DO WHILE moreArgs

' ---------------------------------------------------------
' GET AN ARG FROM THE LIST
' ---------------------------------------------------------

			' end of line?
			IF a$ = "" THEN
				a$ = readLine$
			END IF

			IF INSTR(a$, "const ") = 1 THEN
				ignore$ = remove$(a$, "const")
				isConst = 1
			ELSE
				isConst = 0
			END IF

			IF INSTR(a$, ",") THEN
				arg$ = remove$(a$, ",")

			ELSEIF INSTR(a$, ")") THEN
				arg$ = remove$(a$, ")")
				moreArgs = 0

			ELSE
				PRINT "Error parsing args"
				PRINT a$
				END

			END IF

			IF INSTR(arg$, "=") THEN
				b$ = remove$(arg$, "=")
				opt$ = arg$
				arg$ = b$
				hasOptional = 1
			ELSE
				IF hasOptional <> 0 THEN
					PRINT "Error in line "; lineNum; ": "; arg$; " should be optional"
					END
				END IF
				opt$ = ""
			END IF
			'PRINT "Arg="; arg$


			IF arg$ <> "" AND LEN(callList$) <> 0 THEN
				argList$ = argList$ + ", "
				callList$ = callList$ + ", "
			END IF

			' arg count
			IF arg$ <> "" THEN
				IF opt$ <> "" THEN
					opts = opts + 1
				ELSE
					args = args + 1
				END IF
			END IF


			' decode the args
			IF arg$ = "" THEN
				' no arg

' ---------------------------------------------------------
' const wxString name[]
' ---------------------------------------------------------
			ELSEIF INSTR(arg$, "wxString") <> 0 AND INSTR(arg$, "[]") THEN
				' const wxString name[]
				argType$ = "wxString"
				argType$ = remove$(arg$, "wxString")
				argName$ = remove$(arg$, "[]")
				addArg "list", argName$, argType$
				add callList$, argName$

' ---------------------------------------------------------
' type& name
' ---------------------------------------------------------
		   
			ELSEIF INSTR(arg$, "&") THEN
				' const type& name
				argType$ = remove$(arg$, "&")
				argName$ = arg$

' ---------------------------------------------------------
' ... wxString& name
' ---------------------------------------------------------
			   
				IF argType$ = "wxString" THEN
					addArg "string", argName$, "wxString"
					callList$ = callList$ + argName$

' ---------------------------------------------------------
' ... type& name
' ---------------------------------------------------------

				ELSE
					argList$ = argList$ + argType$ + " " + argName$
					addArg "ref", argName$, argType$
					callList$ = callList$ + argName$
			  
				END IF


			ELSEIF INSTR(arg$, "*") THEN
' ---------------------------------------------------------
' ... wxClass* name
' ---------------------------------------------------------
				' type wxClass*
				IF MID$(arg$, 1, 2) = "wx" THEN
					argType$ = remove$(arg$, "*")
					argName$ = arg$
					addArg "pointer", argName$, argType$
					add callList$, argName$
	
				ELSE
				   
' ---------------------------------------------------------
' ... type* name
' ---------------------------------------------------------
				   
					' normal type
					argType$ = remove$(arg$, "*")
					argName$ = arg$
					
					addArg "pointer", argName$, argType$
					add callList$, argName$

					IF argType$ = "char" THEN
						add postCode$, "\free( " + argName$ + ");"
					END IF

				END IF

			ELSE
			   
' ---------------------------------------------------------
' type name
' ---------------------------------------------------------
			  
				argType$ = remove$(arg$, " ")
				argName$ = arg$
				
				addArg "number", argName$, argType$
				add callList$, argName$

			END IF
		LOOP

		IF type$ <> "void" THEN
			IF type$ = "wxString" THEN
				add defList$, "\wxString returns;"

			ELSEIF MID$(type$, 1, 2) = "wx" AND INSTR(type$, "*") = 0 THEN
				' raw object, make it a pointer
				add defList$, "\" + type$ + " *returns;"

			ELSE
				add defList$, "\" + type$ + " returns;"

			END IF
		ELSEIF func$ = class$ THEN
			add defList$, "\" + class$ + " *returns;"
		END IF



' ---------------------------------------------------------
' COMMENTS: NUMBER OF ARGS
' ---------------------------------------------------------

		' header
		'IF LEN(argList$) THEN
		'    emit 0, "// " + name$ + " " + argList$ + "\"
		'ELSE
		'    emit 0, "// " + name$ + " no parameters\"
		'END IF

' ---------------------------------------------------------
' PRINT THE HEADER
' ---------------------------------------------------------

		emit 0, "void "
		IF class$ = func$ THEN
			name$ = class$ + "_new"
		ELSEIF func$ = "~" + class$ THEN
			name$ = class$ + "_dtor"
		ELSEIF LEN(rename$) THEN
			name$ = class$ + "_" + rename$
		ELSE
			name$ = class$ + "_" + func$
		END IF
		emit 0, name$ + "()\{"

		emit 4, defList$
	   
		IF LEN(popCode$) THEN
			emit 4, "\\// get args"
			emit 4, popCode$
		END IF

		emit 4, preCode$

		emit 4, "\\// call " + func$
	   
		IF class$ = func$ THEN
			emit 4, "\returns = new " + class$ + "(" + callList$ + ");"
		ELSE
			IF type$ = "void" THEN
				emit 4, "\((" + class$ + " *)me)->" + func$ + "(" + callList$ + ");"
			ELSEIF type$ = "wxString" THEN
				emit 4, "\returns = ((" + class$ + " *)me)->" + func$ + "(" + callList$ + ");"
			ELSEIF MID$(type$, 1, 2) = "wx" AND INSTR(type$, "*") = 0 THEN
				' make it a pointer
				emit 4, "\returns = &((" + class$ + " *)me)->" + func$ + "(" + callList$ + ");"
			ELSEIF deref THEN
				' make it a pointer
				emit 4, "\returns = &((" + class$ + " *)me)->" + func$ + "(" + callList$ + ");"

			ELSE
				emit 4, "\returns = ((" + class$ + " *)me)->" + func$ + "(" + callList$ + ");"
			END IF
		END IF
		emit 0, "\"

		emit 4, postCode$

		IF type$ = "void" THEN
			IF func$ = class$ THEN
				emit 4, "\pushNumber( addObject( _" + class$ + ", (int)returns ) );"
			ELSE
				emit 4, "\// result is ignored"
				emit 4, "\pushNumber( (Number)0 );"
			END IF
	   
		ELSEIF type$ = "wxString" THEN
			emit 4, "\pushString( (char *)(returns.c_str()) );"
			'emit 4, "\delete returns;"

		ELSEIF type$ = "wxString*" THEN
			emit 4, "\pushString( (char *)(returns->c_str()) );"
			'emit 4, "\delete returns;"

		ELSEIF MID$(type$, 1, 2) = "wx" THEN
			' wrap pointer
			IF INSTR(type$, "*") <> 0 THEN
				type$ = remove$(type$, "*")
				emit 4, "\pushNumber( addObject( _" + type$ + ", (int)returns ) );"

			ELSEIF INSTR(type$, "&") <> 0 THEN
				emit 4, "\pushNumber( addObject( _" + type$ + ", (int)(&returns) ) );"

			ELSE
				emit 4, "\pushNumber( addObject( _" + type$ + ", (int)(&returns) ) );"
			END IF

			
		ELSE
			IF INSTR(type$, "wx") <> 0 OR INSTR(type$, "*") THEN
				emit 4, "\pushNumber( (Number)(int)returns);"
			ELSE
				emit 4, "\pushNumber( (Number)returns);"
			END IF
		END IF

		emit 0, "\}\\"

		' remove class from name
		shortName$ = name$
		ignore$ = remove(shortName$, "_")

		' link
		PRINT #4, "    addMethod( _" + class$ + ", ";
		PRINT #4, CHR$(34) + LCASE$(shortName$) + CHR$(34) + ", ";
		PRINT #4, name$ + ", ";
		PRINT #4, STR$(args) + ", " + STR$(args + opts) + ");"

	END IF

LOOP

PRINT #3, ""
PRINT #3, ""
PRINT #4, "}"

CLOSE

SHELL "type tmp.4 > wrap.cpp"       ' include files
SHELL "type tmp.2 >> wrap.cpp"      ' class literals
SHELL "type tmp.1 >> wrap.cpp"      ' wrappers
SHELL "type tmp.3 >> wrap.cpp"      ' init routine
SHELL "del tmp.?"


SYSTEM

SUB add (a$, b$)
	a$ = a$ + b$
END SUB

SUB addArg (theType$, theName$, theCast$)
	' add the argument to the popCode$ list

	SHARED popCode$     ' code that reads args
	SHARED postCode$    ' cleanup
	SHARED args         ' count of required args
	SHARED opts         ' count of optional args
	SHARED opt$         ' optional value
	SHARED classes$()
	SHARED classCount
	SHARED isConst

	' only check type if it's a class
	checkType$ = "0"
	IF theType$ = "pointer" OR theType$ = "ref" THEN
		IF MID$(theCast$, 1, 2) = "wx" AND theCast$ <> "wxString" THEN
			checkType$ = "_" + theCast$
		END IF
	END IF


	' if reading from the stack
	SELECT CASE theType$
	CASE "string"
		stack$ = "popString()"
		v$ = "wxString " + theName$

	CASE "number"
		stack$ = "(" + theCast$ + ")popNumber()"
		v$ = "Number " + theName$

	CASE "pointer"
		stack$ = "(" + theCast$ + " *)popPointer( " + checkType$ + ")"
		v$ = theCast$ + " *" + theName$

	CASE "ref"
		stack$ = "(" + theCast$ + " *)popPointer( " + checkType$ + ")"
		IF isConst = 0 THEN
			' dereference value
			stack$ = "*" + stack$

			' get address of default
			IF opt$ <> "" THEN
				opt$ = "&" + opt$
			END IF
		END IF
		v$ = theCast$ + " " + theName$ + "&"

	CASE "list"

		stack$ = "\wxString " + theName$ + "[32];"
		IF opt$ <> "" THEN
			indent$ = "\    "
			add stack$, "\if (argCount > " + STR$(args + opts - 1) + ") {"
		ELSE
			indent$ = "\"
		END IF

		add stack$, indent$ + "char **stringList = popStringList();"
		add stack$, indent$ + "for ( int _i = 0; stringList[_i] != NULL; _i++ ){"
		add stack$, indent$ + "    " + theName$ + "[_i] = stringList[_i];"
		add stack$, indent$ + "}"
		add stack$, indent$ + "freeStringList( stringList );"
		IF opt$ <> "" THEN
			add stack$, "\}"
		END IF
		pre popCode$, stack$

		

		EXIT SUB

	CASE ELSE
		PRINT "addArg: can't handle type " + theType$
		SYSTEM
	END SELECT
   

	IF opt$ = "" THEN
		' just read from the stack
		pre popCode$, "\" + v$ + " = " + stack$ + ";"

	ELSE
		' test arg count
		'pre popCode$, "\}"
		'pre popCode$, "\    " + v$ + " = " + opt$ + ";"
		'pre popCode$, "\} else {"
		'pre popCode$, "\    " + v$ + " = " + stack$ + ";"
		'pre popCode$, "\if (argCount > " + STR$(args + opts - 1) + ") {"
		pre popCode$, "\" + v$ + " = (argCount >" + STR$(args + opts - 1) + " ? " + stack$ + " : " + opt$ + ");"
	END IF
END SUB

SUB emit (tabsize, text$)
	' figure out the amount of leading space
	a$ = ""
	FOR i = 1 TO LEN(text$)
		c$ = MID$(text$, i, 1)
		IF c$ = "\" THEN
			PRINT #2, a$
			a$ = ""
			IF tabsize THEN
				PRINT #2, SPACE$(tabsize);
			END IF
		ELSE
			a$ = a$ + c$
		END IF
	NEXT
	PRINT #2, a$;
END SUB

SUB pre (a$, b$)
	a$ = b$ + a$
END SUB

FUNCTION readLine$
	LINE INPUT #1, text$
	readLine$ = LTRIM$(RTRIM$(text$))
END FUNCTION

FUNCTION remove$ (source$, substring$)
PRINT "source='"; source$; "'"
PRINT "substring='"; substring$; "'"
	a = INSTR(source$, substring$)
	remove$ = LTRIM$(RTRIM$(MID$(source$, 1, a - 1)))
	source$ = LTRIM$(RTRIM$(MID$(source$, a + LEN(substring$))))
END FUNCTION

FUNCTION removeComma$ (text$)
	IF LEN(text$) THEN
		removeComma$ = MID$(text$, 1, LEN(text$) - 2)
	ELSE
		removeComma$ = text$
	END IF
END FUNCTION

