#!/bin/bash

# Copyright Jean-Philippe Guillemin <jp.guillemin@free.fr>. This program is free software; you can redistribute
# it and/or modify it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or (at your option)
# any later version. Please take a look at http://www.gnu.org/copyleft/gpl.htm
#

trap 'exit' TERM INT EXIT

transform() {
		infile="$(echo "${1}" \
		| sed -e 's/;\+/_/g' \
		| sed -e 's/,\+/-/g')"
		mv "$1" "$infile" 2>/dev/null
		nofile="$(basename "${infile}" ".${intype}")"
		outfile="${nofile}.${outtype}"
		rm -f "${outfile}" 
		command "$infile" "${outfile}" 
		mkdir -p "_old_${intype}_"
		mv "${infile}" "_old_${intype}_"
}

if [ "$1" ] ; then
	if [ ! -e "$1" ] ; then
		echo "cannot find $1, bye ..."
		exit
	fi 
	transform "$1" 
else
	if [ ! -e *."$intype" ] ; then
		echo "cannot find any $intype here, bye ..."
		exit
	fi 
	for file in ./*.$intype ; do
		transform "$file"
	done
fi

