'''
Task Coach - Your friendly task manager
Copyright (C) 2004-2008 Frank Niessink <frank@niessink.com>

Task Coach is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Task Coach is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

from taskcoachlib import patterns
from taskcoachlib.domain import base
import category


class CategoryFilter(base.Filter):
    def __init__(self, *args, **kwargs):
        self.__categories = kwargs.pop('categories')
        self.__filterOnlyWhenAllCategoriesMatch = \
            kwargs.pop('filterOnlyWhenAllCategoriesMatch', False)
        eventTypes = [self.__categories.addItemEventType(),
                      self.__categories.removeItemEventType(),
                      category.Category.categorizableAddedEventType(),
                      category.Category.categorizableRemovedEventType(),
                      category.Category.filterChangedEventType()]
        for eventType in eventTypes:
            patterns.Publisher().registerObserver(self.onCategoryChanged,
                                                  eventType=eventType)
        super(CategoryFilter, self).__init__(*args, **kwargs)
    
    def setFilterOnlyWhenAllCategoriesMatch(self, filterOnlyWhenAllCategoriesMatch=True):
        self.__filterOnlyWhenAllCategoriesMatch = filterOnlyWhenAllCategoriesMatch
        
    def filter(self, categorizables): # FIXME: generalize to categorizable
        filteredCategories = [category for category in self.__categories 
                              if category.isFiltered()]
        if filteredCategories:
            return [categorizable for categorizable in categorizables if \
                    self.filterCategorizable(categorizable, filteredCategories)]
        else:
            return categorizables
        
    def filterCategorizable(self, categorizable, filteredCategories):
        matches = [category.contains(categorizable, self.treeMode()) 
                   for category in filteredCategories]
        if self.__filterOnlyWhenAllCategoriesMatch:
            return False not in matches
        else:
            return True in matches
        
    def onCategoryChanged(self, event):
        self.reset()
