'''
Task Coach - Your friendly task manager
Copyright (C) 2004-2008 Frank Niessink <frank@niessink.com>

Task Coach is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Task Coach is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

from taskcoachlib import patterns
from taskcoachlib.domain import base


class EffortSorter(base.Sorter):
    EventTypePrefix = 'effort'
    def __init__(self, *args, **kwargs):
        kwargs['sortAscending'] = False
        super(EffortSorter, self).__init__(*args, **kwargs)
        patterns.Publisher().registerObserver(self.reset, 
            eventType='effort.start')
        patterns.Publisher().registerObserver(self.reset,
            eventType='effort.task')
    
    def createSortKeyFunction(self):
        # Sort by start of effort first, then by task subject
        return lambda effort: (effort.getStart(), 
                               effort.task().subject(recursive=True))

