/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.analysis;

import antlr.NoViableAltException;
import antlr.RecognitionException;
import antlr.TreeParser;
import antlr.collections.AST;
import com.evelopers.unimod.analysis.FormulaCalculatorTokenTypes;
import com.evelopers.unimod.analysis.executors.Substitution;
import com.evelopers.unimod.parser.ConstNode;

public class FormulaCalculator
extends TreeParser
implements FormulaCalculatorTokenTypes {
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "TRUE", "FALSE", "OR", "AND", "NOT", "LPAREN", "RPAREN", "EQUAL", "NEQUAL", "GE", "GT", "LE", "LT", "IDENT", "CONST_BOOL", "CONST_NUM", "WS", "DIGIT", "LETTER", "NAME", "CONST_BOOL_OR_IDENT"};

    private boolean calculatePredicate(AST predicate, Substitution substitution) {
        AST op1 = predicate.getFirstChild();
        AST op2 = op1.getNextSibling();
        if (op1.getType() == 17 && op2.getType() == 19) {
            String variableName = op1.getText();
            ConstNode constNode = (ConstNode)op2;
            return substitution.getPredicateValue(variableName, predicate.getType(), constNode.getObjectValue());
        }
        if (op2.getType() == 17 && op1.getType() == 19) {
            String variableName = op2.getText();
            ConstNode constNode = (ConstNode)op1;
            return substitution.getPredicateValue(variableName, this.getReflected(predicate.getType()), constNode.getObjectValue());
        }
        this.reportWarning("predicate " + predicate + " skippped");
        Object variableName = null;
        Object constNode = null;
        return false;
    }

    private boolean calculateOr(AST or, Substitution substitution) throws RecognitionException {
        AST child = or.getFirstChild();
        while (child != null) {
            if (this.calculate(child, substitution)) {
                return true;
            }
            child = child.getNextSibling();
        }
        return false;
    }

    private boolean calculateAnd(AST and, Substitution substitution) throws RecognitionException {
        AST child = and.getFirstChild();
        while (child != null) {
            if (!this.calculate(child, substitution)) {
                return false;
            }
            child = child.getNextSibling();
        }
        return true;
    }

    private int getReflected(int type) {
        switch (type) {
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 15;
            }
            case 15: {
                return 13;
            }
            case 14: {
                return 16;
            }
            case 16: {
                return 14;
            }
        }
        throw new IllegalArgumentException();
    }

    public FormulaCalculator() {
        this.tokenNames = _tokenNames;
    }

    public final boolean calculate(AST _t, Substitution substitution) throws RecognitionException {
        boolean value;
        AST aST = _t == ASTNULL ? null : _t;
        AST or = null;
        AST and = null;
        AST not = null;
        AST id = null;
        AST eq = null;
        AST ne = null;
        AST ge = null;
        AST gt = null;
        AST le = null;
        AST lt = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 6: {
                or = _t;
                this.match(_t, 6);
                _t = _t.getNextSibling();
                value = this.calculateOr(or, substitution);
                break;
            }
            case 7: {
                and = _t;
                this.match(_t, 7);
                _t = _t.getNextSibling();
                value = this.calculateAnd(and, substitution);
                break;
            }
            case 8: {
                not = _t;
                this.match(_t, 8);
                _t = _t.getNextSibling();
                value = !this.calculate(not.getFirstChild(), substitution);
                break;
            }
            case 17: {
                id = _t;
                this.match(_t, 17);
                _t = _t.getNextSibling();
                value = substitution.getBooleanVarValue(id.getText());
                break;
            }
            case 11: {
                eq = _t;
                this.match(_t, 11);
                _t = _t.getNextSibling();
                value = this.calculatePredicate(eq, substitution);
                break;
            }
            case 12: {
                ne = _t;
                this.match(_t, 12);
                _t = _t.getNextSibling();
                value = this.calculatePredicate(ne, substitution);
                break;
            }
            case 13: {
                ge = _t;
                this.match(_t, 13);
                _t = _t.getNextSibling();
                value = this.calculatePredicate(ge, substitution);
                break;
            }
            case 14: {
                gt = _t;
                this.match(_t, 14);
                _t = _t.getNextSibling();
                value = this.calculatePredicate(gt, substitution);
                break;
            }
            case 15: {
                le = _t;
                this.match(_t, 15);
                _t = _t.getNextSibling();
                value = this.calculatePredicate(le, substitution);
                break;
            }
            case 16: {
                lt = _t;
                this.match(_t, 16);
                _t = _t.getNextSibling();
                value = this.calculatePredicate(lt, substitution);
                break;
            }
            case 4: {
                this.match(_t, 4);
                _t = _t.getNextSibling();
                value = true;
                break;
            }
            case 5: {
                this.match(_t, 5);
                _t = _t.getNextSibling();
                value = false;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this._retTree = _t;
        return value;
    }
}

