/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.analysis;

import antlr.ASTFactory;
import antlr.RecognitionException;
import antlr.collections.AST;
import com.evelopers.unimod.analysis.FormulaCalculator;
import com.evelopers.unimod.analysis.Gatherer;
import com.evelopers.unimod.analysis.OldTypeInfoProviderBuilder;
import com.evelopers.unimod.analysis.TypeInfoProvider;
import com.evelopers.unimod.analysis.executors.FormulaGenerator;
import com.evelopers.unimod.analysis.executors.LongSet;
import com.evelopers.unimod.analysis.executors.Simplifier;
import com.evelopers.unimod.analysis.executors.Substitution;
import com.evelopers.unimod.analysis.executors.SubstitutionBuilder;
import java.util.Collection;
import java.util.Iterator;

public class FormulaResolver {
    private final AST formula;
    private final TypeInfoProvider provider;
    private LongSet trueSubstitutions;
    private LongSet falseSubsisutions;
    private Substitution substitution;
    private FormulaCalculator calculator;

    public FormulaResolver(AST formula, TypeInfoProvider provider) {
        this.formula = formula;
        this.provider = provider;
        this.calculator = new FormulaCalculator();
    }

    public FormulaResolver(AST formula) throws RecognitionException {
        this(formula, OldTypeInfoProviderBuilder.buildProvider(formula));
    }

    public Substitution getSubstitution() throws RecognitionException {
        if (this.substitution == null) {
            Gatherer gatherer = new Gatherer(this.provider);
            gatherer.gather(this.formula);
            SubstitutionBuilder builder = gatherer.getBuilder();
            this.substitution = builder.buildSubstitution();
        }
        return this.substitution;
    }

    public LongSet getSubstitutions(boolean value) throws RecognitionException {
        if (value) {
            if (this.trueSubstitutions == null) {
                this.trueSubstitutions = this.findSubstitutions(value);
            }
            return this.trueSubstitutions;
        }
        if (this.falseSubsisutions == null) {
            this.falseSubsisutions = this.findSubstitutions(value);
        }
        return this.falseSubsisutions;
    }

    public String getSimplifiedDNF(boolean value) throws RecognitionException {
        LongSet substitutions = this.getSubstitutions(value);
        if (substitutions.isEmpty()) {
            return "false";
        }
        Simplifier simplifier = new Simplifier(this.substitution, substitutions);
        simplifier.simplify();
        substitutions = simplifier.getSubstitutions();
        if (substitutions.isEmpty()) {
            return "true";
        }
        long[] mask = simplifier.getMask();
        FormulaGenerator generator = new FormulaGenerator(this.provider, this.substitution, substitutions, mask);
        return generator.generateExpression();
    }

    public boolean isTautology() throws RecognitionException {
        return this.getSubstitutions(false).isEmpty();
    }

    public boolean isUnsatisfiable() throws RecognitionException {
        return this.getSubstitutions(true).isEmpty();
    }

    public static FormulaResolver createConjunction(AST a, AST b, TypeInfoProvider provider) {
        AST conjunction = FormulaResolver.and(a, b);
        return new FormulaResolver(conjunction, provider);
    }

    public static FormulaResolver createConjunction(AST a, AST b) throws RecognitionException {
        AST conjunction = FormulaResolver.and(a, b);
        return new FormulaResolver(conjunction);
    }

    public static FormulaResolver createDisjunction(Collection formulas, TypeInfoProvider provider) {
        AST disjunction = FormulaResolver.or(formulas);
        return new FormulaResolver(disjunction, provider);
    }

    public static FormulaResolver createDisjunction(Collection formulas) throws RecognitionException {
        AST disjunction = FormulaResolver.or(formulas);
        return new FormulaResolver(disjunction);
    }

    public static AST and(AST a, AST b) {
        ASTFactory astFactory = new ASTFactory();
        AST parent = astFactory.create(7, "&&");
        parent.addChild(astFactory.dupTree(a));
        parent.addChild(astFactory.dupTree(b));
        return parent;
    }

    public static AST or(Collection formulas) {
        ASTFactory astFactory = new ASTFactory();
        AST parent = astFactory.create(6, "||");
        Iterator i = formulas.iterator();
        while (i.hasNext()) {
            AST ast = (AST)i.next();
            parent.addChild(astFactory.dupTree(ast));
        }
        return parent;
    }

    private LongSet findSubstitutions(boolean formulaValue) throws RecognitionException {
        this.getSubstitution();
        LongSet substitutions = new LongSet();
        this.substitution.reset();
        while (this.substitution.hasMoreSubstitutions()) {
            boolean value = this.calculator.calculate(this.formula, this.substitution);
            if (formulaValue == value) {
                substitutions.add(this.substitution.getSubstitution());
            }
            this.substitution.nextSubstitution();
        }
        return substitutions;
    }
}

