/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.analysis;

import com.evelopers.unimod.analysis.TypeInfo;
import java.util.Set;
import org.apache.commons.lang.BooleanUtils;

public abstract class TypeInfoProvider {
    public TypeInfo getTypeInfo(String variableName) {
        if (this.getType(variableName) == TypeInfo.BYTE.getType()) {
            return TypeInfo.BYTE;
        }
        if (this.getType(variableName) == TypeInfo.SHORT.getType()) {
            return TypeInfo.SHORT;
        }
        if (this.getType(variableName) == TypeInfo.INT.getType()) {
            return TypeInfo.INT;
        }
        if (this.getType(variableName) == TypeInfo.LONG.getType()) {
            return TypeInfo.LONG;
        }
        if (this.getType(variableName) == TypeInfo.FLOAT.getType()) {
            return TypeInfo.FLOAT;
        }
        if (this.getType(variableName) == TypeInfo.DOUBLE.getType()) {
            return TypeInfo.DOUBLE;
        }
        if (this.getType(variableName) == TypeInfo.BOOLEAN.getType()) {
            return TypeInfo.BOOLEAN;
        }
        if (this.getType(variableName) == TypeInfo.CHAR.getType()) {
            return TypeInfo.CHAR;
        }
        if (this.getType(variableName) == TypeInfo.STRING.getType()) {
            return TypeInfo.STRING;
        }
        if (this.getType(variableName) == TypeInfo.DISCRETE.getType()) {
            return TypeInfo.createDiscreteTypeInfo(this.getValueClass(variableName));
        }
        if (this.getType(variableName) == TypeInfo.FINIT_SET.getType()) {
            return TypeInfo.createFinitSetTypeInfo(this.getValuesSet(variableName), this.getValueClass(variableName));
        }
        throw new IllegalArgumentException("Can't get TypeInfo about variable [" + variableName + "]");
    }

    public Object parseConstant(String variableName, String constantValue) {
        if (this.getType(variableName) == TypeInfo.BYTE.getType()) {
            return Byte.decode(constantValue);
        }
        if (this.getType(variableName) == TypeInfo.SHORT.getType()) {
            return Short.decode(constantValue);
        }
        if (this.getType(variableName) == TypeInfo.INT.getType()) {
            return Integer.decode(constantValue);
        }
        if (this.getType(variableName) == TypeInfo.LONG.getType()) {
            return Long.decode(constantValue);
        }
        if (this.getType(variableName) == TypeInfo.FLOAT.getType()) {
            return Float.valueOf(constantValue);
        }
        if (this.getType(variableName) == TypeInfo.DOUBLE.getType()) {
            return Double.valueOf(constantValue);
        }
        if (this.getType(variableName) == TypeInfo.BOOLEAN.getType()) {
            return BooleanUtils.toBooleanObject((String)constantValue);
        }
        if (this.getType(variableName) == TypeInfo.CHAR.getType()) {
            if (constantValue.startsWith("'") && constantValue.endsWith("'") && constantValue.length() == 3) {
                return new Character(constantValue.charAt(1));
            }
        } else if (this.getType(variableName) == TypeInfo.STRING.getType() && constantValue.startsWith("\"") && constantValue.endsWith("\"") && constantValue.length() >= 2) {
            return constantValue.substring(1, constantValue.length() - 1);
        }
        throw new IllegalArgumentException("Can't cast constant [" + constantValue + "]" + " to type of variable [" + variableName + "]");
    }

    public String constantToString(String variableName, Object constantValue) {
        if (this.getType(variableName) == TypeInfo.BYTE.getType() || this.getType(variableName) == TypeInfo.SHORT.getType() || this.getType(variableName) == TypeInfo.INT.getType() || this.getType(variableName) == TypeInfo.LONG.getType() || this.getType(variableName) == TypeInfo.FLOAT.getType() || this.getType(variableName) == TypeInfo.DOUBLE.getType() || this.getType(variableName) == TypeInfo.BOOLEAN.getType()) {
            return String.valueOf(constantValue);
        }
        if (this.getType(variableName) == TypeInfo.CHAR.getType()) {
            return "'" + String.valueOf(constantValue) + "'";
        }
        if (this.getType(variableName) == TypeInfo.STRING.getType()) {
            return "\"" + String.valueOf(constantValue) + "\"";
        }
        throw new IllegalArgumentException("Can't cast constant [" + constantValue + "]" + " to string for variable [" + variableName + "]");
    }

    protected abstract int getType(String var1);

    protected abstract Set getValuesSet(String var1);

    protected abstract Class getValueClass(String var1);
}

