/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.analysis.executors;

import com.evelopers.unimod.analysis.TypeInfo;
import com.evelopers.unimod.analysis.TypeInfoProvider;
import com.evelopers.unimod.analysis.executors.DiscreteRangePredicateExecutorBuilder;
import com.evelopers.unimod.analysis.executors.DiscreteSetPredicateExecutorBuilder;
import com.evelopers.unimod.analysis.executors.FinitSetPredicateExecutorBuilder;
import com.evelopers.unimod.analysis.executors.Position;
import com.evelopers.unimod.analysis.executors.PredicateExecutor;
import com.evelopers.unimod.analysis.executors.PredicateExecutorBuilder;
import com.evelopers.unimod.analysis.executors.PredicatePosition;
import com.evelopers.unimod.analysis.executors.RangePredicateExecutorBuilder;
import com.evelopers.unimod.analysis.executors.Substitution;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SubstitutionBuilder {
    private TypeInfoProvider typeInfoProvider;
    private List booleanVars = new LinkedList();
    private List predicateVars = new LinkedList();
    private Map builders = new HashMap();

    public SubstitutionBuilder(TypeInfoProvider typeInfoProvider) {
        this.typeInfoProvider = typeInfoProvider;
    }

    public void addBooleanVar(String variableName) {
        if (this.typeInfoProvider.getTypeInfo(variableName).getType() == TypeInfo.BOOLEAN.getType()) {
            if (!this.booleanVars.contains(variableName)) {
                this.booleanVars.add(variableName);
            }
        } else {
            throw new IllegalArgumentException("Variable [" + variableName + "] is not boolean");
        }
    }

    public void addPredicate(int predicateType, String variableName, String constantValue) {
        if (!this.builders.containsKey(variableName)) {
            this.predicateVars.add(variableName);
        }
        PredicateExecutorBuilder builder = this.getBuilder(variableName);
        builder.addPredicate(predicateType, this.typeInfoProvider.parseConstant(variableName, constantValue));
    }

    public Substitution buildSubstitution() {
        int bits = 0;
        HashMap<String, Position> positions = new HashMap<String, Position>();
        LinkedList<PredicatePosition> predicatePositions = new LinkedList<PredicatePosition>();
        Iterator i = this.booleanVars.iterator();
        while (i.hasNext()) {
            String variableName = (String)i.next();
            Position position = new Position();
            position.position = bits++;
            positions.put(variableName, position);
        }
        Map predicateExecutors = this.getPredicateExecutors();
        Iterator i2 = this.predicateVars.iterator();
        while (i2.hasNext()) {
            String variableName = (String)i2.next();
            PredicateExecutor executor = (PredicateExecutor)predicateExecutors.get(variableName);
            PredicatePosition position = new PredicatePosition();
            position.position = bits;
            position.predicateExecutor = executor;
            position.cardinality = executor.getCardinality();
            position.bits = this.ceilLog2(position.cardinality);
            positions.put(variableName, position);
            predicatePositions.add(position);
            bits += position.bits;
        }
        return new Substitution(bits, positions, predicatePositions);
    }

    private Map getPredicateExecutors() {
        HashMap<String, PredicateExecutor> predicateExecutors = new HashMap<String, PredicateExecutor>();
        Iterator i = this.builders.keySet().iterator();
        while (i.hasNext()) {
            String variableName = (String)i.next();
            PredicateExecutorBuilder builder = (PredicateExecutorBuilder)this.builders.get(variableName);
            predicateExecutors.put(variableName, builder.createPredicateExecutor());
        }
        return predicateExecutors;
    }

    private PredicateExecutorBuilder getBuilder(String variableName) {
        PredicateExecutorBuilder builder = (PredicateExecutorBuilder)this.builders.get(variableName);
        if (builder == null) {
            TypeInfo typeInfo = this.typeInfoProvider.getTypeInfo(variableName);
            if (typeInfo.getType() == TypeInfo.BYTE.getType() || typeInfo.getType() == TypeInfo.SHORT.getType() || typeInfo.getType() == TypeInfo.INT.getType() || typeInfo.getType() == TypeInfo.LONG.getType() || typeInfo.getType() == TypeInfo.CHAR.getType()) {
                builder = new DiscreteRangePredicateExecutorBuilder(typeInfo);
            } else if (typeInfo.getType() == TypeInfo.FLOAT.getType() || typeInfo.getType() == TypeInfo.DOUBLE.getType()) {
                builder = new RangePredicateExecutorBuilder(typeInfo);
            } else if (typeInfo.getType() == TypeInfo.STRING.getType() || typeInfo.getType() == TypeInfo.DISCRETE.getType()) {
                builder = new DiscreteSetPredicateExecutorBuilder();
            } else if (typeInfo.getType() == TypeInfo.FINIT_SET.getType()) {
                builder = new FinitSetPredicateExecutorBuilder(typeInfo.getValuesSet());
            } else {
                throw new IllegalArgumentException("Can't get TypeInfo about variable [" + variableName + "]");
            }
            this.builders.put(variableName, builder);
        }
        return builder;
    }

    private int ceilLog2(int argument) {
        int ceilLog2 = (int)Math.ceil(Math.log(argument) / Math.log(2.0));
        return ceilLog2;
    }
}

