/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.core.stateworks;

import com.evelopers.unimod.core.ModelElement;
import com.evelopers.unimod.core.stateworks.Association;
import com.evelopers.unimod.resources.Messages;
import java.util.ArrayList;
import java.util.List;

public abstract class ClassElement
extends ModelElement {
    public static final String IMPL_NAME_PROPERTY = "IMPL_NAME_PROPERTY";
    public static final String OUTGOING_ASSOCIATIONS_PROPERTY = "OUTGOING_ASSOCIATIONS_PROPERTY";
    public static final String INCOMING_ASSOCIATIONS_PROPERTY = "INCOMING_ASSOCIATIONS_PROPERTY";
    protected List outgoingAssociations = new ArrayList();
    protected List incomingAssociations = new ArrayList();
    protected String implName;

    ClassElement(String name, String stereotype) {
        super(name, stereotype);
    }

    public String getImplName() {
        return this.implName;
    }

    protected void setImplName(String implName) {
        String oldName = this.getImplName();
        if (oldName != null && !oldName.equals(implName) || implName != null) {
            this.implName = implName;
            this.firePropertyChange(IMPL_NAME_PROPERTY, oldName, implName);
        }
    }

    protected void addOutgoingAssociation(Association association) {
        if (association == null) {
            throw new IllegalArgumentException(Messages.getMessages().getMessage("E27"));
        }
        if (this.outgoingAssociations.add(association)) {
            this.firePropertyChange(OUTGOING_ASSOCIATIONS_PROPERTY, null, association);
        }
    }

    protected void removeOutgoingAssociation(Association association) {
        if (this.outgoingAssociations.contains(association)) {
            this.outgoingAssociations.remove(association);
            this.firePropertyChange(OUTGOING_ASSOCIATIONS_PROPERTY, association, null);
        }
    }

    protected void addIncomingAssociation(Association association) {
        if (association == null) {
            throw new IllegalArgumentException(Messages.getMessages().getMessage("E27"));
        }
        if (this.incomingAssociations.add(association)) {
            this.firePropertyChange(INCOMING_ASSOCIATIONS_PROPERTY, null, association);
        }
    }

    protected void removeIncomingAssociation(Association association) {
        if (this.incomingAssociations.contains(association)) {
            this.incomingAssociations.remove(association);
            this.firePropertyChange(INCOMING_ASSOCIATIONS_PROPERTY, association, null);
        }
    }

    public List getOutgoingAssociations() {
        return this.outgoingAssociations;
    }

    public List getIncomingAssociations() {
        return this.incomingAssociations;
    }

    public int hashCode() {
        int h = 0;
        h = this.name == null ? h : this.name.hashCode();
        h = this.getImplName() == null ? h : h ^ this.getImplName().hashCode();
        return h;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClassElement)) {
            return false;
        }
        return this.name != null && this.name.equals(((ClassElement)o).getName()) && this.getImplName() != null && this.name.equals(((ClassElement)o).getImplName());
    }

    public String toString() {
        return String.valueOf(this.getName()) + ": " + this.getImplName();
    }
}

