/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.core.stateworks;

import com.evelopers.unimod.core.ModelElement;
import com.evelopers.unimod.core.ModelVisitor;
import com.evelopers.unimod.core.VisitorException;
import com.evelopers.unimod.core.stateworks.Action;
import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.core.stateworks.Guard;
import com.evelopers.unimod.core.stateworks.StateMachine;
import com.evelopers.unimod.core.stateworks.StateType;
import com.evelopers.unimod.core.stateworks.Transition;
import com.evelopers.unimod.resources.Messages;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class State
extends ModelElement {
    public static final String STATE_TYPE_PROPERTY = "STATE_TYPE_PROPERTY";
    public static final String OUTGOING_TRANSITIONS_PROPERTY = "OUTGOING_TRANSITIONS_PROPERTY";
    public static final String INCOMING_TRANSITIONS_PROPERTY = "INCOMING_TRANSITIONS_PROPERTY";
    public static final String SUBSTATES_PROPERTY = "SUBSTATES_PROPERTY";
    public static final String SUBMACHINES_PROPERTY = "SUBMACHINES_PROPERTY";
    public static final String ON_ENTER_ACTIONS_PROPERTY = "ON_ENTER_ACTIONS_PROPERTY";
    protected StateType type;
    protected State superstate;
    protected List outgoingTransitions = new ArrayList();
    protected List incomingTransitions = new ArrayList();
    protected List substates = new ArrayList();
    protected List submachines = new ArrayList();
    protected List onEnterActions = new ArrayList();
    private static final long serialVersionUID = 4061653607833892876L;

    protected State(String name, StateType type) {
        super(name);
        if (type == null) {
            throw new IllegalArgumentException("State type can not be null.");
        }
        this.type = type;
    }

    public State getSuperstate() {
        return this.superstate;
    }

    public void setSuperstate(State superstate) {
        this.superstate = superstate;
        if (superstate != null) {
            superstate.addSubstate(this);
        }
    }

    public List getOutgoingTransitions() {
        return this.outgoingTransitions;
    }

    public List getIncomingTransitions() {
        return this.incomingTransitions;
    }

    public List getFilteredOutgoingTransitions(Event event, boolean elseGuard) {
        LinkedList<Transition> transitions = new LinkedList<Transition>();
        Iterator i = this.getOutgoingTransitions().iterator();
        while (i.hasNext()) {
            Transition transition = (Transition)i.next();
            Event _event = transition.getEvent();
            boolean _elseGuard = transition.getGuard().equals(Guard.ELSE);
            if (!_event.equals(event) || _elseGuard != elseGuard) continue;
            transitions.add(transition);
        }
        return transitions;
    }

    void addOutgoingTransition(Transition transition) {
        if (transition == null) {
            throw new IllegalArgumentException(Messages.getMessages().getMessage("E3"));
        }
        this.outgoingTransitions.add(transition);
        this.firePropertyChange(OUTGOING_TRANSITIONS_PROPERTY, null, transition);
    }

    void removeOutgoingTransition(Transition transition) {
        if (transition == null) {
            throw new IllegalArgumentException(Messages.getMessages().getMessage("E3"));
        }
        this.outgoingTransitions.remove(transition);
        this.firePropertyChange(OUTGOING_TRANSITIONS_PROPERTY, transition, null);
    }

    void addIncomingTransition(Transition transition) {
        if (transition == null) {
            throw new IllegalArgumentException(Messages.getMessages().getMessage("E3"));
        }
        this.incomingTransitions.add(transition);
        this.firePropertyChange(INCOMING_TRANSITIONS_PROPERTY, null, transition);
    }

    void removeIncomingTransition(Transition transition) {
        if (transition == null) {
            throw new IllegalArgumentException(Messages.getMessages().getMessage("E3"));
        }
        this.incomingTransitions.remove(transition);
        this.firePropertyChange(INCOMING_TRANSITIONS_PROPERTY, transition, null);
    }

    public StateType getType() {
        return this.type;
    }

    public void addSubstate(State substate) {
        this.substates.add(substate);
        if (substate.getSuperstate() != this) {
            substate.superstate = this;
        }
        this.firePropertyChange(SUBSTATES_PROPERTY, null, substate);
    }

    public void removeSubstate(State substate) {
        if (substate.getSuperstate() != this) {
            throw new IllegalStateException("Given state is not substate of state is being called.");
        }
        this.substates.remove(substate);
        substate.setSuperstate(null);
        this.firePropertyChange(SUBSTATES_PROPERTY, substate, null);
    }

    public State getInitialSubstate() {
        if (this.isComposite()) {
            Iterator i = this.substates.iterator();
            while (i.hasNext()) {
                State current = (State)i.next();
                if (!current.getType().equals(StateType.INITIAL)) continue;
                return current;
            }
        }
        return null;
    }

    public List getSubstates() {
        return this.substates;
    }

    public boolean isComposite() {
        return this.substates.size() != 0;
    }

    public boolean isTop() {
        return this.getSuperstate() == null;
    }

    public boolean hasSuperstate() {
        return this.getSuperstate() != null;
    }

    public List getEvents(boolean any) {
        Serializable e;
        HashSet<Serializable> events = new HashSet<Serializable>();
        Iterator trans = this.outgoingTransitions.iterator();
        boolean wasAny = false;
        while (trans.hasNext()) {
            e = ((Transition)trans.next()).getEvent();
            if (e != null && !((Event)e).equals(Event.ANY)) {
                events.add(e);
            }
            if (!((Event)e).equals(Event.ANY)) continue;
            wasAny = true;
        }
        e = new ArrayList(events);
        if (wasAny && any) {
            e.add(Event.ANY);
        }
        return e;
    }

    public List getSubmachines() {
        return this.submachines;
    }

    public void addSubmachine(StateMachine sm) {
        this.submachines.add(sm);
        this.firePropertyChange(SUBMACHINES_PROPERTY, null, sm);
    }

    public void removeSubmachine(StateMachine sm) {
        this.submachines.remove(sm);
        this.firePropertyChange(SUBMACHINES_PROPERTY, sm, null);
    }

    public List getOnEnterActions() {
        return this.onEnterActions;
    }

    public void addOnEnterAction(Action action) {
        this.onEnterActions.add(action);
        this.firePropertyChange(ON_ENTER_ACTIONS_PROPERTY, null, action);
    }

    public void removeOnEnterAction(Action action) {
        this.onEnterActions.remove(action);
        this.firePropertyChange(ON_ENTER_ACTIONS_PROPERTY, action, null);
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof State)) {
            return false;
        }
        return this.name != null && this.name.equals(((State)o).getName());
    }

    public void accept(ModelVisitor v) throws VisitorException {
        if (v.visit(this)) {
            Iterator i = this.substates.iterator();
            while (i.hasNext()) {
                ((State)i.next()).accept(v);
            }
        }
    }
}

