/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.core.stateworks;

import com.evelopers.unimod.core.stateworks.Action;
import com.evelopers.unimod.core.stateworks.Association;
import com.evelopers.unimod.core.stateworks.ClassElement;
import com.evelopers.unimod.core.stateworks.ControlledObjectHandler;
import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.core.stateworks.EventProviderHandler;
import com.evelopers.unimod.core.stateworks.Guard;
import com.evelopers.unimod.core.stateworks.State;
import com.evelopers.unimod.core.stateworks.StateType;
import com.evelopers.unimod.core.stateworks.Transition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StateMachine
extends ClassElement {
    public static final String STATEMACHINE_STEREOTYPE = "statemachine";
    public static final String TOP_STATE_PROPERTY = "TOP_STATE_PROPERTY";
    protected State topState = null;
    private Map actionPool = new HashMap();
    private static final long serialVersionUID = 2280358399729680579L;

    protected StateMachine(String name) {
        super(name, STATEMACHINE_STEREOTYPE);
        this.setImplName(null);
    }

    protected StateMachine(String name, String configStoreClassName) {
        this(name);
        this.setImplName(configStoreClassName);
    }

    public State getTop() {
        return this.topState;
    }

    public void setTop(State top) {
        State oldTop = this.topState;
        this.topState = top;
        this.firePropertyChange(TOP_STATE_PROPERTY, oldTop, top);
    }

    public String getConfigManagerClassName() {
        return this.getImplName();
    }

    public void setConfigManagerClassName(String configManagerClassName) {
        this.setImplName(configManagerClassName);
    }

    protected void addOutgoingAssociation(Association association) {
        if (association == null || association.getSource() != this || !(association.getTarget() instanceof ControlledObjectHandler) && (!(association.getTarget() instanceof StateMachine) || association.getTarget() == this)) {
            throw new IllegalArgumentException("Incorrect outgoing association");
        }
        super.addOutgoingAssociation(association);
    }

    protected void addIncomingAssociation(Association association) {
        if (association == null || association.getTarget() != this || !(association.getSource() instanceof EventProviderHandler) && (!(association.getSource() instanceof StateMachine) || association.getSource() == this)) {
            throw new IllegalArgumentException("Incorrect incoming association");
        }
        super.addIncomingAssociation(association);
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof StateMachine)) {
            return false;
        }
        return this.name != null && this.name.equals(((StateMachine)o).getName());
    }

    public String toString() {
        return this.name;
    }

    public void addContolledObjectHandler(ControlledObjectHandler controlledObjectHandler) {
        this.createOutgoingAssociation(controlledObjectHandler);
    }

    public void addStateMachine(StateMachine sm) {
        this.createOutgoingAssociation(sm);
    }

    public void removeControlledObjectHandler(ControlledObjectHandler controlledObjectHandler) {
        Association association;
        LinkedList<Association> associationsToRemove = new LinkedList<Association>();
        Iterator i = this.outgoingAssociations.iterator();
        while (i.hasNext()) {
            association = (Association)i.next();
            if (!association.getTarget().equals(controlledObjectHandler)) continue;
            associationsToRemove.add(association);
        }
        i = associationsToRemove.iterator();
        while (i.hasNext()) {
            association = (Association)i.next();
            association.reconnect(null, null);
        }
    }

    public List getControlledObjectHandlers() {
        LinkedList<ClassElement> controlledObjects = new LinkedList<ClassElement>();
        Iterator i = this.outgoingAssociations.iterator();
        while (i.hasNext()) {
            Association association = (Association)i.next();
            if (!(association.getTarget() instanceof ControlledObjectHandler)) continue;
            controlledObjects.add(association.getTarget());
        }
        return controlledObjects;
    }

    public List getStateMachines() {
        LinkedList<ClassElement> sms = new LinkedList<ClassElement>();
        Iterator i = this.outgoingAssociations.iterator();
        while (i.hasNext()) {
            Association association = (Association)i.next();
            if (!(association.getTarget() instanceof StateMachine)) continue;
            sms.add(association.getTarget());
        }
        return sms;
    }

    public List getEventProviderHandlers() {
        LinkedList<ClassElement> eventProviders = new LinkedList<ClassElement>();
        Iterator i = this.incomingAssociations.iterator();
        while (i.hasNext()) {
            Association association = (Association)i.next();
            if (!(association.getSource() instanceof EventProviderHandler)) continue;
            eventProviders.add(association.getSource());
        }
        return eventProviders;
    }

    public ControlledObjectHandler getControlledObjectHandler(String objectName) {
        if (objectName != null) {
            Iterator i = this.outgoingAssociations.iterator();
            while (i.hasNext()) {
                Association association = (Association)i.next();
                if (!(association.getTarget() instanceof ControlledObjectHandler) || !objectName.equals(association.getSupplierRole())) continue;
                return (ControlledObjectHandler)association.getTarget();
            }
        }
        return null;
    }

    public StateMachine getStateMachine(String smName) {
        if (smName != null) {
            Iterator i = this.outgoingAssociations.iterator();
            while (i.hasNext()) {
                Association association = (Association)i.next();
                if (!(association.getTarget() instanceof StateMachine) || !smName.equals(association.getSupplierRole())) continue;
                return (StateMachine)association.getTarget();
            }
        }
        return null;
    }

    public ClassElement getClassElement(String name) {
        if (name != null) {
            Iterator i = this.outgoingAssociations.iterator();
            while (i.hasNext()) {
                Association association = (Association)i.next();
                if (!name.equals(association.getSupplierRole())) continue;
                return association.getTarget();
            }
        }
        return null;
    }

    public Set getSubmachines() {
        HashSet subMachines = new HashSet();
        Iterator i = this.getAllStates().iterator();
        while (i.hasNext()) {
            State s = (State)i.next();
            subMachines.addAll(s.getSubmachines());
        }
        return subMachines;
    }

    public List getAllStates() {
        return this.getAllStates(this.getTop());
    }

    protected List getAllStates(State root) {
        ArrayList<State> content = new ArrayList<State>();
        content.add(root);
        if (root.isComposite()) {
            Iterator iSubstates = root.getSubstates().iterator();
            while (iSubstates.hasNext()) {
                content.addAll(this.getAllStates((State)iSubstates.next()));
            }
        }
        return content;
    }

    public List getAllTransition() {
        ArrayList allTransitions = new ArrayList();
        List allStates = this.getAllStates();
        Iterator iSates = allStates.iterator();
        while (iSates.hasNext()) {
            Iterator iTrans = ((State)iSates.next()).getOutgoingTransitions().iterator();
            while (iTrans.hasNext()) {
                allTransitions.add(iTrans.next());
            }
        }
        return allTransitions;
    }

    public State findState(String name) {
        List l = this.getAllStates();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            State state = (State)i.next();
            if (!state.getName().equals(name)) continue;
            return state;
        }
        return null;
    }

    public StateMachine findSubmachine(String name) {
        if (this.getName().equals(name)) {
            return this;
        }
        List l = this.getAllStates();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            State state = (State)i.next();
            Iterator j = state.getSubmachines().iterator();
            while (j.hasNext()) {
                StateMachine sm = (StateMachine)j.next();
                if (!sm.getName().equals(name)) continue;
                return sm;
            }
        }
        return null;
    }

    public State createState(String name, StateType type) {
        return new State(name, type);
    }

    public State createTopState(String name) {
        return this.createState(name, StateType.NORMAL);
    }

    public Transition createTransition(State sourceState, State targetState, Guard guard, Event event) {
        return new Transition(sourceState, targetState, guard, event);
    }

    public Guard createGuard(String expr) {
        return new Guard(expr);
    }

    public Association createOutgoingAssociation(ClassElement supplier, String supplierRole, String clientRole) {
        return new Association(this, supplierRole, supplier, clientRole);
    }

    public final Association createOutgoingAssociation(ClassElement supplier, String supplierRole) {
        return this.createOutgoingAssociation(supplier, supplierRole, null);
    }

    public final Association createOutgoingAssociation(ClassElement supplier) {
        return this.createOutgoingAssociation(supplier, null);
    }

    public Association createIncomingAssociation(ClassElement client, String supplierRole, String clientRole) {
        return new Association(client, supplierRole, this, clientRole);
    }

    public final Association createIncomingAssociation(ClassElement client, String clientRole) {
        return this.createIncomingAssociation(client, null, clientRole);
    }

    public final Association createIncomingAssociation(ClassElement client) {
        return this.createIncomingAssociation(client, null);
    }

    public synchronized Action createAction(String identifier) {
        Action a = (Action)this.actionPool.get(identifier);
        if (a == null) {
            a = new Action(identifier);
            this.actionPool.put(identifier, a);
        }
        return a;
    }
}

