/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.debug.app;

import com.evelopers.common.exception.SystemException;
import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.debug.protocol.CommandMessage;
import com.evelopers.unimod.debug.protocol.EventMessage;
import com.evelopers.unimod.debug.protocol.Message;
import com.evelopers.unimod.debug.protocol.MessageCoder;
import com.evelopers.unimod.debug.protocol.MessageCoderException;
import com.evelopers.unimod.debug.protocol.ThreadInfo;
import com.evelopers.unimod.debug.protocol.position.Position;
import com.evelopers.unimod.runtime.ControlledObject;
import com.evelopers.unimod.runtime.EventManager;
import com.evelopers.unimod.runtime.EventProvider;
import com.evelopers.unimod.runtime.ModelEngine;
import com.evelopers.unimod.runtime.context.Parameter;
import com.evelopers.unimod.runtime.context.StateMachineContext;
import com.evelopers.unimod.runtime.context.StateMachineContextImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class AppConnector
implements ControlledObject,
EventProvider {
    public static final String E1 = "e1";
    public static final String E2 = "e2";
    public static final String E3 = "e3";
    public static final String E4 = "e4";
    public static final String E5 = "e5";
    public static final String E6 = "e6";
    public static final String E7 = "e7";
    public static final String E8 = "e8";
    public static final String E9 = "e9";
    private int port;
    private MessageCoder coder;
    private ServerSocket socket;
    private OutputStream socketWriter;
    private InputStream socketReader;
    private EventManager handler;

    AppConnector(int port, MessageCoder coder) {
        this.port = port;
        this.coder = coder;
    }

    public void init(ModelEngine engine) throws SystemException {
        this.handler = engine.getEventManager();
        try {
            this.socket = new ServerSocket(this.port);
        }
        catch (IOException e) {
            throw new SystemException((Throwable)e);
        }
    }

    public void dispose() {
        if (this.socketReader == null) {
            return;
        }
        try {
            InputStream is = this.socketReader;
            this.socketReader = null;
            is.close();
            this.socket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void z0(StateMachineContext context) throws MessageCoderException, IOException {
        new SocketListenerThread().start();
    }

    public void z1(StateMachineContext context) throws MessageCoderException, IOException {
        Position b = (Position)context.getEventContext().getParameter("POSITION");
        ThreadInfo ti = (ThreadInfo)context.getEventContext().getParameter("THREAD_INFO");
        this.sendMessage(EventMessage.createSuspendedOnBreakpoint(b, ti));
    }

    public void z2(StateMachineContext context) throws MessageCoderException, IOException {
        Position p = (Position)context.getEventContext().getParameter("POSITION");
        ThreadInfo ti = (ThreadInfo)context.getEventContext().getParameter("THREAD_INFO");
        this.sendMessage(EventMessage.createSuspendedOnStep(p, ti));
    }

    public void z3(StateMachineContext context) throws MessageCoderException, IOException {
        ThreadInfo ti = (ThreadInfo)context.getEventContext().getParameter("THREAD_INFO");
        this.sendMessage(EventMessage.createResumed(ti));
    }

    public void z4(StateMachineContext context) throws MessageCoderException, IOException {
        MessageCoderException e = (MessageCoderException)((Object)context.getEventContext().getParameter("MESSAGE_CODER_EXCEPTION"));
        this.sendMessage(EventMessage.createUnknownCommand(String.valueOf(e.getChainedMessage()) + "\n" + e.getChainedTrace()));
    }

    public void z5(StateMachineContext context) throws MessageCoderException, IOException {
        ThreadInfo ti = (ThreadInfo)context.getEventContext().getParameter("THREAD_INFO");
        if (ti != null) {
            this.sendMessage(EventMessage.createCreated(ti));
        }
    }

    public void z6(StateMachineContext context) throws MessageCoderException, IOException {
        ThreadInfo ti = (ThreadInfo)context.getEventContext().getParameter("THREAD_INFO");
        ThreadInfo[] suspenedThreads = (ThreadInfo[])context.getEventContext().getParameter("SUSPENED_THREADS");
        String info = (String)context.getEventContext().getParameter("INFO");
        this.sendMessage(EventMessage.createCantUpdateModel(ti, info, suspenedThreads));
    }

    private void sendMessage(Message m) throws MessageCoderException, IOException {
        this.coder.encode(m, this.socketWriter);
        this.socketWriter.flush();
    }

    private class SocketListenerThread
    extends Thread {
        SocketListenerThread() {
            super("AppDebugger.SocketListenerThread");
            this.setDaemon(true);
        }

        public void run() {
            while (true) {
                Socket client = null;
                try {
                    client = AppConnector.this.socket.accept();
                    AppConnector.this.socketWriter = client.getOutputStream();
                    AppConnector.this.socketReader = client.getInputStream();
                    AppConnector.this.handler.handle(new Event(AppConnector.E1), StateMachineContextImpl.create());
                    while (true) {
                        CommandMessage m = null;
                        try {
                            m = (CommandMessage)AppConnector.this.coder.decode(AppConnector.this.socketReader);
                        }
                        catch (MessageCoderException e) {
                            if (e.getParentException() instanceof IOException) {
                                throw (IOException)e.getParentException();
                            }
                            AppConnector.this.handler.handle(new Event(AppConnector.E7, new Parameter("MESSAGE_CODER_EXCEPTION", (Object)e)), StateMachineContextImpl.create());
                            continue;
                        }
                        switch (m.getType()) {
                            case 1: {
                                AppConnector.this.handler.handle(new Event(AppConnector.E2, new Parameter("BREAKPOINTS", m.getBreapoints())), StateMachineContextImpl.create());
                                break;
                            }
                            case 2: {
                                AppConnector.this.handler.handle(new Event(AppConnector.E3, new Parameter("BREAKPOINTS", m.getBreapoints())), StateMachineContextImpl.create());
                                break;
                            }
                            case 3: {
                                AppConnector.this.handler.handle(new Event(AppConnector.E4, new Parameter("THREAD_INFO", m.getThreadInfo())), StateMachineContextImpl.create());
                                break;
                            }
                            case 4: {
                                AppConnector.this.handler.handle(new Event(AppConnector.E5, new Parameter("THREAD_INFO", m.getThreadInfo())), StateMachineContextImpl.create());
                                break;
                            }
                            case 5: {
                                AppConnector.this.handler.handle(new Event(AppConnector.E9, new Parameter("NEW_MODEL", m.getNewModel())), StateMachineContextImpl.create());
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    if (AppConnector.this.socketReader == null) {
                        return;
                    }
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Exception exception) {}
                    }
                    AppConnector.this.handler.handle(new Event(AppConnector.E6), StateMachineContextImpl.create());
                    continue;
                }
                break;
            }
        }
    }
}

