/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.debug.debugger;

import com.evelopers.common.exception.CommonException;
import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.core.stateworks.Model;
import com.evelopers.unimod.debug.ExceptionHandlerImpl;
import com.evelopers.unimod.debug.debugger.BreakpointManager;
import com.evelopers.unimod.debug.debugger.DebuggerConnector;
import com.evelopers.unimod.debug.debugger.UIManager;
import com.evelopers.unimod.debug.protocol.MessageCoder;
import com.evelopers.unimod.runtime.AbstractEventProcessorListener;
import com.evelopers.unimod.runtime.ControlledObject;
import com.evelopers.unimod.runtime.ControlledObjectsMap;
import com.evelopers.unimod.runtime.ModelEngine;
import com.evelopers.unimod.runtime.StateMachineConfig;
import com.evelopers.unimod.runtime.StateMachinePath;
import com.evelopers.unimod.runtime.context.StateMachineContext;
import com.evelopers.unimod.runtime.context.StateMachineContextImpl;
import com.evelopers.unimod.runtime.interpretation.InterpretationHelper;
import com.evelopers.unimod.runtime.logger.ShortLogger;
import com.evelopers.unimod.transform.xml.XMLToModel;
import java.io.IOException;
import org.apache.commons.logging.LogFactory;

public class Debugger {
    public static final String RESUMED = "Resumed";
    public static final String SUSPENDED = "Suspended";
    public static final String TERMINATED = "s2";
    private ModelEngine engine;
    private Model model;
    private DebuggerConnector connector;
    private UIManager uiManager;
    private BreakpointManager breakpointManager;

    public Debugger(String hostName, int port, MessageCoder coder, BreakpointManager breakpoint, UIManager ui) throws CommonException, IOException {
        this.breakpointManager = breakpoint;
        this.uiManager = ui;
        this.model = XMLToModel.loadAndCompile(this.getClass().getResourceAsStream("debugger.xml"));
        this.connector = new DebuggerConnector(hostName, port, coder);
        this.engine = InterpretationHelper.getInstance().createBuildInModelEngine(this.model, new ControlledObjectsMap(){

            public ControlledObject getControlledObject(String coName) {
                if (coName.equals("o1")) {
                    return Debugger.this.connector;
                }
                if (coName.equals("o2")) {
                    return Debugger.this.uiManager;
                }
                if (coName.equals("o3")) {
                    return Debugger.this.breakpointManager;
                }
                throw new IllegalArgumentException("Unknown controlled object [" + coName + "]");
            }
        }, true);
        this.engine.getEventProcessor().addExceptionHandler(new ExceptionHandlerImpl());
        this.engine.getEventProcessor().addEventProcessorListener(new AbstractEventProcessorListener(){

            public void stateMachineCameToFinalState(StateMachineContext context, StateMachinePath path, StateMachineConfig config) {
                if (path.isRoot()) {
                    Debugger.this.disposeEventProviders();
                }
            }
        });
        if (LogFactory.getLog(this.getClass()).isDebugEnabled()) {
            this.engine.getEventProcessor().addEventProcessorListener(new ShortLogger(LogFactory.getLog(this.getClass())));
        }
    }

    public void start() throws CommonException {
        this.connector.init(this.engine);
        this.uiManager.init(this.engine);
        this.breakpointManager.init(this.engine);
        this.engine.getEventManager().handle(new Event("e0"), StateMachineContextImpl.create());
    }

    protected void disposeEventProviders() {
        this.connector.dispose();
        this.breakpointManager.dispose();
        this.uiManager.dispose();
    }

    public void stop() {
        this.disposeEventProviders();
        this.engine.getEventManager().dispose();
    }
}

