/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.debug.debugger.console;

import com.evelopers.common.exception.CommonException;
import com.evelopers.common.util.helper.StringHelper;
import com.evelopers.unimod.contract.CoreContract;
import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.core.stateworks.Model;
import com.evelopers.unimod.core.stateworks.StateMachine;
import com.evelopers.unimod.core.stateworks.Transition;
import com.evelopers.unimod.debug.debugger.UIManager;
import com.evelopers.unimod.debug.protocol.position.Position;
import com.evelopers.unimod.debug.protocol.position.TransitionCandidatePosition;
import com.evelopers.unimod.runtime.EventManager;
import com.evelopers.unimod.runtime.ModelEngine;
import com.evelopers.unimod.runtime.StateMachinePath;
import com.evelopers.unimod.runtime.context.Parameter;
import com.evelopers.unimod.runtime.context.StateMachineContext;
import com.evelopers.unimod.runtime.context.StateMachineContextImpl;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;

public class ConsoleManager
implements UIManager {
    private boolean inited = false;
    private EventManager handler;
    private Thread kb;
    private Model model;
    private Position[] positions;
    private static String[][] COMMANDS = new String[][]{{"add", "e21"}, {"remove", "e22"}, {"step", "e23"}, {"resume", "e24"}, {"disconnect", "e25"}, {"close", "e26"}};

    ConsoleManager(Model model) {
        this.model = model;
        this.initPositions();
    }

    private void initPositions() {
        ArrayList<TransitionCandidatePosition> p = new ArrayList<TransitionCandidatePosition>();
        Iterator iter = this.model.getStateMachines().iterator();
        while (iter.hasNext()) {
            StateMachine sm = (StateMachine)iter.next();
            Iterator iterator = sm.getAllTransition().iterator();
            while (iterator.hasNext()) {
                Transition t = (Transition)iterator.next();
                p.add(new TransitionCandidatePosition(null, new StateMachinePath(CoreContract.encode(sm)), t.getEvent(), CoreContract.encode(t.getSourceState()), CoreContract.encode(t)));
            }
        }
        this.positions = p.toArray(new Position[p.size()]);
    }

    public void z1(StateMachineContext context) throws CommonException {
        Position p = (Position)context.getEventContext().getParameter("POSITION");
        System.out.println("Suspended on breakpoint: ");
        System.out.println(p);
    }

    public void z2(StateMachineContext context) throws CommonException {
        Position p = (Position)context.getEventContext().getParameter("POSITION");
        System.out.println("Suspended on step: ");
        System.out.println(p);
    }

    public void z3(StateMachineContext context) throws CommonException {
        System.out.println("App resumed");
    }

    public void z4(StateMachineContext context) throws CommonException {
        System.out.println("App has closed connection");
    }

    public void z5(StateMachineContext context) throws CommonException {
        System.out.println("App has sent unknown message");
    }

    public void z6(StateMachineContext context) throws CommonException {
        System.out.println("App has received unknown command from debugger");
    }

    public void z7(StateMachineContext context) throws CommonException {
        System.out.println("New thread created");
    }

    public void z8(StateMachineContext context) throws CommonException {
        System.out.println("Can't update model in debugged engine");
    }

    public void init(ModelEngine engine) throws CommonException {
        if (this.inited) {
            return;
        }
        this.inited = true;
        this.handler = engine.getEventManager();
        this.kb = new ConsoleThread();
        this.kb.start();
    }

    public void dispose() {
        this.kb.interrupt();
    }

    private String getEvent(String command) {
        int i = 0;
        while (i < COMMANDS.length) {
            if (COMMANDS[i][0].equalsIgnoreCase(command)) {
                return COMMANDS[i][1];
            }
            ++i;
        }
        return null;
    }

    private void printHelp() {
        System.out.println("Unknown command. Possible commands are:");
        int i = 0;
        while (i < COMMANDS.length) {
            System.out.println(COMMANDS[i][0]);
            ++i;
        }
    }

    private void printPosiiblePositions() {
        int i = 0;
        while (i < this.positions.length) {
            System.out.println(String.valueOf(i) + ":" + this.positions[i]);
            ++i;
        }
    }

    private Position parsePosition(String s) {
        return this.positions[Integer.parseInt(s)];
    }

    private class ConsoleThread
    extends Thread {
        ConsoleThread() {
            super("ConsoleDebugger.ConsoleThread");
        }

        public void run() {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            while (!this.isInterrupted()) {
                try {
                    System.out.print("unimod> ");
                    while (!br.ready()) {
                        Thread.sleep(10L);
                    }
                    if (this.isInterrupted()) {
                        return;
                    }
                    String s = br.readLine();
                    String[] s1 = StringHelper.splitString((String)s, (String)" ");
                    String event = ConsoleManager.this.getEvent(s1[0]);
                    if (event == null) {
                        ConsoleManager.this.printHelp();
                        ConsoleManager.this.printPosiiblePositions();
                        continue;
                    }
                    if (event.equals("e21") || event.equals("e22")) {
                        Position p = ConsoleManager.this.parsePosition(s1[1]);
                        ConsoleManager.this.handler.handle(new Event(event, new Parameter("BREAKPOINTS", new Position[]{p})), StateMachineContextImpl.create());
                        continue;
                    }
                    ConsoleManager.this.handler.handle(new Event(event), StateMachineContextImpl.create());
                }
                catch (Exception exception) {
                    return;
                }
            }
        }
    }
}

