/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.debug.protocol;

import com.evelopers.unimod.debug.protocol.Message;
import com.evelopers.unimod.debug.protocol.ThreadInfo;
import com.evelopers.unimod.debug.protocol.position.Position;

public class EventMessage
extends Message {
    public static final int THREAD_CREATED = 0;
    public static final int SUSPENDED_ON_BREAKPOINT = 1;
    public static final int SUSPENDED_ON_STEP = 2;
    public static final int RESUMED = 3;
    public static final int UNKNOWN_COMMAND = 4;
    public static final int CANT_UPDATE_MODEL = 5;
    private Position position;
    private String info;
    private ThreadInfo[] suspendedThreads;

    private EventMessage(int type, Position position, ThreadInfo thread) {
        super(type, thread);
        this.position = position;
    }

    private EventMessage(int type, Position position, ThreadInfo thread, String info) {
        this(type, position, thread);
        this.info = info;
    }

    private EventMessage(int type, Position position, ThreadInfo thread, String info, ThreadInfo[] suspendedThreads) {
        this(type, position, thread, info);
        this.suspendedThreads = suspendedThreads;
    }

    public static EventMessage createSuspendedOnBreakpoint(Position position, ThreadInfo thread) {
        return new EventMessage(1, position, thread);
    }

    public static EventMessage createSuspendedOnStep(Position position, ThreadInfo thread) {
        return new EventMessage(2, position, thread);
    }

    public static EventMessage createCreated(ThreadInfo thread) {
        return new EventMessage(0, null, thread);
    }

    public static EventMessage createResumed(ThreadInfo thread) {
        return new EventMessage(3, null, thread);
    }

    public static EventMessage createUnknownCommand(String info) {
        return new EventMessage(4, null, null, info);
    }

    public static EventMessage createCantUpdateModel(ThreadInfo thread, String info, ThreadInfo[] suspenedThreads) {
        return new EventMessage(5, null, null, info, suspenedThreads);
    }

    public Position getPosition() {
        return this.position;
    }

    public String getInfo() {
        return this.info;
    }

    public ThreadInfo[] getSuspendedThreads() {
        return this.suspendedThreads;
    }
}

