/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.runtime.interpretation;

import com.evelopers.unimod.contract.CoreContract;
import com.evelopers.unimod.core.stateworks.Model;
import com.evelopers.unimod.core.stateworks.State;
import com.evelopers.unimod.core.stateworks.StateMachine;
import com.evelopers.unimod.core.stateworks.StateType;
import com.evelopers.unimod.runtime.EventProcessorException;
import com.evelopers.unimod.runtime.ModelStructure;
import com.evelopers.unimod.runtime.StateMachineConfig;
import com.evelopers.unimod.runtime.StateMachineConfigManager;
import com.evelopers.unimod.runtime.StateMachinePath;
import com.evelopers.unimod.runtime.interpretation.InstantiateHelper;
import java.util.HashMap;
import java.util.Map;

class InterpretationModelStructure
implements ModelStructure {
    private Model model;
    private Map stateMachineConfigManagers;

    public InterpretationModelStructure(Model model) {
        this.setModel(model);
        this.stateMachineConfigManagers = new HashMap();
    }

    void setModel(Model model) {
        this.model = model;
    }

    public StateMachinePath getRootPath() {
        return new StateMachinePath(CoreContract.encode(this.model.getRootStateMachine()));
    }

    public StateMachineConfigManager getConfigManager(String stateMachineName) throws EventProcessorException {
        StateMachine stateMachine = CoreContract.decodeStateMachine(this.model, stateMachineName);
        StateMachineConfigManager configManager = (StateMachineConfigManager)this.stateMachineConfigManagers.get(stateMachineName);
        if (configManager == null) {
            String configManagerClassName = stateMachine.getConfigManagerClassName();
            configManager = InstantiateHelper.getStateMachineConfigManager(configManagerClassName);
            this.stateMachineConfigManagers.put(stateMachineName, configManager);
        }
        return configManager;
    }

    public StateMachineConfig getTopConfig(String stateMachine) {
        StateMachine machine = CoreContract.decodeStateMachine(this.model, stateMachine);
        State topState = machine.getTop();
        StateMachineConfig config = new StateMachineConfig(CoreContract.encode(topState));
        return config;
    }

    public boolean isFinal(String stateMachine, StateMachineConfig config) {
        StateMachine machine = CoreContract.decodeStateMachine(this.model, stateMachine);
        State state = CoreContract.decodeState(machine, config.getActiveState());
        return StateType.FINAL.equals(state.getType());
    }

    StateMachine getStateMachine(String stateMachine) {
        return CoreContract.decodeStateMachine(this.model, stateMachine);
    }
}

