/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.runtime.interpretation;

import com.evelopers.common.exception.CommonException;
import com.evelopers.unimod.core.stateworks.ControlledObjectHandler;
import com.evelopers.unimod.core.stateworks.EventProviderHandler;
import com.evelopers.unimod.core.stateworks.Model;
import com.evelopers.unimod.runtime.ControlledObject;
import com.evelopers.unimod.runtime.ControlledObjectsManager;
import com.evelopers.unimod.runtime.EventProcessorException;
import com.evelopers.unimod.runtime.EventProvider;
import com.evelopers.unimod.runtime.EventProvidersManager;
import com.evelopers.unimod.runtime.ModelEngine;
import com.evelopers.unimod.runtime.interpretation.InstantiateHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class InterpretationObjectsManager {
    private Model model;
    private Map objects;
    private ControlledObjectsManager controlledObjectsManager = new ControlledObjectsManagerImpl();
    private EventProvidersManager eventProvidersManager = new EventProvidersManagerImpl();

    public InterpretationObjectsManager(Model model) {
        this.model = model;
        this.objects = new HashMap();
    }

    public ControlledObjectsManager getControlledObjectsManager() {
        return this.controlledObjectsManager;
    }

    public EventProvidersManager getEventProvidersManager() {
        return this.eventProvidersManager;
    }

    private class ControlledObjectsManagerImpl
    implements ControlledObjectsManager {
        private ControlledObjectsManagerImpl() {
        }

        public void init(ModelEngine engine) throws CommonException {
        }

        public void dispose() {
        }

        public ControlledObject getControlledObject(String coName) {
            ControlledObjectHandler handler = InterpretationObjectsManager.this.model.getControlledObjectHandler(coName);
            if (handler == null) {
                throw new IllegalArgumentException("Controlled object with name [" + coName + "] wasn't found");
            }
            ControlledObject controlledObject = (ControlledObject)InterpretationObjectsManager.this.objects.get(handler.getName());
            if (controlledObject == null) {
                try {
                    controlledObject = InstantiateHelper.getControlledObject(handler.getImplName());
                    InterpretationObjectsManager.this.objects.put(handler.getName(), controlledObject);
                }
                catch (EventProcessorException e) {
                    e.printStackTrace();
                }
            }
            return controlledObject;
        }
    }

    private class EventProvidersManagerImpl
    implements EventProvidersManager {
        private Map nonameEventProviders = new HashMap();

        private EventProvidersManagerImpl() {
        }

        public void init(ModelEngine engine) throws CommonException {
            Iterator i = InterpretationObjectsManager.this.model.getEventProviderHandlers().iterator();
            while (i.hasNext()) {
                EventProvider eventProvider;
                EventProviderHandler handler = (EventProviderHandler)i.next();
                String name = handler.getName();
                if (name != null) {
                    eventProvider = this.getEventProvider(name);
                } else {
                    eventProvider = InstantiateHelper.getEventProvider(handler.getImplName());
                    this.nonameEventProviders.put(handler.getImplName(), eventProvider);
                }
                eventProvider.init(engine);
            }
        }

        public void dispose() {
            Iterator i = InterpretationObjectsManager.this.model.getEventProviderHandlers().iterator();
            while (i.hasNext()) {
                EventProviderHandler handler = (EventProviderHandler)i.next();
                String name = handler.getName();
                EventProvider eventProvider = name != null ? this.getEventProvider(name) : (EventProvider)this.nonameEventProviders.get(handler.getImplName());
                eventProvider.dispose();
            }
        }

        public EventProvider getEventProvider(String epName) {
            EventProviderHandler handler = InterpretationObjectsManager.this.model.getEventProviderHandler(epName);
            if (handler == null) {
                throw new IllegalArgumentException("Event provider with name [" + epName + "] wasn't found");
            }
            EventProvider eventProvider = (EventProvider)InterpretationObjectsManager.this.objects.get(handler.getName());
            if (eventProvider == null) {
                try {
                    eventProvider = InstantiateHelper.getEventProvider(handler.getImplName());
                    InterpretationObjectsManager.this.objects.put(handler.getName(), eventProvider);
                }
                catch (EventProcessorException e) {
                    e.printStackTrace();
                }
            }
            return eventProvider;
        }
    }
}

