/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.runtime.logger;

import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.runtime.AbstractEventProcessorListener;
import com.evelopers.unimod.runtime.StateMachineConfig;
import com.evelopers.unimod.runtime.StateMachinePath;
import com.evelopers.unimod.runtime.context.StateMachineContext;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;

public class SimpleLogger
extends AbstractEventProcessorListener {
    private Log log;
    private static final MessageFormat EVENT_PROCESSING_STARTED_MSG = new MessageFormat("Start event [{0}] processing. In state [{1}:{2}]");
    private static final MessageFormat EVENT_PROCESSING_FINISHED_MSG = new MessageFormat("Finish event [{0}] processing. In state [{1}:{2}]");
    private static final MessageFormat STATE_MACHINE_CAME_TO_FINAL_STATE_MSG = new MessageFormat("State machine came to final state [{0}:{1}]");
    private static final MessageFormat BEFORE_SUBMACHINES_EXECUTION_MSG = new MessageFormat("Start state machines included to state [{0}:{1}] execution");
    private static final MessageFormat AFTER_SUBMACHINES_EXECUTION_MSG = new MessageFormat("Finish state machines included to state [{0}:{1}] execution");
    private static final MessageFormat BEFORE_ON_ENTER_ACTION_EXECUTION_MSG = new MessageFormat("Start on-enter action [{0}] execution");
    private static final MessageFormat AFTER_ON_ENTER_ACTION_EXECUTION_MSG = new MessageFormat("Finish on-enter action [{0}] execution");
    private static final MessageFormat BEFORE_OUTPUT_ACTION_EXECUTION_MSG = new MessageFormat("Start output action [{0}] execution");
    private static final MessageFormat AFTER_OUTPUT_ACTION_EXECUTION_MSG = new MessageFormat("Finish output action [{0}] execution");
    private static final MessageFormat BEFORE_INPUT_ACTION_EXECUTION_MSG = new MessageFormat("Start input action [{0}] calculation");
    private static final MessageFormat AFTER_INPUT_ACTION_EXECUTION_MSG = new MessageFormat("Finish input action [{0}] calculation. Its value is [{1}]");
    private static final MessageFormat TRANSITION_CANDIDATE_MSG = new MessageFormat("Try transition [{0}]");
    private static final MessageFormat TRANSITION_FOUND_MSG = new MessageFormat("Transition to go found [{0}]");
    private static final MessageFormat TRANSITION_NOT_FOUND_MSG = new MessageFormat("No transition defined for event [{0}] from state");

    public SimpleLogger(Log log) {
        this.log = log;
    }

    public void eventProcessingStarted(StateMachineContext context, Event e, StateMachinePath path, StateMachineConfig c) {
        this.log.info((Object)EVENT_PROCESSING_STARTED_MSG.format(new Object[]{e, path, c}));
    }

    public void eventProcessingFinished(StateMachineContext context, Event e, StateMachinePath path, StateMachineConfig c) {
        this.log.info((Object)EVENT_PROCESSING_FINISHED_MSG.format(new Object[]{e, path, c}));
    }

    public void stateMachineCameToFinalState(StateMachineContext context, StateMachinePath path, StateMachineConfig config) {
        this.log.info((Object)STATE_MACHINE_CAME_TO_FINAL_STATE_MSG.format(new Object[]{path, config}));
    }

    public void beforeSubmachinesExecution(StateMachineContext context, Event event, StateMachinePath path, String config) {
        this.log.info((Object)BEFORE_SUBMACHINES_EXECUTION_MSG.format(new Object[]{path, config}));
    }

    public void afterSubmachinesExecution(StateMachineContext context, Event event, StateMachinePath path, String state) {
        this.log.info((Object)AFTER_SUBMACHINES_EXECUTION_MSG.format(new Object[]{path, state}));
    }

    public void beforeOnEnterActionExecution(StateMachineContext context, StateMachinePath path, String stateName, String outputAction) {
        this.log.info((Object)BEFORE_ON_ENTER_ACTION_EXECUTION_MSG.format(new Object[]{outputAction}));
    }

    public void afterOnEnterActionExecution(StateMachineContext context, StateMachinePath path, String stateName, String outputAction) {
        this.log.info((Object)AFTER_ON_ENTER_ACTION_EXECUTION_MSG.format(new Object[]{outputAction}));
    }

    public void beforeOutputActionExecution(StateMachineContext context, StateMachinePath path, String transition, String outputAction) {
        this.log.info((Object)BEFORE_OUTPUT_ACTION_EXECUTION_MSG.format(new Object[]{outputAction}));
    }

    public void afterOutputActionExecution(StateMachineContext context, StateMachinePath path, String transition, String outputAction) {
        this.log.info((Object)AFTER_OUTPUT_ACTION_EXECUTION_MSG.format(new Object[]{outputAction}));
    }

    public void beforeInputActionExecution(StateMachineContext context, StateMachinePath path, String transition, String inputAction) {
        this.log.info((Object)BEFORE_INPUT_ACTION_EXECUTION_MSG.format(new Object[]{inputAction}));
    }

    public void afterInputActionExecution(StateMachineContext context, StateMachinePath path, String transition, String inputAction, String value) {
        this.log.info((Object)AFTER_INPUT_ACTION_EXECUTION_MSG.format(new Object[]{inputAction, value}));
    }

    public void transitionCandidate(StateMachineContext context, StateMachinePath path, String state, Event event, String transition) {
        this.log.debug((Object)TRANSITION_CANDIDATE_MSG.format(new Object[]{transition}));
    }

    public void transitionFound(StateMachineContext context, StateMachinePath path, String state, Event event, String transition) {
        this.log.info((Object)TRANSITION_FOUND_MSG.format(new Object[]{transition}));
    }

    public void transitionNotFound(StateMachineContext context, StateMachinePath path, String state, Event event) {
        this.log.error((Object)TRANSITION_NOT_FOUND_MSG.format(new Object[]{event, state}));
    }
}

