/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.transform.source;

import com.evelopers.common.util.helper.StringHelper;
import com.evelopers.unimod.contract.CoreContract;
import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.core.stateworks.Model;
import com.evelopers.unimod.core.stateworks.StateType;
import com.evelopers.unimod.parser.ActionCollector;
import com.evelopers.unimod.parser.Infix;
import com.evelopers.unimod.transform.TransformException;
import com.evelopers.unimod.transform.source.Tool;
import com.evelopers.unimod.transform.xml.XMLToModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.FieldMethodizer;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogSystem;

public class ModelToSource {
    private VelocityEngine ve;
    private LogSystem veloLog;
    private final Log log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private ModelToSource(Log logger) {
        this.log = logger;
        if (this.log != null) {
            this.veloLog = new LogSystem(){

                public void init(RuntimeServices rs) throws Exception {
                }

                public void logVelocityMessage(int level, String message) {
                    switch (level) {
                        case 0: {
                            ModelToSource.this.log.debug((Object)message);
                            break;
                        }
                        case 3: {
                            ModelToSource.this.log.error((Object)message);
                            break;
                        }
                        case 1: {
                            ModelToSource.this.log.info((Object)message);
                            break;
                        }
                        case 2: {
                            ModelToSource.this.log.warn((Object)message);
                        }
                    }
                }
            };
        }
    }

    public static synchronized ModelToSource create(Log log) {
        return new ModelToSource(log);
    }

    private void generate(Template template, Model model, Writer w, Map additionalParameters) throws Exception {
        VelocityContext vc = new VelocityContext();
        Iterator keys = additionalParameters.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            vc.put(key.toString(), additionalParameters.get(key));
        }
        vc.put("model", (Object)model);
        vc.put("coreContract", (Object)CoreContract.create());
        vc.put("tool", (Object)Tool.create());
        vc.put("infix", (Object)new Infix());
        vc.put("stateType", (Object)new FieldMethodizer((Object)StateType.NORMAL));
        vc.put("eventAny", (Object)Event.ANY);
        vc.put("actionCollector", (Object)new ActionCollector());
        vc.put("boolean", (Object)new Boolean(true));
        vc.put("integer", (Object)new Integer(0));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.evelopers.unimod.core.stateworks.ControlledObjectHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        vc.put("controlledObjectHandlerClass", (Object)clazz);
        vc.put("generationTime", (Object)Calendar.getInstance().getTime());
        template.merge((Context)vc, w);
        w.flush();
        w.close();
    }

    private void generate(Template template, Model model, File f, Map additionalParameters) throws Exception {
        if (f.getAbsoluteFile().getParentFile() != null) {
            f.getAbsoluteFile().getParentFile().mkdirs();
        }
        this.generate(template, model, new FileWriter(f), additionalParameters);
    }

    private void initVelocity(String key, String value, ClassLoader classLoader) throws Exception {
        this.ve = new VelocityEngine();
        Properties p = new Properties();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.evelopers.unimod.transform.source.ModelToSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        p.load(clazz.getResourceAsStream("velocity.properties"));
        if (key != null) {
            p.setProperty(key, value);
        }
        if (this.veloLog != null) {
            this.ve.setProperty("runtime.log.logsystem", (Object)this.veloLog);
        }
        ExtendedProperties extendedProperties = ExtendedProperties.convertProperties((Properties)p);
        extendedProperties.addProperty("explicitclass.resource.loader.classloader", (Object)classLoader);
        this.ve.setExtendedProperties(extendedProperties);
        this.ve.init();
    }

    public synchronized void generate(File jarFile, String templateName, Model model, File outputFile, Map additionalParameters) throws TransformException {
        try {
            this.initVelocity("jar.resource.loader.path", "jar:file:" + jarFile.getAbsolutePath(), null);
            Template template = this.ve.getTemplate(templateName);
            this.generate(template, model, outputFile, additionalParameters);
        }
        catch (Exception e) {
            throw new TransformException(e);
        }
    }

    public synchronized void generate(String templateResourceName, Model model, File outputFile, Map additionalParameters, ClassLoader classLoader) throws TransformException {
        try {
            this.initVelocity(null, null, classLoader);
            Template template = this.ve.getTemplate(templateResourceName);
            this.generate(template, model, outputFile, additionalParameters);
        }
        catch (Exception e) {
            throw new TransformException(e);
        }
    }

    public synchronized void generate(String templateResourceName, Model model, Writer w, Map additionalParameters, ClassLoader classLoader) throws TransformException {
        try {
            this.initVelocity(null, null, classLoader);
            Template template = this.ve.getTemplate(templateResourceName);
            this.generate(template, model, w, additionalParameters);
        }
        catch (Exception e) {
            throw new TransformException(e);
        }
    }

    public synchronized void generate(File templateFile, Model model, File outputFile, Map additionalParameters) throws TransformException {
        try {
            this.initVelocity("file.resource.loader.path", templateFile.getParentFile().getAbsolutePath(), null);
            Template template = this.ve.getTemplate(templateFile.getName());
            this.generate(template, model, outputFile, additionalParameters);
        }
        catch (Exception e) {
            throw new TransformException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        File template;
        if (args.length < 3) {
            System.out.println("Usage: ModelToSource <model xml> <template file> <output file> [key=value]*");
            return;
        }
        File model = new File(args[0]);
        if (!model.exists()) {
            System.out.println("Can't find model: " + model);
        }
        if (!(template = new File(args[1])).exists()) {
            System.out.println("Can't find template: " + template);
        }
        File out = new File(args[2]);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.evelopers.unimod.transform.source.ModelToSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ModelToSource ms = ModelToSource.create(LogFactory.getLog((Class)clazz));
        HashMap<String, String> p = new HashMap<String, String>();
        if (args.length > 3) {
            int i = 3;
            while (i < args.length) {
                String[] k = StringHelper.splitString((String)args[i], (String)"=");
                if (k.length < 2) {
                    System.out.println("Can't parse key=value pair: " + args[i]);
                    return;
                }
                System.out.println("add parameter [" + k[0] + "=" + k[1] + "]");
                p.put(k[0], k[1]);
                ++i;
            }
        }
        try {
            ms.generate(template, XMLToModel.loadAndCompile(new FileInputStream(model)), out, p);
        }
        catch (TransformException e) {
            e.getParentException().printStackTrace();
        }
    }
}

