/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.validation;

import com.evelopers.unimod.core.VisitorException;
import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.core.stateworks.Guard;
import com.evelopers.unimod.core.stateworks.State;
import com.evelopers.unimod.core.stateworks.StateMachine;
import com.evelopers.unimod.validation.CompletenessCheckVisitor;
import com.evelopers.unimod.validation.CompletenessListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class CompletenessValidator
extends CompletenessCheckVisitor {
    private List completenessListeners = new ArrayList();

    CompletenessValidator() {
    }

    public boolean addCompletenessListener(CompletenessListener listener) {
        return this.completenessListeners.add(listener);
    }

    public boolean removeCompletenessListener(CompletenessListener listener) {
        return this.completenessListeners.remove(listener);
    }

    public void validateCompleteness(StateMachine sm) {
        if (sm.getTop() == null) {
            throw new IllegalArgumentException("State machine " + sm.getName() + " doesn't have top state");
        }
        this.setSm(sm);
        try {
            sm.getTop().accept(this);
        }
        catch (VisitorException e) {
            e.printStackTrace();
        }
    }

    public void validateCompleteness(StateMachine sm, State state) {
        this.setSm(sm);
        try {
            if (!state.isComposite()) {
                this.checkState(state);
            }
        }
        catch (VisitorException e) {
            e.printStackTrace();
        }
    }

    protected void fireIncompleteGuardSet(StateMachine sm, State state, Event event, Guard guard) {
        Iterator i = this.completenessListeners.iterator();
        while (i.hasNext()) {
            CompletenessListener completenessListener = (CompletenessListener)i.next();
            completenessListener.incompleteGuardSet(sm, state, event, guard);
        }
    }
}

