/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.validation;

import antlr.RecognitionException;
import com.evelopers.unimod.analysis.FormulaResolver;
import com.evelopers.unimod.core.ModelElement;
import com.evelopers.unimod.core.ModelVisitor;
import com.evelopers.unimod.core.VisitorException;
import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.core.stateworks.Guard;
import com.evelopers.unimod.core.stateworks.State;
import com.evelopers.unimod.core.stateworks.StateMachine;
import com.evelopers.unimod.core.stateworks.StateType;
import com.evelopers.unimod.core.stateworks.Transition;
import com.evelopers.unimod.validation.StateTransitionsDecorator;
import java.util.Iterator;
import java.util.List;

abstract class ConsistencyCheckVisitor
implements ModelVisitor {
    private StateMachine sm;

    ConsistencyCheckVisitor() {
    }

    public void setSm(StateMachine sm) {
        this.sm = sm;
    }

    public boolean visit(ModelElement e) throws VisitorException {
        if (e instanceof State) {
            State state = (State)e;
            this.checkState(state);
            return state.isComposite();
        }
        throw new VisitorException(e + " is not a state!");
    }

    protected void checkState(State s) throws VisitorException {
        if (StateType.NORMAL.equals(s.getType())) {
            StateTransitionsDecorator state = new StateTransitionsDecorator(s);
            Iterator i = state.getHandledEvents().iterator();
            while (i.hasNext()) {
                Event event = (Event)i.next();
                int elseCount = s.getFilteredOutgoingTransitions(event, true).size();
                if (elseCount > 1) {
                    this.fireRedundantElseTransitions(this.sm, s, event, elseCount);
                }
                this.checkConsistency(state.getAllNotElseTransitions(event), state.getState());
            }
        } else if (StateType.INITIAL.equals(s.getType())) {
            this.checkConsistency(s.getOutgoingTransitions(), s);
        }
    }

    private void checkConsistency(List allTransitions, State state) throws VisitorException {
        try {
            Iterator i = allTransitions.iterator();
            while (i.hasNext()) {
                Transition transition = (Transition)i.next();
                if (transition.getGuard().getAST() != null) continue;
                i.remove();
            }
            int i2 = 0;
            while (i2 < allTransitions.size()) {
                Transition t1 = (Transition)allTransitions.get(i2);
                if (t1.getSourceState().equals(state)) {
                    int j = i2 + 1;
                    while (j < allTransitions.size()) {
                        Transition t2 = (Transition)allTransitions.get(j);
                        Guard intersection = this.getIntersection(t1, t2);
                        if (intersection != null) {
                            this.fireInconsistentGuardSet(this.sm, t1, t2, intersection);
                        }
                        ++j;
                    }
                }
                ++i2;
            }
        }
        catch (RecognitionException e) {
            throw new VisitorException(e);
        }
    }

    private Guard getIntersection(Transition t1, Transition t2) throws RecognitionException {
        FormulaResolver conjunction = FormulaResolver.createConjunction(t1.getGuard().getAST(), t2.getGuard().getAST());
        if (conjunction.isUnsatisfiable()) {
            return null;
        }
        return this.sm.createGuard(conjunction.getSimplifiedDNF(true));
    }

    protected abstract void fireInconsistentGuardSet(StateMachine var1, Transition var2, Transition var3, Guard var4);

    protected abstract void fireRedundantElseTransitions(StateMachine var1, State var2, Event var3, int var4);
}

