/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.validation;

import com.evelopers.unimod.core.stateworks.State;
import com.evelopers.unimod.core.stateworks.StateMachine;
import com.evelopers.unimod.validation.CompletenessListener;
import com.evelopers.unimod.validation.CompletenessValidator;
import com.evelopers.unimod.validation.ConsistencyListener;
import com.evelopers.unimod.validation.ConsistencyValidator;
import com.evelopers.unimod.validation.StructureListener;
import com.evelopers.unimod.validation.StructureValidator;
import java.util.Collection;

public class StateMachineValidator {
    private StateMachine sm;
    private StructureValidator structureValidator;
    private ConsistencyValidator consistencyValidator;
    private CompletenessValidator completenessValidator;

    public static StateMachineValidator createValidator(StateMachine sm) {
        return new StateMachineValidator(sm);
    }

    protected StateMachineValidator(StateMachine sm) {
        this.sm = sm;
        this.structureValidator = new StructureValidator();
        this.consistencyValidator = new ConsistencyValidator();
        this.completenessValidator = new CompletenessValidator();
    }

    public boolean addStructureListener(StructureListener listener) {
        return this.structureValidator.addStrucutreListener(listener);
    }

    public boolean removeStructureListener(StructureListener listener) {
        return this.structureValidator.removeStrucutreListener(listener);
    }

    public boolean addConsistencyListener(ConsistencyListener listener) {
        return this.consistencyValidator.addConsistencyListener(listener);
    }

    public boolean removeConsistencyListener(ConsistencyListener listener) {
        return this.consistencyValidator.addConsistencyListener(listener);
    }

    public boolean addCompletenessListener(CompletenessListener listener) {
        return this.completenessValidator.addCompletenessListener(listener);
    }

    public boolean removeCompletenessListener(CompletenessListener listener) {
        return this.completenessValidator.addCompletenessListener(listener);
    }

    public void validateStructure() {
        this.structureValidator.validateStructure(this.sm);
    }

    public void validateConsistency() {
        this.consistencyValidator.validateConsistency(this.sm);
    }

    public void validateConsistency(State state) {
        this.consistencyValidator.validateConsistency(this.sm, state);
    }

    public void validateCompleteness() {
        this.completenessValidator.validateCompleteness(this.sm);
    }

    public void validateCompleteness(State state) {
        this.completenessValidator.validateCompleteness(this.sm, state);
    }

    public Collection getAttainableStates() {
        return this.structureValidator.getAttainableStates();
    }

    protected StateMachine getStateMachine() {
        return this.sm;
    }
}

