/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.validation;

import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.core.stateworks.State;
import com.evelopers.unimod.core.stateworks.Transition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class StateTransitionsDecorator {
    private State state;

    public StateTransitionsDecorator(State state) {
        this.state = state;
    }

    public State getState() {
        return this.state;
    }

    public List getAllTransitions() {
        ArrayList transisions = new ArrayList();
        State current = this.state;
        while (current != null) {
            transisions.addAll(current.getOutgoingTransitions());
            current = current.getSuperstate();
        }
        return transisions;
    }

    public List getAllNotElseTransitions(Event event) {
        ArrayList transitions = new ArrayList();
        State current = this.state;
        while (current != null) {
            transitions.addAll(current.getFilteredOutgoingTransitions(event, false));
            current = current.getSuperstate();
        }
        return transitions;
    }

    public Transition getElseTransition(Event event) {
        State current = this.state;
        while (current != null) {
            List t = current.getFilteredOutgoingTransitions(event, true);
            if (t != null && t.size() > 0) {
                return (Transition)t.get(0);
            }
            current = current.getSuperstate();
        }
        return null;
    }

    public Set getHandledEvents() {
        HashSet<Event> events = new HashSet<Event>();
        Iterator i = this.getAllTransitions().iterator();
        while (i.hasNext()) {
            Transition transition = (Transition)i.next();
            Event e = transition.getEvent();
            if (e.equals(Event.ANY)) continue;
            events.add(e);
        }
        return events;
    }
}

