/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.validation;

import com.evelopers.unimod.core.stateworks.State;
import com.evelopers.unimod.core.stateworks.StateMachine;
import com.evelopers.unimod.core.stateworks.StateType;
import com.evelopers.unimod.core.stateworks.Transition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class StructureVisitor {
    protected Set attainableStates = new HashSet();
    protected Set initialStateLess = new HashSet();
    protected Map redundantInitStates = new HashMap();
    protected Set notRootMachinesWithEventProviders = new HashSet();

    public void visit(State state) {
        if (!this.alreadyVisited(state)) {
            this.attainableStates.add(state);
            this.visitIncludedStateMachines(state);
            this.visitInitialState(state);
            this.followTransitions(state);
        }
    }

    protected void visitIncludedStateMachines(State state) {
        Iterator i = state.getSubmachines().iterator();
        while (i.hasNext()) {
            StateMachine sm = (StateMachine)i.next();
            List ep = sm.getEventProviderHandlers();
            if (ep.size() <= 0) continue;
            this.notRootMachinesWithEventProviders.add(sm);
        }
    }

    public Set getNotRootMachinesWithEventProviders() {
        return this.notRootMachinesWithEventProviders;
    }

    public Set getAttainableStates() {
        return this.attainableStates;
    }

    public Set getNoInitState() {
        return this.initialStateLess;
    }

    public Map getRedundantInitStates() {
        return this.redundantInitStates;
    }

    private void visitInitialState(State state) {
        if (state.isComposite()) {
            int initStateNumber = 0;
            Iterator i = state.getSubstates().iterator();
            while (i.hasNext()) {
                State substate = (State)i.next();
                if (!StateType.INITIAL.equals(substate.getType())) continue;
                ++initStateNumber;
                this.visit(substate);
            }
            if (initStateNumber == 0) {
                this.initialStateLess.add(state);
            } else if (initStateNumber > 1) {
                this.redundantInitStates.put(state, new Integer(initStateNumber));
            }
        }
    }

    private void followTransitions(State state) {
        if (state.hasSuperstate()) {
            this.followTransitions(state.getSuperstate());
        }
        List transitions = state.getOutgoingTransitions();
        Iterator i = transitions.iterator();
        while (i.hasNext()) {
            this.visit(((Transition)i.next()).getTargetState());
        }
    }

    private boolean alreadyVisited(State state) {
        return this.attainableStates.contains(state);
    }
}

