/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.validation;

import com.evelopers.unimod.compilation.DefaultCompilationListener;
import com.evelopers.unimod.compilation.StateMachineCompiler;
import com.evelopers.unimod.core.stateworks.StateMachine;
import com.evelopers.unimod.transform.TransformException;
import com.evelopers.unimod.transform.xml.XMLToModel;
import com.evelopers.unimod.validation.StateMachineValidator;
import com.evelopers.unimod.validation.ValidationMessenger;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ValidationTool {
    private StateMachineValidator validator;
    private StateMachine stateMachine;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java ValidationTool <StateMachine>.xml");
        } else {
            try {
                ValidationTool vt = new ValidationTool(new FileInputStream(args[0]));
                if (vt.compile()) {
                    vt.validate();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("File " + args[0] + " was not found");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public ValidationTool(InputStream inputXML) throws IOException, SAXException, TransformException, ParserConfigurationException {
        this.stateMachine = this.transformXMLToStateMachine(inputXML);
        ValidationMessenger validationMessanger = new ValidationMessenger();
        this.validator = StateMachineValidator.createValidator(this.stateMachine);
        this.validator.addStructureListener(validationMessanger);
        this.validator.addConsistencyListener(validationMessanger);
        this.validator.addCompletenessListener(validationMessanger);
    }

    public boolean compile() {
        StateMachineCompiler smc = new StateMachineCompiler(null);
        DefaultCompilationListener dcl = new DefaultCompilationListener();
        smc.addCompilationListener(dcl);
        smc.compileWithIncluded(this.stateMachine);
        if (dcl.getErrors() != null && dcl.getErrors().length > 0) {
            System.out.println("State machine compilation errors:");
            int i = 0;
            while (i < dcl.getErrors().length) {
                System.out.println(dcl.getErrors()[i]);
                ++i;
            }
            System.out.println("Validation cancelled.");
            return false;
        }
        return true;
    }

    public StateMachineValidator getValidator() {
        return this.validator;
    }

    public void validate() {
        this.validator.validateStructure();
        this.validator.validateConsistency();
        this.validator.validateCompleteness();
    }

    private StateMachine transformXMLToStateMachine(InputStream inputXML) throws IOException, SAXException, TransformException, ParserConfigurationException {
        XMLToModel transformer = XMLToModel.create();
        return transformer.transform(inputXML).getRootStateMachine();
    }
}

