/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.net.SocketAddress;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.mina.common.CloseFuture;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.TransportType;
import org.apache.mina.common.support.AbstractIoFilterChain;
import org.apache.mina.common.support.BaseIoSession;

public class IoFilterChainTest
extends TestCase {
    private IoFilterChainImpl chain;
    private IoSession session;
    private String result;

    public void setUp() {
        this.chain = new IoFilterChainImpl();
        this.session = new TestSession();
        this.result = "";
    }

    public void tearDown() {
    }

    public void testAdd() throws Exception {
        this.chain.addFirst("A", new EventOrderTestFilter('A'));
        this.chain.addLast("B", new EventOrderTestFilter('A'));
        this.chain.addFirst("C", new EventOrderTestFilter('A'));
        this.chain.addLast("D", new EventOrderTestFilter('A'));
        this.chain.addBefore("B", "E", new EventOrderTestFilter('A'));
        this.chain.addBefore("C", "F", new EventOrderTestFilter('A'));
        this.chain.addAfter("B", "G", new EventOrderTestFilter('A'));
        this.chain.addAfter("D", "H", new EventOrderTestFilter('A'));
        String actual = "";
        for (IoFilterChain.Entry e : this.chain.getAll()) {
            actual = String.valueOf(actual) + e.getName();
        }
        Assert.assertEquals((String)"FCAEBGDH", (String)actual);
    }

    public void testGet() throws Exception {
        IoFilterAdapter filterA = new IoFilterAdapter();
        IoFilterAdapter filterB = new IoFilterAdapter();
        IoFilterAdapter filterC = new IoFilterAdapter();
        IoFilterAdapter filterD = new IoFilterAdapter();
        this.chain.addFirst("A", filterA);
        this.chain.addLast("B", filterB);
        this.chain.addBefore("B", "C", filterC);
        this.chain.addAfter("A", "D", filterD);
        Assert.assertSame((Object)filterA, (Object)this.chain.get("A"));
        Assert.assertSame((Object)filterB, (Object)this.chain.get("B"));
        Assert.assertSame((Object)filterC, (Object)this.chain.get("C"));
        Assert.assertSame((Object)filterD, (Object)this.chain.get("D"));
    }

    public void testRemove() throws Exception {
        this.chain.addLast("A", new EventOrderTestFilter('A'));
        this.chain.addLast("B", new EventOrderTestFilter('A'));
        this.chain.addLast("C", new EventOrderTestFilter('A'));
        this.chain.addLast("D", new EventOrderTestFilter('A'));
        this.chain.addLast("E", new EventOrderTestFilter('A'));
        this.chain.remove("A");
        this.chain.remove("E");
        this.chain.remove("C");
        this.chain.remove("B");
        this.chain.remove("D");
        Assert.assertEquals((int)0, (int)this.chain.getAll().size());
    }

    public void testClear() throws Exception {
        this.chain.addLast("A", new EventOrderTestFilter('A'));
        this.chain.addLast("B", new EventOrderTestFilter('A'));
        this.chain.addLast("C", new EventOrderTestFilter('A'));
        this.chain.addLast("D", new EventOrderTestFilter('A'));
        this.chain.addLast("E", new EventOrderTestFilter('A'));
        this.chain.clear();
        Assert.assertEquals((int)0, (int)this.chain.getAll().size());
    }

    public void testToString() throws Exception {
        Assert.assertEquals((String)"{ empty }", (String)this.chain.toString());
        this.chain.addLast("A", new IoFilterAdapter(){

            public String toString() {
                return "B";
            }
        });
        Assert.assertEquals((String)"{ (A:B) }", (String)this.chain.toString());
        this.chain.addLast("C", new IoFilterAdapter(){

            public String toString() {
                return "D";
            }
        });
        Assert.assertEquals((String)"{ (A:B), (C:D) }", (String)this.chain.toString());
    }

    public void testDefault() {
        this.run("HS0 HSO HMR HMS HSI HEC HSC");
    }

    public void testChained() throws Exception {
        this.chain.addLast("A", new EventOrderTestFilter('A'));
        this.chain.addLast("B", new EventOrderTestFilter('B'));
        this.run("AS0 BS0 HS0ASO BSO HSOAMR BMR HMRBFW AFW AMS BMS HMSASI BSI HSIAEC BEC HECASC BSC HSC");
    }

    public void testAddRemove() throws Exception {
        AddRemoveTestFilter filter = new AddRemoveTestFilter();
        this.chain.addFirst("A", filter);
        IoFilterChainTest.assertEquals((String)"ADDED", (String)this.result);
        this.chain.remove("A");
        IoFilterChainTest.assertEquals((String)"ADDEDREMOVED", (String)this.result);
    }

    private void run(String expectedResult) {
        this.chain.fireSessionCreated(this.session);
        this.chain.fireSessionOpened(this.session);
        this.chain.fireMessageReceived(this.session, new Object());
        this.chain.fireFilterWrite(this.session, new IoFilter.WriteRequest(new Object()));
        this.chain.fireSessionIdle(this.session, IdleStatus.READER_IDLE);
        this.chain.fireExceptionCaught(this.session, new Exception());
        this.chain.fireSessionClosed(this.session);
        this.result = this.formatResult(this.result);
        expectedResult = this.formatResult(expectedResult);
        System.out.println("Expected: " + expectedResult);
        System.out.println("Actual:   " + this.result);
        Assert.assertEquals((String)expectedResult, (String)this.result);
    }

    private String formatResult(String result) {
        result = result.replaceAll("\\s", "");
        StringBuffer buf = new StringBuffer(result.length() * 4 / 3);
        int i = 0;
        while (i < result.length()) {
            buf.append(result.charAt(i));
            if (i % 3 == 2) {
                buf.append(' ');
            }
            ++i;
        }
        return buf.toString();
    }

    private class AddRemoveTestFilter
    extends IoFilterAdapter {
        private AddRemoveTestFilter() {
        }

        public void onPostAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) {
            IoFilterChainTest ioFilterChainTest = IoFilterChainTest.this;
            ioFilterChainTest.result = String.valueOf(ioFilterChainTest.result) + "ADDED";
        }

        public void onPostRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) {
            IoFilterChainTest ioFilterChainTest = IoFilterChainTest.this;
            ioFilterChainTest.result = String.valueOf(ioFilterChainTest.result) + "REMOVED";
        }
    }

    private class EventOrderTestFilter
    extends IoFilterAdapter {
        private final char id;

        private EventOrderTestFilter(char id) {
            this.id = id;
        }

        public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) {
            IoFilterChainTest ioFilterChainTest = IoFilterChainTest.this;
            ioFilterChainTest.result = String.valueOf(ioFilterChainTest.result) + this.id + "S0";
            nextFilter.sessionCreated(session);
        }

        public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) {
            IoFilterChainTest ioFilterChainTest = IoFilterChainTest.this;
            ioFilterChainTest.result = String.valueOf(ioFilterChainTest.result) + this.id + "SO";
            nextFilter.sessionOpened(session);
        }

        public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) {
            IoFilterChainTest ioFilterChainTest = IoFilterChainTest.this;
            ioFilterChainTest.result = String.valueOf(ioFilterChainTest.result) + this.id + "SC";
            nextFilter.sessionClosed(session);
        }

        public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) {
            IoFilterChainTest ioFilterChainTest = IoFilterChainTest.this;
            ioFilterChainTest.result = String.valueOf(ioFilterChainTest.result) + this.id + "SI";
            nextFilter.sessionIdle(session, status);
        }

        public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) {
            IoFilterChainTest ioFilterChainTest = IoFilterChainTest.this;
            ioFilterChainTest.result = String.valueOf(ioFilterChainTest.result) + this.id + "EC";
            nextFilter.exceptionCaught(session, cause);
        }

        public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, IoFilter.WriteRequest writeRequest) {
            IoFilterChainTest ioFilterChainTest = IoFilterChainTest.this;
            ioFilterChainTest.result = String.valueOf(ioFilterChainTest.result) + this.id + "FW";
            nextFilter.filterWrite(session, writeRequest);
        }

        public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) {
            IoFilterChainTest ioFilterChainTest = IoFilterChainTest.this;
            ioFilterChainTest.result = String.valueOf(ioFilterChainTest.result) + this.id + "MR";
            nextFilter.messageReceived(session, message);
        }

        public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, Object message) {
            IoFilterChainTest ioFilterChainTest = IoFilterChainTest.this;
            ioFilterChainTest.result = String.valueOf(ioFilterChainTest.result) + this.id + "MS";
            nextFilter.messageSent(session, message);
        }

        public void filterClose(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
            nextFilter.filterClose(session);
        }
    }

    private static class IoFilterChainImpl
    extends AbstractIoFilterChain {
        protected IoFilterChainImpl() {
            super(new BaseIoSession(){

                protected void updateTrafficMask() {
                }

                public IoService getService() {
                    return null;
                }

                public IoHandler getHandler() {
                    return null;
                }

                public IoFilterChain getFilterChain() {
                    return null;
                }

                public TransportType getTransportType() {
                    return null;
                }

                public SocketAddress getRemoteAddress() {
                    return null;
                }

                public SocketAddress getLocalAddress() {
                    return null;
                }

                public int getScheduledWriteRequests() {
                    return 0;
                }

                public IoSessionConfig getConfig() {
                    return null;
                }

                public SocketAddress getServiceAddress() {
                    return null;
                }

                public int getScheduledWriteBytes() {
                    return 0;
                }

                public IoServiceConfig getServiceConfig() {
                    return null;
                }
            });
        }

        protected void doWrite(IoSession session, IoFilter.WriteRequest writeRequest) {
            this.fireMessageSent(session, writeRequest);
        }

        protected void doClose(IoSession session) {
        }
    }

    private class TestSession
    extends BaseIoSession
    implements IoSession {
        private IoHandler handler = new IoHandlerAdapter(){

            public void sessionCreated(IoSession session) {
                IoFilterChainTest ioFilterChainTest = IoFilterChainTest.this;
                ioFilterChainTest.result = String.valueOf(ioFilterChainTest.result) + "HS0";
            }

            public void sessionOpened(IoSession session) {
                IoFilterChainTest ioFilterChainTest = IoFilterChainTest.this;
                ioFilterChainTest.result = String.valueOf(ioFilterChainTest.result) + "HSO";
            }

            public void sessionClosed(IoSession session) {
                IoFilterChainTest ioFilterChainTest = IoFilterChainTest.this;
                ioFilterChainTest.result = String.valueOf(ioFilterChainTest.result) + "HSC";
            }

            public void sessionIdle(IoSession session, IdleStatus status) {
                IoFilterChainTest ioFilterChainTest = IoFilterChainTest.this;
                ioFilterChainTest.result = String.valueOf(ioFilterChainTest.result) + "HSI";
            }

            public void exceptionCaught(IoSession session, Throwable cause) {
                IoFilterChainTest ioFilterChainTest = IoFilterChainTest.this;
                ioFilterChainTest.result = String.valueOf(ioFilterChainTest.result) + "HEC";
                if (cause.getClass() != Exception.class) {
                    cause.printStackTrace(System.out);
                }
            }

            public void messageReceived(IoSession session, Object message) {
                IoFilterChainTest ioFilterChainTest = IoFilterChainTest.this;
                ioFilterChainTest.result = String.valueOf(ioFilterChainTest.result) + "HMR";
            }

            public void messageSent(IoSession session, Object message) {
                IoFilterChainTest ioFilterChainTest = IoFilterChainTest.this;
                ioFilterChainTest.result = String.valueOf(ioFilterChainTest.result) + "HMS";
            }
        };

        private TestSession() {
        }

        public IoHandler getHandler() {
            return this.handler;
        }

        public CloseFuture close() {
            return null;
        }

        public TransportType getTransportType() {
            return TransportType.VM_PIPE;
        }

        public SocketAddress getRemoteAddress() {
            return null;
        }

        public SocketAddress getLocalAddress() {
            return null;
        }

        public IoFilterChain getFilterChain() {
            return new AbstractIoFilterChain(this){

                protected void doWrite(IoSession session, IoFilter.WriteRequest writeRequest) {
                }

                protected void doClose(IoSession session) {
                }
            };
        }

        public int getScheduledWriteRequests() {
            return 0;
        }

        protected void updateTrafficMask() {
        }

        public boolean isClosing() {
            return false;
        }

        public IoService getService() {
            return null;
        }

        public IoSessionConfig getConfig() {
            return null;
        }

        public SocketAddress getServiceAddress() {
            return null;
        }

        public int getScheduledWriteBytes() {
            return 0;
        }

        public IoServiceConfig getServiceConfig() {
            return null;
        }
    }
}

