/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common.support;

import java.io.IOException;
import java.net.SocketAddress;
import junit.framework.TestCase;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.TransportType;
import org.apache.mina.common.support.BaseIoSession;
import org.apache.mina.common.support.DefaultCloseFuture;
import org.apache.mina.common.support.DefaultConnectFuture;
import org.apache.mina.common.support.DefaultWriteFuture;

public class FutureTest
extends TestCase {
    public void testCloseFuture() throws Exception {
        DefaultCloseFuture future = new DefaultCloseFuture(null);
        FutureTest.assertFalse((boolean)future.isReady());
        FutureTest.assertFalse((boolean)future.isClosed());
        TestThread thread = new TestThread(future);
        thread.start();
        future.setClosed();
        thread.join();
        FutureTest.assertTrue((boolean)thread.success);
        FutureTest.assertTrue((boolean)future.isReady());
        FutureTest.assertTrue((boolean)future.isClosed());
    }

    public void testConnectFuture() throws Exception {
        DefaultConnectFuture future = new DefaultConnectFuture();
        FutureTest.assertFalse((boolean)future.isReady());
        FutureTest.assertFalse((boolean)future.isConnected());
        FutureTest.assertNull((Object)future.getSession());
        TestThread thread = new TestThread(future);
        thread.start();
        BaseIoSession session = new BaseIoSession(){

            public IoHandler getHandler() {
                return null;
            }

            public IoFilterChain getFilterChain() {
                return null;
            }

            public TransportType getTransportType() {
                return null;
            }

            public SocketAddress getRemoteAddress() {
                return null;
            }

            public SocketAddress getLocalAddress() {
                return null;
            }

            public int getScheduledWriteRequests() {
                return 0;
            }

            protected void updateTrafficMask() {
            }

            public boolean isClosing() {
                return false;
            }

            public IoService getService() {
                return null;
            }

            public IoSessionConfig getConfig() {
                return null;
            }

            public SocketAddress getServiceAddress() {
                return null;
            }

            public int getScheduledWriteBytes() {
                return 0;
            }

            public IoServiceConfig getServiceConfig() {
                return null;
            }
        };
        future.setSession(session);
        thread.join();
        FutureTest.assertTrue((boolean)thread.success);
        FutureTest.assertTrue((boolean)future.isReady());
        FutureTest.assertTrue((boolean)future.isConnected());
        FutureTest.assertEquals((Object)session, (Object)future.getSession());
        future = new DefaultConnectFuture();
        thread = new TestThread(future);
        thread.start();
        future.setException(new IOException());
        thread.join();
        FutureTest.assertTrue((boolean)thread.success);
        FutureTest.assertTrue((boolean)future.isReady());
        FutureTest.assertFalse((boolean)future.isConnected());
        try {
            future.getSession();
            FutureTest.fail((String)"IOException should be thrown.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testWriteFuture() throws Exception {
        DefaultWriteFuture future = new DefaultWriteFuture(null);
        FutureTest.assertFalse((boolean)future.isReady());
        FutureTest.assertFalse((boolean)future.isWritten());
        TestThread thread = new TestThread(future);
        thread.start();
        future.setWritten(true);
        thread.join();
        FutureTest.assertTrue((boolean)thread.success);
        FutureTest.assertTrue((boolean)future.isReady());
        FutureTest.assertTrue((boolean)future.isWritten());
        future = new DefaultWriteFuture(null);
        thread = new TestThread(future);
        thread.start();
        future.setWritten(false);
        thread.join();
        FutureTest.assertTrue((boolean)thread.success);
        FutureTest.assertTrue((boolean)future.isReady());
        FutureTest.assertFalse((boolean)future.isWritten());
    }

    public void testAddListener() throws Exception {
        DefaultCloseFuture future = new DefaultCloseFuture(null);
        FutureTest.assertFalse((boolean)future.isReady());
        FutureTest.assertFalse((boolean)future.isClosed());
        TestListener listener1 = new TestListener();
        TestListener listener2 = new TestListener();
        future.addListener(listener1);
        future.addListener(listener2);
        TestThread thread = new TestThread(future);
        thread.start();
        future.setClosed();
        thread.join();
        FutureTest.assertTrue((boolean)thread.success);
        FutureTest.assertTrue((boolean)future.isReady());
        FutureTest.assertTrue((boolean)future.isClosed());
        FutureTest.assertSame((Object)future, (Object)listener1.notifiedFuture);
        FutureTest.assertSame((Object)future, (Object)listener2.notifiedFuture);
    }

    public void testLateAddListener() throws Exception {
        DefaultCloseFuture future = new DefaultCloseFuture(null);
        FutureTest.assertFalse((boolean)future.isReady());
        FutureTest.assertFalse((boolean)future.isClosed());
        TestThread thread = new TestThread(future);
        thread.start();
        future.setClosed();
        thread.join();
        FutureTest.assertTrue((boolean)thread.success);
        FutureTest.assertTrue((boolean)future.isReady());
        FutureTest.assertTrue((boolean)future.isClosed());
        TestListener listener = new TestListener();
        future.addListener(listener);
        FutureTest.assertSame((Object)future, (Object)listener.notifiedFuture);
    }

    public void testRemoveListener1() throws Exception {
        DefaultCloseFuture future = new DefaultCloseFuture(null);
        FutureTest.assertFalse((boolean)future.isReady());
        FutureTest.assertFalse((boolean)future.isClosed());
        TestListener listener1 = new TestListener();
        TestListener listener2 = new TestListener();
        future.addListener(listener1);
        future.addListener(listener2);
        future.removeListener(listener1);
        TestThread thread = new TestThread(future);
        thread.start();
        future.setClosed();
        thread.join();
        FutureTest.assertTrue((boolean)thread.success);
        FutureTest.assertTrue((boolean)future.isReady());
        FutureTest.assertTrue((boolean)future.isClosed());
        FutureTest.assertSame(null, (Object)listener1.notifiedFuture);
        FutureTest.assertSame((Object)future, (Object)listener2.notifiedFuture);
    }

    public void testRemoveListener2() throws Exception {
        DefaultCloseFuture future = new DefaultCloseFuture(null);
        FutureTest.assertFalse((boolean)future.isReady());
        FutureTest.assertFalse((boolean)future.isClosed());
        TestListener listener1 = new TestListener();
        TestListener listener2 = new TestListener();
        future.addListener(listener1);
        future.addListener(listener2);
        future.removeListener(listener2);
        TestThread thread = new TestThread(future);
        thread.start();
        future.setClosed();
        thread.join();
        FutureTest.assertTrue((boolean)thread.success);
        FutureTest.assertTrue((boolean)future.isReady());
        FutureTest.assertTrue((boolean)future.isClosed());
        FutureTest.assertSame((Object)future, (Object)listener1.notifiedFuture);
        FutureTest.assertSame(null, (Object)listener2.notifiedFuture);
    }

    private static class TestListener
    implements IoFutureListener {
        private IoFuture notifiedFuture;

        private TestListener() {
        }

        public void operationComplete(IoFuture future) {
            this.notifiedFuture = future;
        }
    }

    private static class TestThread
    extends Thread {
        private final IoFuture future;
        private boolean success;

        TestThread(IoFuture future) {
            this.future = future;
        }

        public void run() {
            this.success = this.future.join(10000L);
        }
    }
}

